# バッチ設計書 2-label-issue

## 概要

本ドキュメントは、GitHub Issueへの自動ラベル付与処理バッチ「label-issue.ts」の設計仕様を記載する。

### 本バッチの処理概要

新規に作成されたGitHub IssueにClaude AIを使用して自動的にラベルを付与する処理を行う。Issueのタイトルと本文をAIで分析し、事前定義された70以上のラベルから適切なものを選択して付与する。

**業務上の目的・背景**：大規模なオープンソースプロジェクトでは、日々多くのIssueが報告される。適切なラベル付けはIssueの分類・優先度付け・担当者割り当てに不可欠だが、手動でのラベル付けは時間がかかり、担当者によってばらつきが生じる。本バッチはAIを活用することで、一貫性のあるラベル付けを自動化し、開発チームの作業効率を向上させる。

**バッチの実行タイミング**：新規Issue作成時にGitHub Actionsワークフローから呼び出される。

**主要な処理内容**：
1. ANTHROPIC_API_KEY環境変数を使用してClaude APIへの認証を行う
2. 環境変数からIssueのタイトルと本文を取得
3. 事前定義された70以上のラベル定義をプロンプトとして構築
4. Claude 3.5 Sonnet APIにIssue内容を送信し、関連ラベルをJSON配列で取得
5. 返却されたラベルを検証し、存在するラベルのみをフィルタリング
6. カンマ区切りでラベル名を標準出力に出力

**前後の処理との関連**：GitHub Actionsワークフローで新規Issue作成イベントをトリガーとして実行される。出力されたラベル名は後続のワークフローステップでIssueに付与される。

**影響範囲**：新規作成されたGitHub Issueへのラベル付与に影響する。

## バッチ種別

AIデータ分析 / 自動分類

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（Issue作成時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions（issues.opened イベント） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ANTHROPIC_API_KEY | Claude API認証キーが環境変数として設定されていること |
| GITHUB_ISSUE_TITLE | Issueのタイトルが環境変数として設定されていること |
| GITHUB_ISSUE_BODY | Issueの本文が環境変数として設定されていること |

### 実行可否判定

- ANTHROPIC_API_KEYが未設定の場合はAPIエラー
- Issueタイトル・本文が空の場合も処理は実行される

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| ANTHROPIC_API_KEY | string | Yes | - | Claude API認証キー |
| GITHUB_ISSUE_TITLE | string | Yes | - | Issueのタイトル |
| GITHUB_ISSUE_BODY | string | Yes | - | Issueの本文 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 | 文字列 | Issueのタイトルと本文 |
| ラベル定義配列 | TypeScript配列 | 70+件の{name, description}オブジェクト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | カンマ区切りのラベル名リスト |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）

## 処理フロー

### 処理シーケンス

```
1. ラベル定義の準備
   └─ 70+件のラベル名と説明を配列として保持

2. Anthropic SDKの初期化
   └─ ANTHROPIC_API_KEYを使用してクライアント作成

3. Issueデータの取得
   └─ 環境変数からタイトルと本文を取得

4. Claude APIへのリクエスト
   └─ claude-3-5-sonnet-20240620モデルにラベル分類を依頼

5. レスポンスのパース
   └─ JSON配列をパースしてラベル名リストを取得

6. ラベルの検証
   └─ 存在しないラベル名をフィルタリング

7. 結果出力
   └─ カンマ区切りで標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[ラベル定義準備]
    B --> C[Anthropic SDK初期化]
    C --> D[Issue情報取得]
    D --> E[Claude API呼び出し]
    E --> F{レスポンス正常?}
    F -->|はい| G[JSONパース]
    F -->|いいえ| H[エラー終了]
    G --> I{ラベルあり?}
    I -->|なし| J[exit 0]
    I -->|あり| K[ラベル検証]
    K --> L{有効ラベルあり?}
    L -->|なし| J
    L -->|あり| M[カンマ区切り出力]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象API | 操作種別 | 概要 |
|-----|---------|---------|------|
| ラベル分類 | Anthropic Messages API | POST | Claude AIによるラベル分類 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | API認証エラー | ANTHROPIC_API_KEY未設定/無効 | エラー終了 |
| - | レスポンスパースエラー | Claude応答がJSON配列でない | 配列開始位置を検索してリカバリ |
| - | ラベルなし | 関連ラベルが見つからない | exit 0で正常終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（Anthropic SDK任せ） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- ラベルが見つからない場合はexit 0で正常終了（ラベル付与なし）
- APIエラーの場合はエラーメッセージを出力して終了

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし（単一API呼び出し） |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（1 Issue） |
| 目標処理時間 | 数秒（Claude API応答時間に依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

Issue単位で独立して実行されるため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | ラベルなし時 | "No relevant labels found" |
| 結果出力 | 処理完了時 | カンマ区切りラベル名 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | - | GitHub Actions UI |
| エラー発生 | - | GitHub Actions UI |

## 備考

### 定義済みラベル一覧（抜粋）

- **プラットフォーム**: linux, macOS, windows, docker
- **Bunモジュール**: bun:crypto, bun:dns, bun:ffi, bun:fs, bun:glob, bun:http, bun:serve, bun:spawn, bun:sqlite, bun:tcp, bun:udp
- **Node.jsモジュール**: node:crypto, node:dgram, node:dns, node:fs, node:http, node:http2, node:net, node:os, node:path, node:process, node:stream, node:tty, node:util, node:v8
- **Web API**: web:blob, web:crypto, web:encoding, web:fetch, web:performance, web:stream, web:url, web:websocket
- **ツール**: bundler, bunx, cli, debugger, jest, minifier, npm, repl, shell, transpiler
- **その他**: build, cjs, docs, ecosystem, enhancement, idea, infrastructure, jsc, lambda, napi, performance, runtime, sourcemaps, types, typescript, vscode, wasm, wintercg

### Claude APIモデル

- 使用モデル: claude-3-5-sonnet-20240620
- 最大トークン: 2048
