# バッチ設計書 20-is-outdated.ts

## 概要

本ドキュメントは、GitHub Issueに記載されたBunバージョンが最新かどうかをチェックするバッチ処理「is-outdated.ts」の設計書です。

### 本バッチの処理概要

GitHub Issue本文からBunのバージョン情報を抽出し、LATESTファイルに記載された最新バージョンと比較して、古いバージョンかどうかを判定し結果をファイルに出力するバッチ処理です。

**業務上の目的・背景**：バグ報告されたIssueの中には、既に修正済みの古いバージョンに関するものが含まれていることがあります。このバッチは、Issue本文からバージョン情報を自動抽出し、最新バージョンとの比較を行うことで、古いバージョンでの報告を自動検出します。これにより、ユーザーへの更新案内や、トリアージの効率化が可能になります。

**バッチの実行タイミング**：GitHub Actionsワークフローにおいて、Issue作成時にトリガーされます。

**主要な処理内容**：
1. 環境変数からGitHub Issue本文を取得
2. LATESTファイルから最新バージョンを読み込み
3. スタンドアロン実行可能ファイルかどうかを判定
4. Issue本文を逆順でスキャンし、`Bun vX.X.X on ...`形式の行を検出
5. バージョンをsemver比較で最新版と比較
6. 古いバージョンの場合、is-outdated.txt等にフラグを出力
7. 非常に古いバージョン（メジャー/マイナーが異なる、またはパッチが3以上離れている）の場合、is-very-outdated.txtを出力

**前後の処理との関連**：出力されたフラグファイルは、後続のGitHub Actionsステップでコメント追加やラベル付与に使用されます。

**影響範囲**：ローカルファイルへの出力のみで、GitHub IssueやBun本体への影響はありません。

## バッチ種別

バージョン判定 / データ解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（Issue作成時） |
| 実行時刻 | 随時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | GitHub Actions（Issue作成イベント） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_ISSUE_BODY | 環境変数にIssue本文が設定されていること |
| LATEST | プロジェクトルートにLATESTファイルが存在すること |

### 実行可否判定

GITHUB_ISSUE_BODY環境変数が設定されていない場合、エラーをスローして終了します。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_ISSUE_BODY | string | Yes | なし | GitHub Issue本文（環境変数） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 | 文字列 | GitHub Issue本文 |
| LATEST | テキスト | 最新バージョン番号 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| is-outdated.txt | テキスト | 古いバージョンの場合 "true" |
| outdated.txt | テキスト | Issue記載のバージョン番号 |
| is-standalone.txt | テキスト | スタンドアロン実行可能ファイルの場合 "true" |
| is-very-outdated.txt | テキスト | 非常に古いバージョンの場合 "true" |
| 標準出力 | JSON | latest/versionの比較情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | カレントディレクトリ |
| 文字コード | UTF-8 |
| 内容 | "true" または バージョン番号 |

## 処理フロー

### 処理シーケンス

```
1. 環境変数取得
   └─ GITHUB_ISSUE_BODYを取得

2. 最新バージョン取得
   └─ LATESTファイルを読み込み

3. スタンドアロン判定
   └─ "standalone_executable"を含むか確認

4. バージョン検出
   └─ Issue本文を逆順スキャンして"Bun v..."行を検索

5. バージョン検証
   └─ canary版の場合は正常終了
   └─ semverとして有効か検証

6. バージョン比較
   └─ Bun.semver.orderで比較

7. フラグ出力
   └─ 古いバージョンの場合、各フラグファイルを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{GITHUB_ISSUE_BODY存在?}
    B -->|なし| C[エラー終了]
    B -->|あり| D[LATESTファイル読込]
    D --> E[スタンドアロン判定]
    E --> F[バージョン行検索]
    F --> G{バージョン検出?}
    G -->|なし| H[正常終了]
    G -->|あり| I{canary版?}
    I -->|はい| J[正常終了]
    I -->|いいえ| K{有効なsemver?}
    K -->|いいえ| L[警告出力・終了]
    K -->|はい| M{最新と同じ?}
    M -->|はい| N[正常終了]
    M -->|いいえ| O{古いバージョン?}
    O -->|いいえ| P[正常終了]
    O -->|はい| Q[is-outdated.txt出力]
    Q --> R[outdated.txt出力]
    R --> S{スタンドアロン?}
    S -->|はい| T[is-standalone.txt出力]
    S -->|いいえ| U{非常に古い?}
    T --> U
    U -->|はい| V[is-very-outdated.txt出力]
    U -->|いいえ| W[正常終了]
    V --> W
```

## バージョン比較ロジック

### 古いバージョンの判定

```typescript
Bun.semver.order(latest, version) === 1
```

latest > version の場合、古いバージョンと判定されます。

### 非常に古いバージョンの判定

以下のいずれかの条件を満たす場合：
- メジャーバージョンが異なる
- マイナーバージョンが異なる
- パッチバージョンの差が3より大きい

## バージョン検出パターン

Issue本文から以下のパターンを検出：

```
Bun vX.X.X on <platform>
```

例：
- `Bun v1.0.0 on linux-x64`
- `Bun v1.1.0 on macos-arm64`

## データベース操作仕様

データベース操作はありません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Error | GITHUB_ISSUE_BODY未設定 | 環境変数を設定 |
| 1 | Warning | 無効なsemver | Issue本文を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 環境変数GITHUB_ISSUE_BODYの設定を確認
2. LATESTファイルの存在と内容を確認
3. Issue本文にバージョン情報が含まれているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件/実行 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行可能です。排他制御は不要です。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 古いバージョン検出時 | `{ latest, version }` |
| 標準出力 | 非常に古い場合 | `Very outdated` |
| 警告 | 無効なsemver | `Version is not a valid semver` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 特になし | - | - |

## 備考

- Issue本文を逆順でスキャンするのは、最も新しいバージョン情報を取得するためです
- canary版のバージョンは比較対象外となります
- スタンドアロン実行可能ファイル（standalone_executable）は別途フラグで追跡されます
- Bun.semverはBun組み込みのsemver比較機能です
