# バッチ設計書 3-handle-crash-patterns

## 概要

本ドキュメントは、クラッシュパターン検出とIssue自動クローズ処理バッチ「handle-crash-patterns.ts」の設計仕様を記載する。

### 本バッチの処理概要

GitHub Issueの内容から既知のクラッシュパターンを検出し、該当する場合にIssueを適切なコメントと共に自動クローズする処理を行う。既知の問題や修正済みの問題に対するIssue報告を効率的に処理する。

**業務上の目的・背景**：Bunプロジェクトでは、特定のクラッシュパターンや既知の問題が繰り返し報告されることがある。これらは既にトラッキングされているIssueの重複であったり、既に修正済みのバージョンで解決されている場合がある。本バッチは、これらの既知パターンを自動検出し、ユーザーに適切な情報を提供しながらIssueをクローズすることで、開発チームの対応負荷を軽減し、ユーザーへの迅速な回答を可能にする。

**バッチの実行タイミング**：新規Issue作成時にGitHub Actionsワークフローから呼び出される。

**主要な処理内容**：
1. 環境変数からIssueのタイトル、本文、Issue番号を取得
2. Issue内容を小文字に変換し、パターンマッチングを実行
3. 以下のクラッシュパターンを検出：
   - workers_terminated（Worker終了問題）
   - better-sqlite3 + RunCommand/AutoCommand（V8 API非対応）
   - ENOTCONN + Transport + standalone_executable + v1.2.23（修正済み問題）
   - wasm_trampoline_wasm_ipint_call_wide32（WASM IPInt問題）
   - Segmentation Fault/Illegal Instruction + no_avx（CPU要件問題）
4. パターンにマッチした場合、クローズ理由とコメント内容をJSON形式で出力
5. パターンにマッチしない場合は`{close: false}`を出力

**前後の処理との関連**：GitHub Actionsワークフローで新規Issue作成イベントをトリガーとして実行される。出力されたJSONは後続のワークフローステップでIssueのクローズ処理に使用される。

**影響範囲**：新規作成されたGitHub Issueのステータス（オープン→クローズ）に影響する可能性がある。

## バッチ種別

パターンマッチング / 自動分類・クローズ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（Issue作成時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions（issues.opened イベント） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_ISSUE_BODY | Issueの本文が環境変数として設定されていること |
| GITHUB_ISSUE_TITLE | Issueのタイトルが環境変数として設定されていること |
| GITHUB_ISSUE_NUMBER | IssueのIssue番号が環境変数として設定されていること |

### 実行可否判定

- GITHUB_ISSUE_NUMBERが未設定の場合はエラー終了
- GITHUB_ISSUE_BODYが空でも処理は実行される

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GITHUB_ISSUE_BODY | string | No | "" | Issueの本文 |
| GITHUB_ISSUE_TITLE | string | No | "" | Issueのタイトル |
| GITHUB_ISSUE_NUMBER | string | Yes | - | Issue番号 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 環境変数 | 文字列 | Issueのタイトル、本文、番号 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | JSON | クローズ判定結果とコメント内容 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）

**出力JSONフォーマット**：

パターンマッチ時：
```json
{
  "close": true,
  "reason": "not_planned" | "completed",
  "comment": "クローズ時のコメント内容"
}
```

パターン非マッチ時：
```json
{
  "close": false
}
```

## 処理フロー

### 処理シーケンス

```
1. 環境変数チェック
   └─ GITHUB_ISSUE_NUMBERの存在確認

2. Issue内容の正規化
   └─ 本文を小文字に変換（bodyLower）

3. パターン1: workers_terminated検出
   └─ "workers_terminated"文字列を検索
   └─ マッチ時: #15964の重複としてクローズ

4. パターン2: better-sqlite3検出
   └─ "better-sqlite3" + ("runcommand" | "autocommand")を検索
   └─ マッチ時: #4290の重複としてクローズ

5. パターン3: ENOTCONN v1.2.23検出
   └─ "enotconn" + "transport" + "standalone_executable" + v1.2.23を検索
   └─ マッチ時: #23342の重複（修正済み）としてクローズ

6. パターン4: WASM IPInt検出
   └─ "wasm_trampoline_wasm_ipint_call_wide32"を検索
   └─ マッチ時: #17841の重複としてクローズ

7. パターン5: CPU要件検出
   └─ ("segmentation fault" | "illegal instruction") + "no_avx"を検索
   └─ マッチ時: CPU要件説明付きでクローズ
   └─ macOS検出時は追加メッセージ

8. 結果出力
   └─ JSON形式で標準出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[環境変数チェック]
    B --> C[Issue内容正規化]
    C --> D{workers_terminated?}
    D -->|はい| E1[#15964重複クローズ]
    D -->|いいえ| F{better-sqlite3?}
    F -->|はい| E2[#4290重複クローズ]
    F -->|いいえ| G{ENOTCONN v1.2.23?}
    G -->|はい| E3[#23342修正済みクローズ]
    G -->|いいえ| H{WASM IPInt?}
    H -->|はい| E4[#17841重複クローズ]
    H -->|いいえ| I{CPU要件問題?}
    I -->|はい| J{macOS?}
    J -->|はい| E5a[CPU要件+Rosetta説明クローズ]
    J -->|いいえ| E5b[CPU要件説明クローズ]
    I -->|いいえ| K[close: false出力]
    E1 --> L[JSON出力]
    E2 --> L
    E3 --> L
    E4 --> L
    E5a --> L
    E5b --> L
    K --> L
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。外部APIへのアクセスも行わず、ローカルでのパターンマッチング処理のみを実行する。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 必須パラメータエラー | GITHUB_ISSUE_NUMBER未設定 | エラーメッセージ出力後throw |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- GITHUB_ISSUE_NUMBER未設定の場合は例外をスロー

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1件（1 Issue） |
| 目標処理時間 | ミリ秒単位（パターンマッチングのみ） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

Issue単位で独立して実行されるため、排他制御は不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果出力 | 処理完了時 | JSON形式のクローズ判定結果 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | - | GitHub Actions UI |
| エラー発生 | - | GitHub Actions UI |

## 備考

### 検出パターン詳細

#### パターン1: workers_terminated
- **検出条件**: Issue本文に"workers_terminated"を含む
- **クローズ理由**: not_planned
- **重複先**: #15964
- **ユーザーへの案内**: Worker終了を避けることを推奨

#### パターン2: better-sqlite3
- **検出条件**: "better-sqlite3" かつ ("runcommand" または "autocommand")
- **クローズ理由**: not_planned
- **重複先**: #4290
- **ユーザーへの案内**: bun:sqliteの使用を推奨

#### パターン3: ENOTCONN (v1.2.23)
- **検出条件**: "enotconn" + "transport" + "standalone_executable" + v1.2.23バージョン
- **クローズ理由**: completed
- **重複先**: #23342
- **ユーザーへの案内**: Bun v1.3へのアップグレードを推奨

#### パターン4: WASM IPInt
- **検出条件**: "wasm_trampoline_wasm_ipint_call_wide32"
- **クローズ理由**: not_planned
- **重複先**: #17841
- **ユーザーへの案内**: 3つのワークアラウンドを提示
  1. BUN_JSC_useWasmIPInt=0
  2. aarch64 CPUの使用
  3. BUN_JSC_jitPolicyScale=0

#### パターン5: CPU要件
- **検出条件**: ("segmentation fault" | "illegal instruction" | "illegalinstruction") + "no_avx"
- **クローズ理由**: not_planned
- **ユーザーへの案内**: nehalem以降のCPUが必要
- **追加情報**: macOS検出時はRosettaに関する説明を追加
