# バッチ設計書 4-buildkite-failures

## 概要

本ドキュメントは、BuildKite CIビルド失敗の詳細分析バッチ「buildkite-failures.ts」の設計仕様を記載する。

### 本バッチの処理概要

BuildKite CIのビルド失敗情報を取得・分析し、エラー詳細をターミナルに表示する。ビルド番号、ブランチ名、GitHub PR URLなど複数の入力形式に対応し、完全なログを/tmp/ディレクトリに保存する。

**業務上の目的・背景**：CI/CDパイプラインの失敗原因を迅速に特定することは、開発効率に直結する。BuildKiteのWeb UIでは失敗情報が分散しており、全体像の把握に時間がかかる。本バッチは失敗したビルドの詳細情報を集約し、エラーの概要と完全なログをローカルに保存することで、デバッグ作業を効率化する。

**バッチの実行タイミング**：開発者が手動で実行（随時）。--waitオプション使用時はビルド完了まで継続的にポーリング。

**主要な処理内容**：
1. コマンドライン引数からビルド識別情報を取得（ビルド番号/ブランチ名/PR URL/BuildKite URL）
2. ブランチ名からビルド番号を特定、またはGitHub APIでPRからブランチを取得
3. BuildKite APIからビルドJSON情報を取得
4. ビルドステータスに応じた処理（passed/canceled/running/failed）
5. 失敗時はアノテーション情報をHTMLからパース
6. テスト失敗情報をANSIカラー付きでターミナル表示
7. 失敗ジョブのログを取得し/tmp/に保存
8. エラーサマリーを表示

**前後の処理との関連**：独立したCLIツールとして動作。開発者のデバッグワークフローを支援する。

**影響範囲**：ローカルファイルシステム（/tmp/ディレクトリ）への書き込みのみ。

## バッチ種別

レポート生成 / 分析ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | BuildKite API、GitHub APIへのアクセスが可能であること |
| git | ブランチ名取得のためgitコマンドが実行可能であること（引数なし実行時） |

### 実行可否判定

- 引数なしの場合は現在のgitブランチを使用
- ブランチに対応するビルドが見つからない場合は終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| build-id | number | No | - | BuildKiteビルド番号 |
| branch | string | No | 現在のブランチ | ブランチ名 |
| pr-url | string | No | - | GitHub PR URL |
| buildkite-url | string | No | - | BuildKite URL |
| #number | string | No | - | GitHub PR番号（#付き） |
| --flaky, -f | flag | No | false | Flakyテストを表示 |
| --warnings, -w | flag | No | false | 警告を表示 |
| --wait | flag | No | false | ビルド完了まで待機 |
| --help, -h | flag | No | - | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| BuildKite Build API | JSON | ビルド情報 |
| BuildKite Build Page | HTML | アノテーション情報 |
| BuildKite Log API | JSON | ジョブログ |
| GitHub API | JSON | PR情報（PR URL指定時） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト（ANSIカラー） | ビルド失敗サマリー |
| /tmp/ディレクトリ | テキストファイル | 完全なビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | /tmp/bun-build-{buildNumber}-{platform}-{step}.log |
| 出力先 | /tmp/ |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数パース
   └─ 入力形式の判定（ビルド番号/ブランチ/PR URL等）

2. ビルド番号の特定
   └─ ブランチ名からBuildKiteページをスクレイピング
   └─ またはGitHub APIでPRブランチを取得

3. ビルド情報取得ループ（--wait時）
   └─ 10秒間隔でポーリング

4. ビルドステータス判定
   └─ passed: 成功メッセージ表示して終了
   └─ canceled: キャンセルメッセージ表示して終了
   └─ running: 進捗表示（--wait時は継続）
   └─ failed: 詳細分析へ

5. 失敗ジョブ抽出
   └─ exit_status > 0 かつ soft_failed=false のジョブ

6. アノテーション取得
   └─ ビルドページHTMLからJSONデータ抽出
   └─ テスト失敗情報のマージ・整理

7. 失敗情報表示
   └─ ANSIカラー付きでターミナル出力

8. ログ取得・保存
   └─ 各失敗ジョブのログを/tmp/に保存
   └─ エラーサマリー表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数パース]
    B --> C{入力形式?}
    C -->|ビルド番号| D[ビルド番号使用]
    C -->|ブランチ| E[BuildKiteページ検索]
    C -->|PR URL| F[GitHub API]
    C -->|なし| G[現在ブランチ取得]
    E --> D
    F --> D
    G --> E
    D --> H[ビルドJSON取得]
    H --> I{ステータス?}
    I -->|passed| J[成功表示・終了]
    I -->|canceled| K[キャンセル表示・終了]
    I -->|running| L{--wait?}
    L -->|はい| M[10秒待機]
    M --> H
    L -->|いいえ| N[進捗表示・終了]
    I -->|failed| O[失敗ジョブ抽出]
    O --> P[アノテーション取得]
    P --> Q[失敗情報表示]
    Q --> R[ログ保存]
    R --> S[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象API | 操作種別 | 概要 |
|-----|---------|---------|------|
| ビルド情報取得 | BuildKite builds/{number}.json | GET | ビルドJSON取得 |
| ビルドページ取得 | BuildKite builds/{number} | GET | HTML取得（アノテーション） |
| ログ取得 | BuildKite jobs/{id}/log | GET | ジョブログ取得 |
| PR情報取得 | GitHub API | GET | PRブランチ名取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルド未発見 | ブランチにビルドがない | メッセージ表示して終了 |
| - | API失敗 | BuildKite/GitHub APIエラー | エラーメッセージ表示 |
| - | アノテーションパースエラー | JSON解析失敗 | エラー表示、アノテーションページURLを案内 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（--waitによるポーリングのみ） |
| リトライ間隔 | 10秒（--wait時） |
| リトライ対象エラー | ビルド実行中状態 |

### 障害時対応

- ログ取得失敗時はエラーメッセージ表示して次のジョブへ継続
- アノテーション取得失敗時はジョブ情報のみ表示

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | 数秒〜数分（ログサイズ依存） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行可能。ファイル名にビルド番号が含まれるため競合しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルド情報 | 処理開始時 | ビルド番号、URL、経過時間 |
| ステータス | ステータス判定後 | passed/canceled/running/failed |
| 失敗件数 | 失敗分析時 | テスト失敗数/ジョブ失敗数 |
| 進捗 | --wait時 | ジョブ進捗状況 |
| ログパス | ログ保存時 | 保存先ファイルパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

### 対応プラットフォーム表示

- darwin/macos: 🍎
- ubuntu/debian/alpine/linux: 🐧
- windows/win: 🪟

### ANSIカラー対応

ターミナルがTTYの場合、またはFORCE_COLOR=1環境変数設定時にカラー出力を行う。
BuildKiteアノテーションのterm-fg*クラスをANSIコードに変換して表示する。

### ファイルパスのリンク化

Gitリポジトリ内のファイルパスはfile://形式のURLに変換して表示する。

### --waitモード

ビルドが実行中の場合、10秒間隔でポーリングを行い、完了または失敗まで待機する。
失敗ジョブが検出された場合は即座にポーリングを停止して詳細表示に移行する。
