# バッチ設計書 5-buildkite-slow-tests

## 概要

本ドキュメントは、遅いテストの分析処理バッチ「buildkite-slow-tests.js」の設計仕様を記載する。

### 本バッチの処理概要

BuildKiteのテスト結果ログファイルを解析し、実行時間の長いテストを抽出して報告する。テストの実行時間を集計し、遅いテストを特定することでテスト最適化の対象を明確にする。

**業務上の目的・背景**：CI/CDパイプラインの実行時間短縮は開発効率に直結する。テストスイートの中で特に時間がかかっているテストを特定することで、テストの最適化やパラレル化の対象を明確にできる。本バッチはBuildKiteのログから実行時間情報を抽出し、テスト最適化の意思決定を支援する。

**バッチの実行タイミング**：開発者が手動で実行（随時）。BuildKiteのログファイルを入力として使用。

**主要な処理内容**：
1. コマンドライン引数からログファイルパスを取得
2. ログファイルを読み込み、各行をパース
3. テストグループ開始パターン（_bk;t=タイムスタンプ付き）を検出
4. 前のテストの終了時刻として現在のテスト開始時刻を使用し、実行時間を計算
5. アテンプト情報（リトライ回数）を抽出
6. テストごとの合計実行時間を集計
7. 実行時間でソートし、上位10件と1秒超のテスト一覧を出力

**前後の処理との関連**：buildkite-failures.tsで保存されたログファイルを入力として使用可能。

**影響範囲**：標準出力のみ。ファイル変更なし。

## バッチ種別

分析ツール / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ログファイル | BuildKiteのログファイルが存在すること |
| ログ形式 | _bk;t=タイムスタンプ形式のログであること |

### 実行可否判定

- 引数が1つでない場合はUsageを表示して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| log_file | string | Yes | - | BuildKiteログファイルパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ログファイル | テキスト | BuildKiteテスト実行ログ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | Markdownテキスト | 遅いテスト分析レポート |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）

**出力フォーマット例**：
```markdown
## Slowest Tests Analysis - 100 tests (500.0s total, 5.00s avg)

**Top 10 slowest tests:**
- **30.0s** js/bun/http/serve [2.5s attempt #1, 27.5s attempt #2]
- **25.0s** js/web/fetch/fetch
...

```
All tests > 1s (50 tests):
  1.  30.00s  test/js/bun/http/serve.test.ts [2.5s attempt #1, 27.5s attempt #2]
  2.  25.00s  test/js/web/fetch/fetch.test.ts
...
```
```

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ ログファイルパスが指定されているか確認

2. ログファイル読み込み
   └─ readFileSyncでファイル内容を取得

3. 行ごとのパース
   └─ テストグループ開始パターンを検出

4. 実行時間計算
   └─ 前テストの終了時刻 = 現テストの開始時刻として計算

5. アテンプト情報抽出
   └─ [attempt #N]パターンを検出

6. テスト情報集計
   └─ テストごとの合計時間とアテンプト情報をMapに蓄積

7. ソート
   └─ 合計実行時間の降順でソート

8. レポート出力
   └─ Top 10と1秒超テスト一覧をMarkdown形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{引数チェック}
    B -->|NG| C[Usage表示・終了]
    B -->|OK| D[ログファイル読み込み]
    D --> E[行ループ開始]
    E --> F{パターンマッチ?}
    F -->|いいえ| E
    F -->|はい| G{前テストあり?}
    G -->|はい| H[実行時間計算]
    H --> I[アテンプト情報抽出]
    I --> J[Mapに蓄積]
    J --> E
    G -->|いいえ| K[開始時刻記録]
    K --> E
    E -->|終了| L[実行時間でソート]
    L --> M[Top 10出力]
    M --> N[1秒超テスト出力]
    N --> O[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | ログファイルパス未指定 | Usage表示して終了 |
| - | ファイル読み込みエラー | ファイルが存在しない | Node.jsエラー発生 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- ファイル読み込み失敗時はNode.jsのエラーメッセージが表示される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル（数MB程度） |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | ファイルサイズに依存 |

## 排他制御

読み取り専用のため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| サマリー | 処理完了時 | テスト数、合計時間、平均時間 |
| Top 10 | 処理完了時 | 遅いテスト上位10件 |
| 詳細リスト | 処理完了時 | 1秒超の全テスト |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

### ログ解析パターン

テストグループ開始パターン：
```
_bk;t=(\d+).*?--- .*?\[90m\[(\d+)\/(\d+)\].*?\[0m (.+)
```

- グループ1: タイムスタンプ（ミリ秒）
- グループ2: 現在のテスト番号
- グループ3: 総テスト数
- グループ4: テストパス

アテンプトパターン：
```
\s+\x1b\[90m\[attempt #(\d+)\]\x1b\[0m$
```

### 実行時間計算ロジック

BuildKiteのログにはテストの終了時刻が明示的に記録されないため、次のテストの開始時刻を前のテストの終了時刻として使用する。

### 表示形式

- 実行時間は秒単位で表示（小数点以下1桁 or 2桁）
- アテンプト情報がある場合は各アテンプトの時間を表示
- テストパスはtest/と.test.ts/.test.jsを除去して簡略化
