# バッチ設計書 7-sync-webkit-source

## 概要

本ドキュメントは、WebKitソースの同期処理バッチ「sync-webkit-source.ts」の設計仕様を記載する。

### 本バッチの処理概要

vendor/WebKitディレクトリを、cmake/tools/SetupWebKit.cmakeで指定されたコミットハッシュに同期する。BunプロジェクトがWebKitの特定バージョンに依存しているため、そのバージョンを正確に取得する。

**業務上の目的・背景**：BunはWebKitのJavaScriptCoreエンジンを使用しており、特定のコミットに固定されたWebKitソースが必要である。SetupWebKit.cmakeファイルでWEBKIT_VERSIONとして期待するコミットハッシュが定義されており、開発者はこのバージョンに同期する必要がある。本バッチはこの同期作業を自動化し、開発環境のセットアップを簡素化する。

**バッチの実行タイミング**：開発者が手動で実行（随時）。WebKitバージョン更新時や新規開発環境セットアップ時に使用。

**主要な処理内容**：
1. vendor/WebKitディレクトリの存在確認
2. cmake/tools/SetupWebKit.cmakeから期待するコミットハッシュを抽出
3. 現在のWebKitリポジトリのHEADコミットを取得
4. コミットが一致している場合は処理終了
5. 一致していない場合はmainブランチをpullし、指定コミットにcheckout

**前後の処理との関連**：build-jsc.ts（JavaScriptCoreビルド）の事前準備として実行される。

**影響範囲**：vendor/WebKitディレクトリのgit状態を変更する。

## バッチ種別

ソース同期 / 依存関係管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| WebKitリポジトリ | vendor/WebKitディレクトリにWebKitのクローンまたはシンボリックリンクが存在すること |
| git | gitコマンドが実行可能であること |
| ネットワーク接続 | WebKitリポジトリからのpullが可能であること |

### 実行可否判定

- vendor/WebKitディレクトリが存在しない場合はエラーメッセージを表示して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | - |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| cmake/tools/SetupWebKit.cmake | テキスト | WEBKIT_VERSION定義 |
| vendor/WebKit | gitリポジトリ | WebKitソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| vendor/WebKit | gitリポジトリ | 指定コミットにcheckout |
| 標準出力 | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

ファイル出力なし（git操作のみ）

## 処理フロー

### 処理シーケンス

```
1. パス設定
   └─ bunRepoルート、vendor/WebKitパスを設定

2. WebKitディレクトリ確認
   └─ 存在しない場合はエラーメッセージを表示して終了

3. カレントディレクトリ変更
   └─ vendor/WebKitに移動

4. 現在のコミット取得
   └─ git rev-parse HEADで現在のコミットハッシュを取得

5. 期待コミット抽出
   └─ SetupWebKit.cmakeからWEBKIT_VERSIONを正規表現で抽出

6. コミット比較
   └─ 一致していれば処理終了

7. コミット変更
   └─ git checkout main → git pull → git checkout {expectedCommit}
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{WebKitディレクトリ存在?}
    B -->|いいえ| C[エラーメッセージ・終了]
    B -->|はい| D[現在コミット取得]
    D --> E[期待コミット抽出]
    E --> F{コミット一致?}
    F -->|はい| G[already at commit表示・終了]
    F -->|いいえ| H[changing from...to表示]
    H --> I[git checkout main]
    I --> J[git pull]
    J --> K[git checkout expectedCommit]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| コミット取得 | git | git rev-parse | 現在のHEADコミット取得 |
| ブランチ切替 | git | git checkout main | mainブランチに切替 |
| 更新取得 | git | git pull | リモートから最新を取得 |
| コミット切替 | git | git checkout | 指定コミットにcheckout |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ不在 | vendor/WebKitが存在しない | クローン手順を案内して終了 |
| - | git操作失敗 | checkout/pull失敗 | gitエラーメッセージ表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- WebKitディレクトリが存在しない場合はクローン手順を案内
- git操作失敗時はBun.$のエラーが伝播

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回 |
| 目標処理時間 | ネットワーク速度に依存（git pull） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行は想定しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 状態ログ | コミット一致時 | "already at commit {hash}" |
| 変更ログ | コミット変更時 | "changing from {old} to {new}" |
| エラーログ | ディレクトリ不在時 | クローン手順の案内 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

### WEBKIT_VERSION抽出パターン

```
set\(WEBKIT_VERSION ([0-9a-f]{40})\)
```

SetupWebKit.cmakeファイルから40文字の16進数コミットハッシュを抽出する。

### WebKitリポジトリ

- リポジトリURL: https://github.com/oven-sh/WebKit.git
- oven-sh組織がフォークしてカスタマイズしたWebKit

### detached HEAD状態

指定コミットへのcheckout後、リポジトリはdetached HEAD状態になる。
これは意図された動作であり、特定のコミットに固定してビルドを行うため。

### 事前準備

WebKitリポジトリが存在しない場合は、以下のいずれかが必要：
1. `git clone https://github.com/oven-sh/WebKit.git vendor/WebKit`
2. 既存のWebKitクローンへのシンボリックリンク作成
