# バッチ設計書 8-fetch-node-test

## 概要

本ドキュメントは、Node.jsテストファイルの取得処理バッチ「fetch-node-test.ts」の設計仕様を記載する。

### 本バッチの処理概要

Node.js公式リポジトリから指定されたテストファイルをダウンロードし、test/js/node/配下に保存する。BunのNode.js互換性テストに使用するテストファイルを取得する。

**業務上の目的・背景**：BunはNode.jsとの互換性を重視しており、Node.js公式のテストスイートを利用して互換性を検証している。しかし、Node.jsリポジトリ全体をクローンするのは効率的ではない。本バッチは必要なテストファイルのみを取得することで、効率的なテスト環境の構築を可能にする。

**バッチの実行タイミング**：開発者が手動で実行（随時）。新しいNode.jsテストを追加したい場合に使用。

**主要な処理内容**：
1. コマンドライン引数からテスト名を取得
2. テスト名のバリエーション（test-プレフィックス有無）を生成
3. test/parallel、test/sequentialディレクトリを検索
4. 複数の拡張子（.js、.mjs、.ts）を試行
5. 見つかったファイルをtest/js/node/配下に保存
6. ダウンロード結果を表示

**前後の処理との関連**：ダウンロードしたテストファイルはBunのテストスイートで使用される。

**影響範囲**：test/js/node/ディレクトリにファイルを作成する。

## バッチ種別

データ取得 / テスト支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ネットワーク接続 | GitHub rawコンテンツへのアクセスが可能であること |

### 実行可否判定

- テスト名が指定されていない場合はUsageを表示して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| test-name | string | Yes | - | テストファイル名（拡張子任意） |
| GITHUB_TOKEN | env | No | - | GitHub APIレート制限回避用トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Node.js GitHub raw | テキスト | Node.js公式リポジトリのmainブランチ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| test/js/node/{dir}/{file} | テキスト | ダウンロードしたテストファイル |
| 標準出力 | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 元ファイル名を維持 |
| 出力先 | test/js/node/test/parallel/ または test/js/node/test/sequential/ |
| 文字コード | 元ファイルを維持 |

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ テスト名が指定されているか確認

2. パス前処理
   └─ スクリプトパスやtest/ディレクトリプレフィックスを除去

3. テスト名バリエーション生成
   └─ 元の名前、test-プレフィックス付き、test-プレフィックスなし

4. ディレクトリ・拡張子ループ
   └─ test/parallel、test/sequential × js、mjs、ts × バリエーション

5. fetchリクエスト
   └─ raw.githubusercontent.comからファイル取得を試行

6. ファイル保存
   └─ 成功時はディレクトリ作成後にファイル書き込み

7. 結果表示
   └─ 成功メッセージまたはエラーメッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{テスト名指定?}
    B -->|いいえ| C[Usage表示・終了]
    B -->|はい| D[パス前処理]
    D --> E[バリエーション生成]
    E --> F[ディレクトリループ]
    F --> G[バリエーションループ]
    G --> H[拡張子ループ]
    H --> I[URL構築]
    I --> J[fetch実行]
    J --> K{成功?}
    K -->|はい| L[ディレクトリ作成]
    L --> M[ファイル書き込み]
    M --> N[成功メッセージ・終了]
    K -->|いいえ| O{次あり?}
    O -->|はい| H
    O -->|いいえ| P{次あり?}
    P -->|はい| G
    P -->|いいえ| Q{次あり?}
    Q -->|はい| F
    Q -->|いいえ| R[エラー・終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| ファイル取得 | GitHub raw | HTTP GET | テストファイルダウンロード |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | テスト名未指定 | Usage表示して終了 |
| - | 取得失敗 | 全パターンで404 | エラーメッセージ表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（パターン試行で代替） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- 全パターンでファイルが見つからない場合はエラーメッセージを表示

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 数秒（ネットワーク速度依存） |
| メモリ使用量上限 | ファイルサイズに依存 |

## 排他制御

同時実行可能。異なるテストファイルを取得するため競合しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 試行ログ | URL試行時 | "Trying: {url}" |
| 成功ログ | 保存成功時 | "Successfully fetched and saved: {path} ({size})" |
| エラーログ | 全失敗時 | "Could not find test: {name}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

### Node.jsリポジトリURL

```
https://raw.githubusercontent.com/nodejs/node/main
```

### 検索対象ディレクトリ

1. test/parallel - 並列実行可能なテスト
2. test/sequential - 順次実行が必要なテスト

### 対応拡張子

1. .js - JavaScript
2. .mjs - ES Modules
3. .ts - TypeScript（一部テストで使用）

### テスト名バリエーション

入力: `http-server`
試行:
1. `http-server`
2. `test-http-server`
3. `http-server`（test-プレフィックスを除去した場合と同じ）

入力: `test-http-server`
試行:
1. `test-http-server`
2. `test-test-http-server`（通常失敗）
3. `http-server`

### GITHUB_TOKEN使用

環境変数GITHUB_TOKENが設定されている場合、Authorizationヘッダーに含めてAPIレート制限を回避する。

### ファイルサイズ表示

ダウンロードしたファイルサイズはIntl.NumberFormatを使用してコンパクト形式で表示（例: "1.5K"）。
