# バッチ設計書 9-github-metrics

## 概要

本ドキュメントは、GitHubメトリクス収集処理バッチ「github-metrics.ts」の設計仕様を記載する。

### 本バッチの処理概要

指定されたリリースタグ以降にクローズされたIssue数とポジティブリアクション数を集計する。プロジェクトの進捗状況やコミュニティの反応を定量的に把握するためのメトリクスを収集する。

**業務上の目的・背景**：オープンソースプロジェクトの健全性を評価するためには、Issue解決数やコミュニティからのフィードバックを定量化することが重要である。本バッチはリリース間のIssue解決状況とユーザーからのポジティブなリアクションを集計することで、プロジェクトの進捗レポートやリリースノート作成を支援する。

**バッチの実行タイミング**：開発者が手動で実行（随時）。リリース前後のメトリクス確認時に使用。

**主要な処理内容**：
1. コマンドライン引数からリリースタグを取得
2. gh CLIを使用してリリース日を取得
3. リリース日以降にクローズされたIssue（completed状態）を検索
4. 各Issueとそのコメントへのポジティブリアクションをカウント
5. メトリクスをサマリー表示

**前後の処理との関連**：独立したメトリクス収集ツールとして動作。リリース作業やレポート作成に使用される。

**影響範囲**：読み取り専用。GitHub APIへのクエリのみ。

## バッチ種別

メトリクス収集 / レポート生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| gh CLI | GitHub CLI（gh）がインストールされ認証済みであること |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

- リリースタグが指定されていない場合はUsageを表示して終了

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| release-tag | string | Yes | - | リリースタグ（例: bun-v1.2.19） |
| --verbose, -v | flag | No | false | 詳細出力モード |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Release API | JSON | リリース情報（gh release view） |
| GitHub Issues API | JSON | Issue一覧（gh issue list） |
| GitHub Reactions API | JSON | リアクション情報（gh api） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | メトリクスサマリー |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）

**出力例**：
```
Collecting GitHub metrics since bun-v1.2.19...
Counting completed issues...
Counting positive reactions...

Results:
Issues closed as completed since bun-v1.2.19: 150
Total positive reactions: 500
Average reactions per completed issue: 3.3
```

## 処理フロー

### 処理シーケンス

```
1. 引数チェック
   └─ リリースタグが指定されているか確認

2. リリース情報取得
   └─ gh release viewでpublishedAtを取得

3. Issue検索
   └─ gh issue listでclosed:>={releaseDate} reason:completedを検索

4. リアクション集計
   └─ 各Issueのリアクションを取得
   └─ 各コメントのリアクションを取得
   └─ +1、heart、hooray、rocketをカウント

5. サマリー出力
   └─ Issue数、リアクション数、平均を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{リリースタグ指定?}
    B -->|いいえ| C[Usage表示・終了]
    B -->|はい| D[リリース情報取得]
    D --> E[リリース日抽出]
    E --> F[completed Issue検索]
    F --> G[Issueループ]
    G --> H[Issueリアクション取得]
    H --> I[コメントリアクション取得]
    I --> J[リアクション集計]
    J --> K{次Issueあり?}
    K -->|はい| G
    K -->|いいえ| L[サマリー出力]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

| 処理 | 対象API | 操作種別 | 概要 |
|-----|---------|---------|------|
| リリース取得 | gh release view | GET | リリース日取得 |
| Issue検索 | gh issue list | GET | completed Issue一覧 |
| Issueリアクション | gh api issues/{n}/reactions | GET | Issueリアクション |
| コメント取得 | gh api issues/{n}/comments | GET | コメント一覧 |
| コメントリアクション | gh api issues/comments/{id}/reactions | GET | コメントリアクション |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | リリースタグ未指定 | Usage表示して終了 |
| - | リリース取得失敗 | 無効なタグ | エラーメッセージ表示 |
| - | API失敗 | GitHub APIエラー | 個別スキップして継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

- 個別Issue/コメントのリアクション取得失敗時は0としてカウント継続
- 致命的エラー時はエラーメッセージを表示して終了

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | なし |
| コミットタイミング | - |
| ロールバック条件 | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大1000 Issue |
| 目標処理時間 | Issue数に依存（1 Issue/秒程度） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

読み取り専用のため排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Collecting GitHub metrics since {tag}..." |
| 進捗ログ | 各フェーズ | "Counting completed issues..." / "Counting positive reactions..." |
| 詳細ログ | --verbose時 | Issue番号ごとのリアクション数 |
| 結果ログ | 処理完了時 | Issue数、リアクション数、平均 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| - | - | - |

## 備考

### 対象リアクション

以下のリアクションをポジティブとしてカウント：
- +1（thumbs up）
- heart
- hooray
- rocket

### レート制限対策

各Issue処理後に1ミリ秒のスリープを挿入してAPIレート制限を回避。

### Issue検索条件

```
gh issue list --state closed --search "closed:>={releaseDate} reason:completed" --limit 1000
```

- stateReason: COMPLETEDでフィルタリング
- 最大1000件を取得

### verboseモード

--verbose または -v オプション指定時：
- リリース日を表示
- 各IssueのIssueリアクション数とコメントリアクション数を表示

### 平均値計算

Issue数が0の場合は平均値を表示しない。
