---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-auto-close-duplicates.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/auto-close-duplicates.ts` 行1-367（ソースコード全体）
- E-02: `scripts/auto-close-duplicates.ts` 行219-231（環境変数チェック）
- E-03: `scripts/auto-close-duplicates.ts` 行233-235（3日前の日付計算）
- E-04: `scripts/auto-close-duplicates.ts` 行242-260（Issue取得ループ）
- E-05: `scripts/auto-close-duplicates.ts` 行276-288（dedupe-botコメント検出）
- E-06: `scripts/auto-close-duplicates.ts` 行290-299（3日経過確認）
- E-07: `scripts/auto-close-duplicates.ts` 行307-317（人間コメント確認）
- E-08: `scripts/auto-close-duplicates.ts` 行319-329（thumbsdownリアクション確認）
- E-09: `scripts/auto-close-duplicates.ts` 行331-338（再オープン履歴確認）
- E-10: `scripts/auto-close-duplicates.ts` 行340-344（重複Issue番号抽出）
- E-11: `scripts/auto-close-duplicates.ts` 行193-214（Issueクローズ処理）
- E-12: `scripts/auto-close-duplicates.ts` 行44-95（githubRequest関数・リトライ処理）
- E-13: `scripts/auto-close-duplicates.ts` 行62-71（レート制限警告）
- E-14: `バッチ一覧.csv` 行2（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GITHUB_TOKEN環境変数が必要 | E-02 | ○ |
| C-02 | 3日以上経過したオープンIssueをスキャン | E-03, E-04 | ○ |
| C-03 | dedupe-botによる重複検出コメントを確認 | E-05 | ○ |
| C-04 | 重複コメントが3日以上経過している必要がある | E-06 | ○ |
| C-05 | 人間によるコメントがないことを確認 | E-07 | ○ |
| C-06 | thumbsdownリアクションがないことを確認 | E-08 | ○ |
| C-07 | 再オープン履歴がないことを確認 | E-09 | ○ |
| C-08 | 重複先Issue番号を抽出 | E-10 | ○ |
| C-09 | Issueをduplicate理由でクローズ | E-11 | ○ |
| C-10 | クローズ時にコメントを追加 | E-11 | ○ |
| C-11 | リトライ回数は3回 | E-12 | ○ |
| C-12 | 指数バックオフでリトライ | E-12 | ○ |
| C-13 | 429/403エラーでリトライ | E-12 | ○ |
| C-14 | レート制限残100未満で警告 | E-13 | ○ |
| C-15 | レート制限残10未満で待機 | E-13 | ○ |
| C-16 | ページネーション最大20ページ | E-04 | ○ |
| C-17 | GITHUB_REPOSITORYデフォルト値 | E-02 | ○ |
| C-18 | Pull Requestを除外 | E-04 | ○ |
| C-19 | 1ページあたり100件取得 | E-04 | ○ |
| C-20 | dedupe-bot:markerコメントを検索 | E-05 | ○ |
| C-21 | Bot以外のコメントを人間コメントとして判定 | E-07 | ○ |
| C-22 | reopenedイベントで再オープン確認 | E-09 | ○ |
| C-23 | Issue URL形式と#形式で重複番号抽出 | E-10 | ○ |
| C-24 | state_reason: duplicateでクローズ | E-11 | ○ |
| C-25 | Claude Codeによる生成コメント追加 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] GITHUB_TOKEN環境変数の要件が正しく記載されているか
- [x] 3日経過の判定ロジックが正しく記載されているか
- [x] dedupe-botコメントの検出条件が正しいか
- [x] リトライ仕様が実装と一致しているか
- [x] レート制限対応が正しく記載されているか
