---
generated_at: 2026-01-27 10:39:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-build-jsc.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/build-jsc.ts` 行1-291（ソースコード全体）
- E-02: `scripts/build-jsc.ts` 行10-19（引数パース・バリデーション）
- E-03: `scripts/build-jsc.ts` 行21-29（プラットフォーム検出）
- E-04: `scripts/build-jsc.ts` 行31-44（パス定義）
- E-05: `scripts/build-jsc.ts` 行47-58（ICUパス定義）
- E-06: `scripts/build-jsc.ts` 行64-86（コンパイラ検出）
- E-07: `scripts/build-jsc.ts` 行89-98（ビルドディレクトリ設定）
- E-08: `scripts/build-jsc.ts` 行101-164（共通CMakeフラグ）
- E-09: `scripts/build-jsc.ts` 行126-133（macOS固有設定）
- E-10: `scripts/build-jsc.ts` 行134-140（Linux固有設定）
- E-11: `scripts/build-jsc.ts` 行141-161（Windows固有設定）
- E-12: `scripts/build-jsc.ts` 行167-214（ビルド設定別フラグ）
- E-13: `scripts/build-jsc.ts` 行228-244（runCommand関数）
- E-14: `scripts/build-jsc.ts` 行247-285（buildJSC関数）
- E-15: `scripts/build-jsc.ts` 行73-74（ccache検出）
- E-16: `バッチ一覧.csv` 行11（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | debug/release/ltoのビルド設定をサポート | E-02 | ○ |
| C-02 | 不正設定時にエラー表示 | E-02 | ○ |
| C-03 | macOS/Linux/Windowsを検出 | E-03 | ○ |
| C-04 | x64/ARM64アーキテクチャを検出 | E-03 | ○ |
| C-05 | debugはWebKitBuild/Debugに出力 | E-07 | ○ |
| C-06 | releaseはWebKitBuild/Releaseに出力 | E-07 | ○ |
| C-07 | ltoはWebKitBuild/ReleaseLTOに出力 | E-07 | ○ |
| C-08 | ccacheを検出して使用 | E-15 | ○ |
| C-09 | PORT=JSCOnly | E-08 | ○ |
| C-10 | ENABLE_STATIC_JSC=ON | E-08 | ○ |
| C-11 | ENABLE_FTL_JIT=ON | E-08 | ○ |
| C-12 | Generator: Ninja | E-08 | ○ |
| C-13 | macOSでENABLE_SINGLE_THREADED_VM_ENTRY_SCOPE=ON | E-09 | ○ |
| C-14 | macOSでBUN_FAST_TLS=ON | E-09 | ○ |
| C-15 | macOSでHomebrewのICUを使用 | E-14 | ○ |
| C-16 | LinuxでJSEXPORT_PRIVATE設定 | E-10 | ○ |
| C-17 | WindowsでUSE_SYSTEM_MALLOC=ON | E-11 | ○ |
| C-18 | Windowsでlld-linkを使用 | E-11 | ○ |
| C-19 | Windowsでvcpkg ICUを使用 | E-05, E-11 | ○ |
| C-20 | WindowsでU_STATIC_IMPLEMENTATION定義 | E-11 | ○ |
| C-21 | debugでENABLE_BUN_SKIP_FAILING_ASSERTIONS=ON | E-12 | ○ |
| C-22 | debugでCMAKE_EXPORT_COMPILE_COMMANDS=ON | E-12 | ○ |
| C-23 | debugでENABLE_SANITIZERS=address（macOS/Linux） | E-12 | ○ |
| C-24 | ltoで-flto=fullフラグ | E-12 | ○ |
| C-25 | CMakeでconfigureを実行 | E-14 | ○ |
| C-26 | CMake --buildでjscターゲットをビルド | E-14 | ○ |
| C-27 | ビルドディレクトリを作成 | E-14 | ○ |
| C-28 | 完了時にメッセージ表示 | E-14 | ○ |
| C-29 | spawnSyncでコマンド実行 | E-13 | ○ |
| C-30 | 失敗時にexit code伝播 | E-13 | ○ |
| C-31 | debugはCMAKE_BUILD_TYPE=Debug | E-12 | ○ |
| C-32 | releaseはCMAKE_BUILD_TYPE=RelWithDebInfo | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] ビルド設定別のディレクトリが正確か
- [x] プラットフォーム検出ロジックが正しいか
- [x] CMakeフラグが正確か
- [x] macOS/Linux/Windows固有設定が正しいか
- [x] debug/release/lto設定の違いが正確か
