---
generated_at: 2026-01-27 18:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：11-read-issue.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **label-issue.tsとの連携関係**：コード内に明示的な連携はなく推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/read-issue.ts` 1-57行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 12行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GITHUB_ISSUE_BODY環境変数からIssue本文を取得する | E-01 (1-5行目) | ○ |
| C-02 | 環境変数未設定時はErrorをスローする | E-01 (3-5行目) | ○ |
| C-03 | [TestCommand]パターンでjestラベルを判定 | E-01 (9-10行目) | ○ |
| C-04 | [BuildCommand]パターンでbundlerラベルを判定 | E-01 (11-12行目) | ○ |
| C-05 | [InstallCommand]等でnpmラベルを判定 | E-01 (13-15行目) | ○ |
| C-06 | Features行からjsc/shellを抽出 | E-01 (17-31行目) | ○ |
| C-07 | Bun vX.X.X on 形式からプラットフォームを判定 | E-01 (34-52行目) | ○ |
| C-08 | macOS/darwin検出でmacosラベルを付与 | E-01 (44-45行目) | ○ |
| C-09 | linux検出でlinuxラベルを付与 | E-01 (46-47行目) | ○ |
| C-10 | windows/nt検出でwindowsラベルを付与 | E-01 (48-50行目) | ○ |
| C-11 | ラベルをカンマ区切りで標準出力 | E-01 (54-56行目) | ○ |
| C-12 | label-issue.tsと連携する場合がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- label-issue.tsとの連携関係についてはコード内に明示的な参照がない
  - 候補：GitHub Actionsワークフロー定義 / 運用ドキュメント / プロジェクト内のCI設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確でシンプル
- 1: 中リスク - バッチ一覧.csvの説明文「Issue読み込み」と実際の動作「ラベル判定」に乖離あり

## 6) レビュアーチェックリスト（最小）
- [ ] バッチ一覧.csvの説明文との整合性を確認（説明文の修正が必要か検討）
- [ ] GitHub Actionsワークフローでの実際の使用方法を確認
- [ ] label-issue.tsとの連携有無を確認
