---
generated_at: 2026-01-27 18:32:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-associate-issue-with-sentry.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/associate-issue-with-sentry.ts` 1-52行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 13行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GITHUB_ISSUE_BODYとSENTRY_AUTH_TOKENを環境変数から取得 | E-01 (1-2行目) | ○ |
| C-02 | 環境変数未設定時はErrorをスロー | E-01 (4-6行目) | ○ |
| C-03 | Issue本文から`<!-- sentry_id: xxx -->`を検出 | E-01 (8-13行目) | ○ |
| C-04 | sentry_id未検出時はエラー終了 | E-01 (10-16行目) | ○ |
| C-05 | Sentry Event APIを呼び出してgroupIdを取得 | E-01 (18-29行目) | ○ |
| C-06 | 組織ID 4507155222364160を使用 | E-01 (18行目) | ○ |
| C-07 | Bearer tokenで認証 | E-01 (19-21行目) | ○ |
| C-08 | API失敗時はエラーをスロー | E-01 (23-24行目, 37-38行目) | ○ |
| C-09 | groupIdからSentry Issue APIを呼び出し | E-01 (32-39行目) | ○ |
| C-10 | shortIdとpermalinkを取得 | E-01 (40-43行目) | ○ |
| C-11 | Sentry IDを標準出力に表示 | E-01 (45行目) | ○ |
| C-12 | Sentry permalinkを標準出力に表示 | E-01 (46行目) | ○ |
| C-13 | sentry-id.txtにshortIdを出力 | E-01 (48行目) | ○ |
| C-14 | sentry-link.txtにpermalinkを出力 | E-01 (49行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確でAPIコールも標準的な実装
- 注意点: Sentry組織IDがハードコードされているため、組織変更時は修正が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Sentry組織ID（4507155222364160）が正しいか確認
- [ ] 出力ファイルの後続処理での使用方法を確認
- [ ] エラー時の通知・アラート設定を確認
