---
generated_at: 2026-01-27 18:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-debug-coredump.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/debug-coredump.ts` 1-67行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 14行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parseArgsでpid、build-url、cores-url、debuggerを取得 | E-01 (11-20行目) | ○ |
| C-02 | debuggerのデフォルト値はlldb | E-01 (18行目) | ○ |
| C-03 | PID未指定時はErrorをスロー | E-01 (22行目) | ○ |
| C-04 | build-url未指定時はErrorをスロー | E-01 (24行目) | ○ |
| C-05 | cores-url未指定時はErrorをスロー | E-01 (25行目) | ○ |
| C-06 | AGE_CORES_IDENTITYがAGE-SECRET-KEY-で始まるか検証 | E-01 (26-27行目) | ○ |
| C-07 | URLハッシュで一意の一時ディレクトリを作成 | E-01 (29-31行目) | ○ |
| C-08 | キャッシュ存在時はダウンロードをスキップ | E-01 (33, 50-52行目) | ○ |
| C-09 | bun-profile.zipをfetchでダウンロード | E-01 (34-36行目) | ○ |
| C-10 | unzip -j -oで展開 | E-01 (40行目) | ○ |
| C-11 | コアダンプをfetchでダウンロード | E-01 (42-43行目) | ○ |
| C-12 | ageで復号化しtarで展開 | E-01 (44行目) | ○ |
| C-13 | Bun.Globでコアファイルを検索し移動 | E-01 (47-49行目) | ○ |
| C-14 | 指定PIDに対応するコアファイルを特定 | E-01 (54行目) | ○ |
| C-15 | デバッガを起動（lldb --core {core} {binary}） | E-01 (56-66行目) | ○ |
| C-16 | デバッガの終了コードをプロセス終了コードとして使用 | E-01 (67行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確で処理フローも直線的
- 注意点: セキュリティ上重要なAGE_CORES_IDENTITY環境変数の取り扱いに注意

## 6) レビュアーチェックリスト（最小）
- [ ] 一時ディレクトリのクリーンアップ方針を確認（現在は自動削除なし）
- [ ] AGE_CORES_IDENTITY環境変数のセキュアな管理方法を確認
- [ ] unzip、age、tar、lldbの依存関係を確認
