---
generated_at: 2026-01-27 18:38:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-cleartrace.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/cleartrace.ts` 1-46行目
- E-02: `scripts/cleartrace-impl.js` 1-55行目
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 15行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | readlineで標準入力を行単位で受信 | E-01 (3-9行目) | ○ |
| C-02 | 行をchunk配列にバッファリング | E-01 (11-14行目) | ○ |
| C-03 | 100msのデバウンス処理 | E-01 (35-41行目) | ○ |
| C-04 | cleartrace-impl.jsを子プロセスとして起動 | E-01 (24-27行目) | ○ |
| C-05 | バッファ内容をstdinに送信 | E-01 (28-30行目) | ○ |
| C-06 | ストリーム終了時にタイムアウトを停止 | E-01 (44-46行目) | ○ |
| C-07 | ignoreリストに無視対象パターンを定義 | E-02 (9-31行目) | ○ |
| C-08 | `: error: `を含む行を赤色で表示 | E-02 (39-40行目) | ○ |
| C-09 | `: note: `を含む行をシアンで表示 | E-02 (41-42行目) | ○ |
| C-10 | `@compileError`を含む行の次の行をスキップ | E-02 (43-44行目) | ○ |
| C-11 | 無視対象行をグレー（dim）で表示 | E-02 (45-46行目) | ○ |
| C-12 | print__anon_等のパターンを無視対象に含む | E-02 (10-15行目) | ○ |
| C-13 | logger.zig、output.zigを無視対象に含む | E-02 (27-28行目) | ○ |
| C-14 | vendor/zig/lib/stdを無視対象に含む | E-02 (29行目) | ○ |
| C-15 | fishシェルでの使用例がコメントに記載 | E-01 (1行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確でフィルタリングルールも明示的

## 6) レビュアーチェックリスト（最小）
- [ ] 無視対象パターンリストが最新のコードベースに適合しているか確認
- [ ] デバウンス時間（100ms）が適切か確認
- [ ] cleartrace-impl.jsの存在を確認
