---
generated_at: 2026-01-27 18:42:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-css-properties（generate_properties.ts）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/css/properties/generate_properties.ts` 1-2052行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 16行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 出力ファイルはsrc/css/properties/properties_generated.zig | E-01 (43行目) | ○ |
| C-02 | generateCode関数でプロパティ定義を処理 | E-01 (45-58行目) | ○ |
| C-03 | completed.mdを生成（EMIT_COMPLETED_MD_FILEがtrue時） | E-01 (46-52行目) | ○ |
| C-04 | prelude、Property、PropertyId、PropertyIdTagを順次出力 | E-01 (53-56行目) | ○ |
| C-05 | vendor/zig/zig.exeでzig fmtを実行 | E-01 (57行目) | ○ |
| C-06 | PropertyDef型にty、shorthand、valid_prefixes等を定義 | E-01 (19-41行目) | ○ |
| C-07 | generateProperty関数でProperty union型を生成 | E-01 (97-108行目) | ○ |
| C-08 | generatePropertyId関数でPropertyId union型を生成 | E-01 (353-370行目) | ○ |
| C-09 | generatePropertyIdTag関数でPropertyIdTag enum型を生成 | E-01 (60-95行目) | ○ |
| C-10 | parse、toCss、deepClone、eqlメソッドを生成 | E-01 (110-305行目) | ○ |
| C-11 | VendorPrefixesはnone、webkit、moz、ms、oをサポート | E-01 (1行目) | ○ |
| C-12 | LogicalGroupはborder系、margin系、padding系等をサポート | E-01 (3-16行目) | ○ |
| C-13 | 約200種類のCSSプロパティを定義 | E-01 (525-1784行目) | ○ |
| C-14 | prelude関数でimport文と型定義を生成 | E-01 (1786-2047行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード生成ロジックは明確でテンプレートベース
- 注意点: 生成されるZigコードが大規模なため、生成結果の検証が重要

## 6) レビュアーチェックリスト（最小）
- [ ] 生成されたproperties_generated.zigがコンパイル可能か確認
- [ ] コメントアウトされたプロパティ（animation系等）の対応状況を確認
- [ ] vendor/zig/zig.exeのパスが環境に適切か確認
