---
generated_at: 2026-01-27 18:46:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-uv-posix-stubs（generate_uv_posix_stubs.ts）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/bindings/libuv/generate_uv_posix_stubs.ts` 1-399行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 17行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | symbolsとtest_skippedを定数ファイルからインポート | E-01 (2行目) | ○ |
| C-02 | tree-sitter-cでCコードをパース | E-01 (4-8行目) | ○ |
| C-03 | uv_setup_argsとuv_udp_try_send2のoverridesを定義 | E-01 (10-26行目) | ○ |
| C-04 | ripgrepでシンボル宣言を検索 | E-01 (50行目) | ○ |
| C-05 | ripgrep未インストール時はエラー終了 | E-01 (278-281行目) | ○ |
| C-06 | UV_EXTERNを含む行を検出 | E-01 (51-55行目) | ○ |
| C-07 | 複数行宣言を検出し結合 | E-01 (71-95行目) | ○ |
| C-08 | extractParameterTypes関数でパラメータを抽出 | E-01 (106-212行目) | ○ |
| C-09 | __bun_throw_not_implementedを呼ぶスタブを生成 | E-01 (249-252行目) | ○ |
| C-10 | __builtin_unreachable()を追加 | E-01 (251行目) | ○ |
| C-11 | uv-posix-stubs.cに出力 | E-01 (299行目) | ○ |
| C-12 | OS(LINUX) OR OS(DARWIN)の条件分岐を含む | E-01 (293-296行目) | ○ |
| C-13 | clang-formatでフォーマット | E-01 (300-302行目) | ○ |
| C-14 | テスト用plugin.cを生成 | E-01 (387-388行目) | ○ |
| C-15 | test_skippedの関数はテストプラグインから除外 | E-01 (345行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード生成ロジックは明確で外部ツールへの依存も適切にハンドリング
- 注意点: tree-sitterの解析結果に依存するため、特殊なC構文で問題が発生する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ripgrep、tree-sitter、tree-sitter-cがインストールされているか確認
- [ ] 生成されたCコードがコンパイル可能か確認
- [ ] overridesオブジェクトに追加が必要な特殊関数がないか確認
