---
generated_at: 2026-01-27 18:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-nav2readme.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/nav2readme.ts` 1-114行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 18行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | docs/nav.tsからナビゲーション項目をインポート | E-01 (10行目) | ○ |
| C-02 | divider項目はカテゴリ見出しとして出力 | E-01 (16-17行目) | ○ |
| C-03 | リンク項目はhttps://bun.com/docs/形式で出力 | E-01 (19行目) | ○ |
| C-04 | docs/guidesディレクトリを再帰スキャン | E-01 (29行目) | ○ |
| C-05 | .mdファイルのみを処理 | E-01 (31行目) | ○ |
| C-06 | front matterからname属性を抽出 | E-01 (37-43行目) | ○ |
| C-07 | カテゴリ（ディレクトリ）別にソート | E-01 (54-63行目) | ○ |
| C-08 | ## Quick linksマーカーを検索 | E-01 (80-83行目) | ○ |
| C-09 | ## Contributingマーカーを検索 | E-01 (86-89行目) | ○ |
| C-10 | マーカー未検出時はエラーをスロー | E-01 (82-83, 88-89行目) | ○ |
| C-11 | README.mdに結果を書き込み | E-01 (98行目) | ○ |
| C-12 | normalizeSectionName関数でカテゴリ名を変換 | E-01 (100-113行目) | ○ |
| C-13 | Https/Http/WebsocketをHTTPS/HTTP/WebSocketに変換 | E-01 (109-112行目) | ○ |
| C-14 | ハイフン区切りをスペース区切りに変換 | E-01 (101-106行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確で処理も単純

## 6) レビュアーチェックリスト（最小）
- [ ] README.mdに## Quick linksと## Contributingマーカーが存在するか確認
- [ ] docs/nav.tsのitemsが正しくエクスポートされているか確認
- [ ] ガイドファイルにname属性が設定されているか確認
