---
generated_at: 2026-01-27 18:54:00
metrics:
  claims_total: 5
  claims_with_evidence: 2
  claims_without_evidence: 3
confidence_derived: 0.40
---

# 根拠レポート：18-bump.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.40**
  - 根拠あり：2 / 5、根拠なし：3
- 優先レビュー（高）
  1. **処理内容全般**：ソースコードが存在しないため検証不可
  2. **入出力仕様**：推測に基づく
  3. **処理フロー**：推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` 53行目 - bumpスクリプト定義
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 19行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | package.jsonにbumpスクリプトが定義されている | E-01 | ○ |
| C-02 | バージョンバンプ処理を行う | E-02 | ○ |
| C-03 | 処理内容（バージョン計算、ファイル更新等） | **根拠なし（推測）** | △ |
| C-04 | 入力パラメータ（type: major/minor/patch） | **根拠なし（推測）** | △ |
| C-05 | 出力ファイル（package.json, LATEST） | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- **scripts/bump.tsファイルが存在しない**
  - package.jsonでは定義されているがファイルが見つからない
  - 候補：削除された / 別の場所に移動 / 別の方法でバージョン管理

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - ソースコードが存在しないため、設計書の大部分が推測に基づく
- バッチ一覧.csvと実際のリポジトリ状態に不整合がある

## 6) レビュアーチェックリスト（最小）
- [ ] **scripts/bump.tsの実装が必要か確認**
- [ ] バッチ一覧.csvの記載を更新する必要があるか確認
- [ ] 現在のバージョン管理方法を確認
- [ ] package.jsonのbumpスクリプト定義を削除または修正する必要があるか確認
