---
generated_at: 2026-01-27 18:58:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-pack-codegen-for-zig-team.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/pack-codegen-for-zig-team.ts` 1-167行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 20行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | git statusでローカル変更をチェック | E-01 (5-12行目) | ○ |
| C-02 | ローカル変更がある場合はエラー終了 | E-01 (7-12行目) | ○ |
| C-03 | --listen=-と--zig-lib-dirを引数から除去 | E-01 (36-44行目) | ○ |
| C-04 | 引数なしの場合は使用方法を表示 | E-01 (45-49行目) | ○ |
| C-05 | zigコマンドでない場合はエラー | E-01 (50-54行目) | ○ |
| C-06 | buildサブコマンドはサポート外 | E-01 (55-58行目) | ○ |
| C-07 | 引数から=を含むファイルパスを抽出 | E-01 (63-74行目) | ○ |
| C-08 | @import/@embedFileで依存ファイルを再帰解析 | E-01 (87行目) | ○ |
| C-09 | プロジェクト外のパスは除外 | E-01 (68-70行目) | ○ |
| C-10 | zig fmt --upstreamでフォーマット | E-01 (122-133行目) | ○ |
| C-11 | fmt失敗時はrevertUnstagedChangesを呼び出し | E-01 (128-132行目) | ○ |
| C-12 | -fsanitize-addressを除去 | E-01 (107-108行目) | ○ |
| C-13 | build/all.argsに引数を出力 | E-01 (97, 104-119行目) | ○ |
| C-14 | tarでcodegen-for-zig-team.tar.gzを作成 | E-01 (98, 136-145行目) | ○ |
| C-15 | --no-xattrsフラグを使用 | E-01 (137行目) | ○ |
| C-16 | 再現手順を標準出力に表示 | E-01 (147-162行目) | ○ |
| C-17 | 完了後にrevertUnstagedChangesでクリーンアップ | E-01 (165-166行目) | ○ |
| C-18 | git restore --worktreeで変更を元に戻す | E-01 (18-19行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確で処理フローも直線的
- 注意点: 作業ディレクトリを変更するため、他の作業と競合しないよう注意

## 6) レビュアーチェックリスト（最小）
- [ ] vendor/zig/zigが存在するか確認
- [ ] 公式Zigコンパイラでの再現テストを行う手順が明確か確認
- [ ] git restore --worktreeが正しく動作するか確認
