---
generated_at: 2026-01-27 10:31:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-label-issue.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/label-issue.ts` 行1-354（ソースコード全体）
- E-02: `scripts/label-issue.ts` 行1-291（ラベル定義配列）
- E-03: `scripts/label-issue.ts` 行293-295（Anthropic SDK初期化）
- E-04: `scripts/label-issue.ts` 行297-329（categorizeLabelsByClaudeAI関数）
- E-05: `scripts/label-issue.ts` 行301-303（claude-3-5-sonnet-20240620モデル指定）
- E-06: `scripts/label-issue.ts` 行304-314（システムプロンプト）
- E-07: `scripts/label-issue.ts` 行322-328（JSONパース処理）
- E-08: `scripts/label-issue.ts` 行331-334（Issue情報取得）
- E-09: `scripts/label-issue.ts` 行336-339（ラベルなし時の終了処理）
- E-10: `scripts/label-issue.ts` 行341-351（ラベル検証処理）
- E-11: `scripts/label-issue.ts` 行353（カンマ区切り出力）
- E-12: `バッチ一覧.csv` 行3（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ANTHROPIC_API_KEY環境変数を使用 | E-03 | ○ |
| C-02 | Claude 3.5 Sonnetモデルを使用 | E-05 | ○ |
| C-03 | 70以上のラベル定義を持つ | E-02 | ○ |
| C-04 | GITHUB_ISSUE_TITLEを環境変数から取得 | E-08 | ○ |
| C-05 | GITHUB_ISSUE_BODYを環境変数から取得 | E-08 | ○ |
| C-06 | JSON配列形式でラベルを取得 | E-06 | ○ |
| C-07 | max_tokensは2048 | E-04 | ○ |
| C-08 | 配列開始位置を検索してリカバリ | E-07 | ○ |
| C-09 | 存在しないラベルをフィルタリング | E-10 | ○ |
| C-10 | ラベルなし時はexit 0 | E-09 | ○ |
| C-11 | カンマ区切りで標準出力 | E-11 | ○ |
| C-12 | console.writeで出力 | E-11 | ○ |
| C-13 | ラベルにbun:crypto等が含まれる | E-02 | ○ |
| C-14 | ラベルにnode:fs等が含まれる | E-02 | ○ |
| C-15 | ラベルにweb:fetch等が含まれる | E-02 | ○ |
| C-16 | ラベルにlinux, macOS, windowsが含まれる | E-02 | ○ |
| C-17 | ラベルにbundler, npm等が含まれる | E-02 | ○ |
| C-18 | システムプロンプトでJSON配列出力を指示 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] ANTHROPIC_API_KEY環境変数の要件が正しく記載されているか
- [x] Claude APIモデル名が正しいか
- [x] ラベル定義の数と種類が正確か
- [x] 出力形式（カンマ区切り）が正しいか
- [x] エラー処理の記載が実装と一致しているか
