---
generated_at: 2026-01-27 19:02:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-is-outdated.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/is-outdated.ts` 1-61行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 21行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GITHUB_ISSUE_BODY環境変数を取得 | E-01 (2-4行目) | ○ |
| C-02 | 環境変数未設定時はErrorをスロー | E-01 (3-4行目) | ○ |
| C-03 | LATESTファイルから最新バージョンを読み込み | E-01 (7行目) | ○ |
| C-04 | standalone_executableでスタンドアロン判定 | E-01 (10行目) | ○ |
| C-05 | Issue本文を逆順でスキャン | E-01 (12行目) | ○ |
| C-06 | Bun vX.X.X on形式の行を検出 | E-01 (16行目) | ○ |
| C-07 | canary版は比較対象外 | E-01 (20-22行目) | ○ |
| C-08 | Bun.semver.satisfiesで有効性を検証 | E-01 (24-27行目) | ○ |
| C-09 | Bun.semver.orderで比較 | E-01 (38行目) | ○ |
| C-10 | is-outdated.txtに"true"を出力 | E-01 (42行目) | ○ |
| C-11 | outdated.txtにバージョンを出力 | E-01 (43行目) | ○ |
| C-12 | スタンドアロン時はis-standalone.txtを出力 | E-01 (46-48行目) | ○ |
| C-13 | メジャー/マイナー違いまたはパッチ差3以上で非常に古いと判定 | E-01 (50-51行目) | ○ |
| C-14 | is-very-outdated.txtを出力 | E-01 (54-55行目) | ○ |
| C-15 | 最新版と同じ場合は正常終了 | E-01 (29-31行目) | ○ |
| C-16 | latest/versionを標準出力に出力 | E-01 (33-36行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードから直接確認できます。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードの動作は明確でロジックも単純

## 6) レビュアーチェックリスト（最小）
- [ ] LATESTファイルが最新バージョンで更新されているか確認
- [ ] 出力ファイルの後続処理での使用方法を確認
- [ ] 非常に古いバージョンの判定条件（パッチ差3）が適切か確認
