---
generated_at: 2026-01-27 10:32:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-handle-crash-patterns.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/handle-crash-patterns.ts` 行1-112（ソースコード全体）
- E-02: `scripts/handle-crash-patterns.ts` 行3-8（環境変数取得・検証）
- E-03: `scripts/handle-crash-patterns.ts` 行19（bodyLower変換）
- E-04: `scripts/handle-crash-patterns.ts` 行22-28（workers_terminatedパターン）
- E-05: `scripts/handle-crash-patterns.ts` 行31-40（better-sqlite3パターン）
- E-06: `scripts/handle-crash-patterns.ts` 行43-58（ENOTCONN v1.2.23パターン）
- E-07: `scripts/handle-crash-patterns.ts` 行61-73（WASM IPIntパターン）
- E-08: `scripts/handle-crash-patterns.ts` 行76-98（CPU要件パターン）
- E-09: `scripts/handle-crash-patterns.ts` 行85-88（macOS検出）
- E-10: `scripts/handle-crash-patterns.ts` 行100-111（JSON出力処理）
- E-11: `バッチ一覧.csv` 行4（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GITHUB_ISSUE_NUMBER環境変数が必須 | E-02 | ○ |
| C-02 | GITHUB_ISSUE_BODYのデフォルト値は空文字 | E-02 | ○ |
| C-03 | GITHUB_ISSUE_TITLEのデフォルト値は空文字 | E-02 | ○ |
| C-04 | Issue本文を小文字に変換 | E-03 | ○ |
| C-05 | workers_terminatedパターンで#15964重複 | E-04 | ○ |
| C-06 | better-sqlite3 + runcommand/autocommandで#4290重複 | E-05 | ○ |
| C-07 | ENOTCONN + transport + standalone_executable + v1.2.23で#23342 | E-06 | ○ |
| C-08 | ENOTCONN問題はcompleted理由でクローズ | E-06 | ○ |
| C-09 | wasm_trampoline_wasm_ipint_call_wide32で#17841重複 | E-07 | ○ |
| C-10 | WASM問題の3つのワークアラウンド提示 | E-07 | ○ |
| C-11 | segmentation fault + no_avxでCPU要件問題 | E-08 | ○ |
| C-12 | illegal instruction + no_avxでCPU要件問題 | E-08 | ○ |
| C-13 | illegalinstructionでもマッチ | E-08 | ○ |
| C-14 | macOS検出でRosetta説明追加 | E-09 | ○ |
| C-15 | Platform行からmacOS/darwin検出 | E-09 | ○ |
| C-16 | マッチ時はclose: trueのJSON出力 | E-10 | ○ |
| C-17 | 非マッチ時はclose: falseのJSON出力 | E-10 | ○ |
| C-18 | console.writeでJSON出力 | E-10 | ○ |
| C-19 | v1.2.23バージョンは正規表現で検出 | E-06 | ○ |
| C-20 | CPU要件としてnehalem以降が必要 | E-08 | ○ |
| C-21 | bun upgradeコマンドを案内 | E-06 | ○ |
| C-22 | bun:sqliteの使用を推奨 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] 各クラッシュパターンの検出条件が正しく記載されているか
- [x] 重複先Issue番号が正確か
- [x] クローズ理由（not_planned/completed）が正しいか
- [x] ユーザーへの案内内容が適切か
- [x] macOS検出ロジックが正しいか
