---
generated_at: 2026-01-27 10:33:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-buildkite-failures.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/buildkite-failures.ts` 行1-1079（ソースコード全体）
- E-02: `scripts/buildkite-failures.ts` 行51-82（ヘルプメッセージ・引数定義）
- E-03: `scripts/buildkite-failures.ts` 行84-87（フラグ引数処理）
- E-04: `scripts/buildkite-failures.ts` 行93-148（入力形式判定・ビルド番号特定）
- E-05: `scripts/buildkite-failures.ts` 行173-174（ポーリング間隔10秒）
- E-06: `scripts/buildkite-failures.ts` 行175-276（ビルドステータス処理ループ）
- E-07: `scripts/buildkite-failures.ts` 行283-284（失敗ジョブ抽出条件）
- E-08: `scripts/buildkite-failures.ts` 行287-296（プラットフォームemoji定義）
- E-09: `scripts/buildkite-failures.ts` 行299-312（HTMLからアノテーション抽出）
- E-10: `scripts/buildkite-failures.ts` 行669-722（ANSIカラー変換）
- E-11: `scripts/buildkite-failures.ts` 行977-1006（ログファイル保存）
- E-12: `scripts/buildkite-failures.ts` 行19-36（fileToUrl関数）
- E-13: `scripts/buildkite-failures.ts` 行38-48（カラーコード定義・TTY判定）
- E-14: `バッチ一覧.csv` 行5（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビルド番号/ブランチ/PR URL/BuildKite URLに対応 | E-02, E-04 | ○ |
| C-02 | --flaky, -fオプションでFlakyテスト表示 | E-03 | ○ |
| C-03 | --warnings, -wオプションで警告表示 | E-03 | ○ |
| C-04 | --waitオプションでビルド完了まで待機 | E-03, E-06 | ○ |
| C-05 | --help, -hオプションでヘルプ表示 | E-02 | ○ |
| C-06 | 引数なしで現在のgitブランチを使用 | E-04 | ○ |
| C-07 | GitHub APIでPRからブランチ取得 | E-04 | ○ |
| C-08 | ポーリング間隔は10秒 | E-05 | ○ |
| C-09 | passed時は成功メッセージ表示 | E-06 | ○ |
| C-10 | canceled時はキャンセルメッセージ表示 | E-06 | ○ |
| C-11 | running時は進捗表示 | E-06 | ○ |
| C-12 | exit_status > 0で失敗ジョブ判定 | E-07 | ○ |
| C-13 | soft_failed=falseで失敗ジョブ判定 | E-07 | ○ |
| C-14 | darwin/macosは🍎で表示 | E-08 | ○ |
| C-15 | linux系は🐧で表示 | E-08 | ○ |
| C-16 | windows系は🪟で表示 | E-08 | ○ |
| C-17 | HTMLRewriterでアノテーション抽出 | E-09 | ○ |
| C-18 | term-fg*クラスをANSIコードに変換 | E-10 | ○ |
| C-19 | ログを/tmp/bun-build-{number}-{platform}-{step}.logに保存 | E-11 | ○ |
| C-20 | ファイルパスをfile://URLに変換 | E-12 | ○ |
| C-21 | TTY判定でカラー出力制御 | E-13 | ○ |
| C-22 | FORCE_COLOR=1でカラー強制 | E-13 | ○ |
| C-23 | #付き番号でPR番号指定可能 | E-04 | ○ |
| C-24 | buildkite.comを含むURLでビルド番号抽出 | E-04 | ○ |
| C-25 | github.com/pull/を含むURLでPR番号抽出 | E-04 | ○ |
| C-26 | 失敗時に失敗件数を表示 | E-06 | ○ |
| C-27 | アノテーションパースエラー時はURLを案内 | E-01 | ○ |
| C-28 | gitルートディレクトリを取得 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] 入力形式の判定ロジックが正しく記載されているか
- [x] ポーリング間隔が正確か
- [x] ビルドステータス別の処理が正しいか
- [x] ログファイルの命名規則が正確か
- [x] プラットフォームemojiマッピングが正しいか
