---
generated_at: 2026-01-27 10:34:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-buildkite-slow-tests.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/buildkite-slow-tests.js` 行1-108（ソースコード全体）
- E-02: `scripts/buildkite-slow-tests.js` 行12（テストグループ開始パターン）
- E-03: `scripts/buildkite-slow-tests.js` 行14-15（ファイル読み込み）
- E-04: `scripts/buildkite-slow-tests.js` 行17-43（行ループとパース処理）
- E-05: `scripts/buildkite-slow-tests.js` 行26（アテンプトパターン）
- E-06: `scripts/buildkite-slow-tests.js` 行28-37（実行時間計算とMap蓄積）
- E-07: `scripts/buildkite-slow-tests.js` 行46-53（ソート処理）
- E-08: `scripts/buildkite-slow-tests.js` 行66-71（引数チェック）
- E-09: `scripts/buildkite-slow-tests.js` 行77-79（サマリー出力）
- E-10: `scripts/buildkite-slow-tests.js` 行82-90（Top 10出力）
- E-11: `scripts/buildkite-slow-tests.js` 行95-105（1秒超テスト出力）
- E-12: `scripts/buildkite-slow-tests.js` 行57-64（formatAttempts関数）
- E-13: `scripts/buildkite-slow-tests.js` 行87-88（テストパス簡略化）
- E-14: `バッチ一覧.csv` 行6（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ログファイルパスを引数で受け取る | E-08 | ○ |
| C-02 | readFileSyncでファイル読み込み | E-03 | ○ |
| C-03 | _bk;t=タイムスタンプパターンで開始検出 | E-02 | ○ |
| C-04 | 次テスト開始時刻を前テスト終了時刻として使用 | E-04, E-06 | ○ |
| C-05 | attempt #Nパターンでリトライ回数抽出 | E-05 | ○ |
| C-06 | テストごとの合計時間をMapに蓄積 | E-06 | ○ |
| C-07 | 合計実行時間の降順でソート | E-07 | ○ |
| C-08 | Top 10を出力 | E-10 | ○ |
| C-09 | 1秒超のテスト一覧を出力 | E-11 | ○ |
| C-10 | 引数が1つでない場合はUsage表示 | E-08 | ○ |
| C-11 | テスト数と合計時間と平均時間を表示 | E-09 | ○ |
| C-12 | Markdown形式で出力 | E-09, E-10, E-11 | ○ |
| C-13 | アテンプト情報を各時間付きで表示 | E-12 | ○ |
| C-14 | test/を除去して簡略化 | E-13 | ○ |
| C-15 | .test.tsを除去して簡略化 | E-13 | ○ |
| C-16 | .test.jsを除去して簡略化 | E-13 | ○ |
| C-17 | 実行時間は秒単位で表示 | E-10, E-11 | ○ |
| C-18 | 小数点以下1桁または2桁で表示 | E-10, E-11 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] ログ解析パターンが正確か
- [x] 実行時間計算ロジックが正しく説明されているか
- [x] 出力フォーマットの記載が正確か
- [x] 引数チェックの記載が正しいか
- [x] アテンプト情報の処理が正しく説明されているか
