---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-sort-imports.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/sort-imports.ts` 行1-444（ソースコード全体）
- E-02: `scripts/sort-imports.ts` 行6-34（引数パース・ヘルプ）
- E-03: `scripts/sort-imports.ts` 行36-41（config定義）
- E-04: `scripts/sort-imports.ts` 行54-119（parseDeclarations関数）
- E-05: `scripts/sort-imports.ts` 行75（宣言パターン正規表現）
- E-06: `scripts/sort-imports.ts` 行90-99（未使用検出ロジック）
- E-07: `scripts/sort-imports.ts` 行130-152（parseSegments関数）
- E-08: `scripts/sort-imports.ts` 行184-218（groupDeclarationsByImportPath関数）
- E-09: `scripts/sort-imports.ts` 行221-242（mergeSingleItemGroups関数）
- E-10: `scripts/sort-imports.ts` 行245-259（promoteItemsWithChildGroups関数）
- E-11: `scripts/sort-imports.ts` 行262-277（sortGroupsAndDeclarations関数）
- E-12: `scripts/sort-imports.ts` 行300-308（extractThisDeclaration関数）
- E-13: `scripts/sort-imports.ts` 行313-403（processFile関数）
- E-14: `scripts/sort-imports.ts` 行317-322（パス正規化）
- E-15: `scripts/sort-imports.ts` 行406-441（main関数）
- E-16: `バッチ一覧.csv` 行7（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ファイルパスまたはディレクトリを引数で受け取る | E-02 | ○ |
| C-02 | --helpでヘルプ表示 | E-02 | ○ |
| C-03 | --include-pubでpub宣言も含める | E-03 | ○ |
| C-04 | --keep-unusedで未使用インポート保持 | E-03 | ○ |
| C-05 | .zigファイルを再帰的に取得 | E-15 | ○ |
| C-06 | const X = ...形式の宣言をパース | E-05 | ○ |
| C-07 | pub修飾子はオプション | E-05 | ○ |
| C-08 | 1回のみ出現で未使用判定 | E-06 | ○ |
| C-09 | doc commentがある宣言は対象外 | E-04 | ○ |
| C-10 | @import()パスでグループ化 | E-08 | ○ |
| C-11 | 1項目グループを親にマージ | E-09 | ○ |
| C-12 | 子グループ持ち項目を先頭に移動 | E-10 | ○ |
| C-13 | アルファベット順でソート | E-11 | ○ |
| C-14 | @This()宣言を先頭に移動 | E-12, E-13 | ○ |
| C-15 | 変更がある場合のみ書き込み | E-13 | ○ |
| C-16 | @import("file.zig")を@import("./file.zig")に正規化 | E-14 | ○ |
| C-17 | @import("./../file.zig")を@import("../file.zig")に正規化 | E-14 | ○ |
| C-18 | グループ間に空行を挿入 | E-13 | ○ |
| C-19 | 処理成功時にDone: {filepath}を出力 | E-13 | ○ |
| C-20 | 成功件数とエラー件数を出力 | E-15 | ○ |
| C-21 | エラー時も次ファイルへ継続 | E-15 | ○ |
| C-22 | 未使用削除で変更がある間は再処理 | E-13 | ○ |
| C-23 | @sortImportsコメントを削除 | E-04 | ○ |
| C-24 | 行末コメントを保持 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] 宣言パターンの正規表現が正確か
- [x] 未使用検出ロジックが正しく説明されているか
- [x] グループ化・マージ・ソートのロジックが正確か
- [x] @This()の特別処理が正しく説明されているか
- [x] パス正規化のルールが正確か
