---
generated_at: 2026-01-27 10:37:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-fetch-node-test.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/fetch-node-test.ts` 行1-113（ソースコード全体）
- E-02: `scripts/fetch-node-test.ts` 行4-10（GITHUB_TOKEN処理）
- E-03: `scripts/fetch-node-test.ts` 行12-87（fetchNodeTest関数）
- E-04: `scripts/fetch-node-test.ts` 行13-15（URL・拡張子・ディレクトリ定義）
- E-05: `scripts/fetch-node-test.ts` 行17-23（テスト名バリエーション生成）
- E-06: `scripts/fetch-node-test.ts` 行25-55（拡張子付きパターン試行）
- E-07: `scripts/fetch-node-test.ts` 行57-83（拡張子なしパターン試行）
- E-08: `scripts/fetch-node-test.ts` 行38-49（ファイル保存・成功メッセージ）
- E-09: `scripts/fetch-node-test.ts` 行89-100（パス前処理）
- E-10: `scripts/fetch-node-test.ts` 行102-105（引数チェック）
- E-11: `scripts/fetch-node-test.ts` 行44-47（ファイルサイズ表示）
- E-12: `バッチ一覧.csv` 行9（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テスト名を引数で受け取る | E-10 | ○ |
| C-02 | テスト名未指定時はUsage表示 | E-10 | ○ |
| C-03 | raw.githubusercontent.comからダウンロード | E-04 | ○ |
| C-04 | test/parallel、test/sequentialを検索 | E-04 | ○ |
| C-05 | js、mjs、ts拡張子を試行 | E-04 | ○ |
| C-06 | test-プレフィックス有無のバリエーション生成 | E-05 | ○ |
| C-07 | test/js/node/配下に保存 | E-08 | ○ |
| C-08 | mkdirSyncでディレクトリ作成 | E-08 | ○ |
| C-09 | writeFileSyncでファイル書き込み | E-08 | ○ |
| C-10 | "Trying: {url}"を出力 | E-06 | ○ |
| C-11 | 成功時に"Successfully fetched and saved"を出力 | E-08 | ○ |
| C-12 | 失敗時に"Could not find test"を出力 | E-03 | ○ |
| C-13 | GITHUB_TOKEN環境変数でAuthorizationヘッダー設定 | E-02 | ○ |
| C-14 | Intl.NumberFormatでファイルサイズ表示 | E-11 | ○ |
| C-15 | スクリプトパスプレフィックスを除去 | E-09 | ○ |
| C-16 | test/parallel/プレフィックスを除去 | E-09 | ○ |
| C-17 | test/sequential/プレフィックスを除去 | E-09 | ○ |
| C-18 | 拡張子なしパターンも試行 | E-07 | ○ |
| C-19 | recursive: trueでディレクトリ作成 | E-08 | ○ |
| C-20 | 成功したらlocalPathを返す | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] GitHub rawコンテンツURLが正確か
- [x] 検索対象ディレクトリが正しいか
- [x] 拡張子の試行順序が正しいか
- [x] テスト名バリエーションのロジックが正確か
- [x] 保存先パスが正しいか
