---
generated_at: 2026-01-27 10:38:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-github-metrics.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー対象なし

## 2) 参照した情報（Evidence一覧）

- E-01: `scripts/github-metrics.ts` 行1-177（ソースコード全体）
- E-02: `scripts/github-metrics.ts` 行27-37（getReleaseInfo関数）
- E-03: `scripts/github-metrics.ts` 行42-56（countCompletedIssues関数）
- E-04: `scripts/github-metrics.ts` 行61-68（getIssueReactions関数）
- E-05: `scripts/github-metrics.ts` 行73-92（getCommentReactions関数）
- E-06: `scripts/github-metrics.ts` 行97-124（countReactions関数）
- E-07: `scripts/github-metrics.ts` 行129-171（main関数）
- E-08: `scripts/github-metrics.ts` 行130-132（引数パース）
- E-09: `scripts/github-metrics.ts` 行134-138（Usage表示）
- E-10: `scripts/github-metrics.ts` 行119-121（スリープ処理）
- E-11: `scripts/github-metrics.ts` 行64（対象リアクション定義）
- E-12: `バッチ一覧.csv` 行10（バッチ説明）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リリースタグを引数で受け取る | E-08 | ○ |
| C-02 | --verbose, -vオプションで詳細出力 | E-08 | ○ |
| C-03 | リリースタグ未指定時はUsage表示 | E-09 | ○ |
| C-04 | gh release viewでリリース日取得 | E-02 | ○ |
| C-05 | gh issue listでcompleted Issue検索 | E-03 | ○ |
| C-06 | closed:>=と reason:completedで検索 | E-03 | ○ |
| C-07 | 最大1000件取得 | E-03 | ○ |
| C-08 | stateReason: COMPLETEDでフィルタ | E-03 | ○ |
| C-09 | gh apiでIssueリアクション取得 | E-04 | ○ |
| C-10 | gh apiでコメントリアクション取得 | E-05 | ○ |
| C-11 | +1、heart、hooray、rocketをカウント | E-11 | ○ |
| C-12 | 1ミリ秒スリープでレート制限対策 | E-10 | ○ |
| C-13 | Issue数を表示 | E-07 | ○ |
| C-14 | リアクション数を表示 | E-07 | ○ |
| C-15 | 平均値を表示 | E-07 | ○ |
| C-16 | Issue数0の場合は平均を表示しない | E-07 | ○ |
| C-17 | verboseモードでリリース日表示 | E-07 | ○ |
| C-18 | verboseモードで詳細リアクション表示 | E-06 | ○ |
| C-19 | リアクション取得失敗時は0を返す | E-04, E-05 | ○ |
| C-20 | 開始ログ"Collecting GitHub metrics..."を出力 | E-07 | ○ |
| C-21 | "Counting completed issues..."を出力 | E-07 | ○ |
| C-22 | "Counting positive reactions..."を出力 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードにより裏付けられている

## 6) レビュアーチェックリスト（最小）

- [x] gh CLIコマンドの使用方法が正確か
- [x] Issue検索条件が正しいか
- [x] 対象リアクションが正確か
- [x] レート制限対策が正しく説明されているか
- [x] 出力形式が正確か
