---
generated_at: 2026-01-31 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 92
  claims_without_evidence: 8
confidence_derived: 0.92
---

# 根拠レポート：api.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：92 / 100、根拠なし：8
- 優先レビュー（高）
  1. **UT-API-098（Archive.extract）**：Archive.zigの実装詳細が一部不明
  2. **UT-API-099〜100（UDPSocket）**：udp_socket.zigの詳細未確認
  3. **UT-API-065〜067（FFI）**：FFI関連の一部テストケースが推測に基づく

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/api/server.zig` - Bun.serve実装
- E-02: `src/bun.js/api/BunObject.zig` - BunObject全体の定義
- E-03: `src/bun.js/api/bun/subprocess.zig` - Bun.spawn/spawnSync実装
- E-04: `src/bun.js/api/glob.zig` - Bun.Glob実装
- E-05: `src/bun.js/api/html_rewriter.zig` - HTMLRewriter実装
- E-06: `src/bun.js/api/filesystem_router.zig` - FileSystemRouter実装
- E-07: `src/bun.js/api/crypto/CryptoHasher.zig` - CryptoHasher実装
- E-08: `src/bun.js/api/Timer.zig` - Timer関連実装
- E-09: `src/bun.js/api/bun/socket.zig` - Socket/Listener実装
- E-10: `src/bun.js/api/server/ServerWebSocket.zig` - ServerWebSocket実装
- E-11: `src/bun.js/api/ffi.zig` - FFI実装
- E-12: `src/bun.js/api/bun/dns.zig` - DNS解決実装
- E-13: `src/bun.js/api/JSTranspiler.zig` - Transpiler実装
- E-14: `src/bun.js/api/JSBundler.zig` - Bundler実装

## 3) Claims と根拠の対応（レビューの主戦場）

### Bun.serve関連（UT-API-001〜003）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Bun.serveでHTTPサーバーが起動できる | E-01, E-02 | ○ |
| C-02 | 無効なオプションでエラーがスローされる | E-01 | ○ |
| C-03 | WebSocketハンドラが設定できる | E-01, E-10 | ○ |

### Bun.file/write関連（UT-API-004〜007）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | Bun.fileでBlobが作成される | E-02 | ○ |
| C-05 | 存在しないファイルでも遅延エラー | E-02 | ○ |
| C-06 | Bun.writeでファイル書き込み | E-02 | ○ |
| C-07 | Blobからファイルに書き込み可能 | E-02 | ○ |

### Subprocess関連（UT-API-008〜013）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 | spawn基本機能 | E-03 | ○ |
| C-09 | stdin/stdout/stderrパイプ | E-03 | ○ |
| C-10 | 無効コマンドでエラー | E-03 | ○ |
| C-11 | spawnSync基本機能 | E-03 | ○ |
| C-12 | タイムアウト処理 | E-03 | ○ |
| C-13 | resourceUsage取得 | E-03 | ○ |

### Glob関連（UT-API-014〜018）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | Glob初期化 | E-04 | ○ |
| C-15 | 引数なしでエラー | E-04 | ○ |
| C-16 | scanでファイル列挙 | E-04 | ○ |
| C-17 | dotオプション | E-04 | ○ |
| C-18 | matchメソッド | E-04 | ○ |

### HTMLRewriter関連（UT-API-019〜024）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | HTMLRewriter初期化 | E-05 | ○ |
| C-20 | onでセレクタ登録 | E-05 | ○ |
| C-21 | 無効セレクタでエラー | E-05 | ○ |
| C-22 | onDocumentハンドラ | E-05 | ○ |
| C-23 | transform処理 | E-05 | ○ |
| C-24 | body使用済みエラー | E-05 | ○ |

### FileSystemRouter関連（UT-API-025〜031）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | FileSystemRouter初期化 | E-06 | ○ |
| C-26 | style必須 | E-06 | ○ |
| C-27 | 無効ディレクトリエラー | E-06 | ○ |
| C-28 | matchメソッド | E-06 | ○ |
| C-29 | Request対応 | E-06 | ○ |
| C-30 | ルートパスマッチ | E-06 | ○ |
| C-31 | reload機能 | E-06 | ○ |

### CryptoHasher関連（UT-API-032〜040）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | CryptoHasher初期化 | E-07 | ○ |
| C-33 | 無効アルゴリズムエラー | E-07 | ○ |
| C-34 | update基本機能 | E-07 | ○ |
| C-35 | TypedArray対応 | E-07 | ○ |
| C-36 | digestバイナリ出力 | E-07 | ○ |
| C-37 | digest hex出力 | E-07 | ○ |
| C-38 | digest base64出力 | E-07 | ○ |
| C-39 | byteLength取得 | E-07 | ○ |
| C-40 | algorithm取得 | E-07 | ○ |

### Timer関連（UT-API-041〜047）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | setTimeout基本機能 | E-08 | ○ |
| C-42 | 遅延実行 | E-08 | ○ |
| C-43 | 負値警告 | E-08 | ○ |
| C-44 | clearTimeout | E-08 | ○ |
| C-45 | setInterval基本機能 | E-08 | ○ |
| C-46 | clearInterval | E-08 | ○ |
| C-47 | setImmediate基本機能 | E-08 | ○ |

### Socket/Listener関連（UT-API-048〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | TCP接続確立 | E-09 | ○ |
| C-49 | TLS接続確立 | E-09 | ○ |
| C-50 | 接続失敗エラー | E-09 | ○ |
| C-51 | writeメソッド | E-09 | ○ |
| C-52 | closeメソッド | E-09 | ○ |
| C-53 | setKeepAlive | E-09 | ○ |
| C-54 | setNoDelay | E-09 | ○ |
| C-55 | listen基本機能 | E-09 | ○ |
| C-56 | Unixソケット | E-09 | ○ |
| C-57 | stop機能 | E-09 | ○ |

### ServerWebSocket関連（UT-API-058〜064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | テキストメッセージ送信 | E-10 | ○ |
| C-59 | バイナリメッセージ送信 | E-10 | ○ |
| C-60 | close基本機能 | E-10 | ○ |
| C-61 | クローズオプション | E-10 | ○ |
| C-62 | publish機能 | E-10 | ○ |
| C-63 | subscribe機能 | E-10 | ○ |
| C-64 | unsubscribe機能 | E-10 | ○ |

### FFI関連（UT-API-065〜067）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | dlopen基本機能 | E-11 | ○ |
| C-66 | ライブラリロードエラー | E-11 | ○ |
| C-67 | CString処理 | E-11 | △ |

### DNS関連（UT-API-068〜071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | lookup基本機能 | E-12 | ○ |
| C-69 | IPv4指定 | E-12 | ○ |
| C-70 | IPv6指定 | E-12 | ○ |
| C-71 | DNSエラー | E-12 | ○ |

### BunObject各種メソッド（UT-API-072〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | which基本機能 | E-02 | ○ |
| C-73 | which非存在 | E-02 | ○ |
| C-74 | resolve | E-02 | ○ |
| C-75 | resolveSync | E-02 | ○ |
| C-76 | nanoseconds | E-02 | ○ |
| C-77 | sleepSync | E-02 | ○ |
| C-78 | sleepSync境界値 | E-02 | △ |
| C-79 | inspect | E-02 | ○ |
| C-80 | inspect深さオプション | E-02 | ○ |
| C-81 | gzipSync | E-02 | ○ |
| C-82 | gunzipSync | E-02 | ○ |
| C-83 | deflateSync | E-02 | ○ |
| C-84 | inflateSync | E-02 | ○ |
| C-85 | zstdCompressSync | E-02 | ○ |
| C-86 | zstdDecompressSync | E-02 | ○ |
| C-87 | shellEscape | E-02 | ○ |
| C-88 | braces | E-02 | ○ |

### ルーティング関連（UT-API-089〜093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | AnyRoute.fromOptions | E-01 | ○ |
| C-90 | memoryCost | E-01 | ○ |
| C-91 | ServerConfig.fromJS | E-01 | △ |
| C-92 | StaticRoute.fromJS | E-01 | △ |
| C-93 | FileRoute.fromJS | E-01 | △ |

### Transpiler/Bundler関連（UT-API-094〜097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | transform | E-13 | ○ |
| C-95 | transformSync | E-13 | ○ |
| C-96 | build基本機能 | E-14 | ○ |
| C-97 | 複数エントリー | E-14 | ○ |

### その他（UT-API-098〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | Archive.extract | **根拠不足** | △ |
| C-99 | UDPSocket.send | **根拠不足** | △ |
| C-100 | UDPSocket.close | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の理由

1. **UT-API-067（FFI.CString）**
   - CString処理の詳細な動作仕様がソースコードから完全に確認できなかった
   - 候補：ffi.zig / FFIObject.zig / テストコード

2. **UT-API-078（sleepSync境界値）**
   - 0msの具体的な挙動はソースコードで確認できるが、テストケースの期待結果が推測
   - 候補：Timer.zig / 既存テストケース

3. **UT-API-091〜093（ServerConfig, StaticRoute, FileRoute）**
   - これらの内部クラスのfromJS実装詳細は別ファイルに分離
   - 候補：server/ServerConfig.zig / server/StaticRoute.zig / server/FileRoute.zig

4. **UT-API-098（Archive.extract）**
   - Archive.zigの読み込み範囲が限定的だった
   - 候補：Archive.zig全体 / テストコード

5. **UT-API-099〜100（UDPSocket）**
   - udp_socket.zigの詳細読み込みが未実施
   - 候補：bun/udp_socket.zig / テストコード

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1 | FFI関連テスト | セキュリティに関わるため、境界条件のテストが重要 |
| 1 | WebSocket関連テスト | 接続状態管理に関するエッジケースが多い |
| 0 | Timer関連テスト | Node.js互換性が重要だが、基本機能は安定 |
| 0 | 圧縮/解凍テスト | 標準ライブラリベースで安定 |
| 1 | サブプロセス関連 | プラットフォーム依存の挙動差異に注意 |

リスクレベル凡例：
- 0: 低リスク - 標準的なレビューで十分
- 1: 中リスク - 追加テストケースの検討推奨
- 2: 高リスク - 詳細な設計レビュー必須

## 6) レビュアーチェックリスト（最小）

- [ ] FFI.CString（UT-API-067）の動作仕様を確認する
- [ ] Archive.extract（UT-API-098）のエラーハンドリングを確認する
- [ ] UDPSocket関連（UT-API-099〜100）のAPIを確認する
- [ ] 各APIのエラーメッセージが適切かを確認する
- [ ] プラットフォーム固有の挙動（Windows/macOS/Linux）を確認する
- [ ] WebSocket Pub/Sub機能（UT-API-062〜064）の並行処理を確認する
- [ ] Subprocess関連（UT-API-008〜013）のシグナルハンドリングを確認する
