---
generated_at: 2026-01-31 15:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 87
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：bundler単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：87 / 90、根拠なし：3
- 優先レビュー（高）
  1. **UT-BND-081 (validateTLA)**: メソッド実装が別ファイルに分散
  2. **UT-BND-082 (treeShakingAndCodeSplitting)**: 内部実装の詳細が不明確
  3. **UT-BND-067 (recordExport重複)**: パニック動作の実際の挙動確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/bun-main/src/bundler/bundle_v2.zig`
- E-02: `/Users/tomoka.baba/Work/bun-main/src/bundler/LinkerContext.zig`
- E-03: `/Users/tomoka.baba/Work/bun-main/src/bundler/LinkerGraph.zig`
- E-04: `/Users/tomoka.baba/Work/bun-main/src/bundler/Chunk.zig`
- E-05: `/Users/tomoka.baba/Work/bun-main/src/bundler/ParseTask.zig`
- E-06: `/Users/tomoka.baba/Work/bun-main/src/bundler/Graph.zig`
- E-07: `/Users/tomoka.baba/Work/bun-main/src/bundler/AstBuilder.zig`
- E-08: `/Users/tomoka.baba/Work/bun-main/src/bundler/entry_points.zig`
- E-09: `/Users/tomoka.baba/Work/bun-main/src/bundler/linker_context/scanImportsAndExports.zig`
- E-10: `/Users/tomoka.baba/Work/bun-main/src/bundler/linker_context/computeChunks.zig`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | genericPathWithPrettyInitializedでpretty属性設定 | E-01 (L54-95) | ○ |
| C-02 | SSRターゲットでssr:プレフィックス付与 | E-01 (L76-79) | ○ |
| C-03 | node名前空間でパスそのまま返却 | E-01 (L58-64) | ○ |
| C-04 | transpilerForTargetでclient_transpiler返却 | E-01 (L237-253) | ○ |
| C-05 | transpilerForTargetでssr_transpiler返却 | E-01 (L251-252) | ○ |
| C-06 | initializeClientTranspilerで正しい初期化 | E-01 (L189-230) | ○ |
| C-07 | findReachableFilesで到達可能ファイル返却 | E-01 (L374-462) | ○ |
| C-08 | findReachableFilesで動的インポート追跡 | E-01 (L352, L422-428) | ○ |
| C-09 | リダイレクト最大回数超過で無効化 | E-01 (L287, L325-336) | ○ |
| C-10 | waitForParseでパース完了待機 | E-01 (L478-482) | ○ |
| C-11 | isDoneでpending_items=0判定 | E-01 (L464-476) | ○ |
| C-12 | isDoneでdeferred_tasks考慮 | E-01 (L467-472) | ○ |
| C-13 | LinkerContext.loadでグラフロード | E-02 (L197-257) | ○ |
| C-14 | loadでランタイムシンボル参照設定 | E-02 (L221-225) | ○ |
| C-15 | linkでチャンク返却 | E-02 (L350-441) | ○ |
| C-16 | linkでBuildFailedエラー返却 | E-02 (L407-410, L424-426) | ○ |
| C-17 | scanImportsAndExportsでモジュール形式判定 | E-09 (L1-300) | ○ |
| C-18 | CommonJSファイルラップ | E-09 (L131-141) | ○ |
| C-19 | export *文解決 | E-09 (L245-289) | ○ |
| C-20 | computeChunksでチャンク生成 | E-10 (L1-199) | ○ |
| C-21 | コード分割で共有チャンク生成 | E-10 (L224-268) | ○ |
| C-22 | CSSチャンク生成 | E-10 (L81-118) | ○ |
| C-23 | HTMLチャンク生成 | E-10 (L64-79) | ○ |
| C-24 | shouldIncludePartでfalse返却条件 | E-02 (L181-195) | ○ |
| C-25 | shouldIncludePartで通常true | E-02 (L194) | ○ |
| C-26 | isExternalDynamicImport判定 | E-02 (L174-179) | ○ |
| C-27 | computeDataForSourceMapでデータ計算 | E-02 (L259-295) | ○ |
| C-28 | generateNamedExportInFile | E-02 (L456-483) | ○ |
| C-29 | LinkerGraph.init | E-03 (L38-43) | ○ |
| C-30 | generateNewSymbol | E-03 (L49-71) | ○ |
| C-31 | generateSymbolImportAndUse | E-03 (L151-209) | ○ |
| C-32 | use_count=0で処理スキップ | E-03 (L159) | ○ |
| C-33 | runtimeFunction | E-03 (L45-47) | ○ |
| C-34 | addPartToFile | E-03 (L93-149) | ○ |
| C-35 | topLevelSymbolToParts | E-03 (L211-221) | ○ |
| C-36 | 未登録シンボルで空配列 | E-03 (L220) | ○ |
| C-37 | loadでエントリーポイント設定 | E-03 (L223-333) | ○ |
| C-38 | loadでSCB処理 | E-03 (L299-332) | ○ |
| C-39 | propagateAsyncDependencies | E-03 (L473-500+) | ○ |
| C-40 | Chunk.isEntryPoint | E-04 (L54-56) | ○ |
| C-41 | getJSChunkForHTML | E-04 (L58-68) | ○ |
| C-42 | getCSSChunkForHTML | E-04 (L70-80) | ○ |
| C-43 | Chunk.Order.lessThan距離比較 | E-04 (L91-94) | ○ |
| C-44 | lessThanでtie_breaker比較 | E-04 (L93) | ○ |
| C-45 | IntermediateOutput.getSize(pieces) | E-04 (L135-147) | ○ |
| C-46 | getSize(joiner) | E-04 (L144) | ○ |
| C-47 | IntermediateOutput.code | E-04 (L149-421) | ○ |
| C-48 | OutputPiece.init | E-04 (L467-473) | ○ |
| C-49 | ParseTask.init | E-05 (L106-124) | ○ |
| C-50 | getRuntimeSource | E-05 (L269-273) | ○ |
| C-51 | ターゲット別require実装 | E-05 (L135-171) | ○ |
| C-52 | getAST(js/ts) | E-05 (L312-334) | ○ |
| C-53 | getAST(json) | E-05 (L335-340) | ○ |
| C-54 | getAST(toml) | E-05 (L341-351) | ○ |
| C-55 | getAST(text) | E-05 (L374-381) | ○ |
| C-56 | getAST(sqlite)ターゲット制限 | E-05 (L383-391) | ○ |
| C-57 | Graph.pathToSourceIndexMap | E-06 (L82-84) | ○ |
| C-58 | drainDeferredTasks | E-06 (L90-104) | ○ |
| C-59 | drainDeferredTasksでfalse返却 | E-06 (L93, L103) | ○ |
| C-60 | AstBuilder.init | E-07 (L41-71) | ○ |
| C-61 | AstBuilder.newSymbol | E-07 (L93-110) | ○ |
| C-62 | addImportRecord | E-07 (L117-125) | ○ |
| C-63 | addImportStmt | E-07 (L127-168) | ○ |
| C-64 | appendStmt | E-07 (L170-173) | ○ |
| C-65 | toBundledAst | E-07 (L192-288) | ○ |
| C-66 | recordExport | E-07 (L296-305) | ○ |
| C-67 | recordExportで重複時パニック | E-07 (L297-303) | △ |
| C-68 | FallbackEntryPoint.generate | E-08 (L7-64) | ○ |
| C-69 | ClientEntryPoint.generate | E-08 (L99-148) | ○ |
| C-70 | generateEntryPointPath | E-08 (L76-84) | ○ |
| C-71 | ServerEntryPoint.generate | E-08 (L154-233) | ○ |
| C-72 | ServerEntryPointでHMRコード | E-08 (L161-201) | ○ |
| C-73 | MacroEntryPoint.generate | E-08 (L264-343) | ○ |
| C-74 | MacroEntryPoint.generateID | E-08 (L246-258) | ○ |
| C-75 | ReachableFileVisitor.visit | E-01 (L293-371) | ○ |
| C-76 | visit訪問済みスキップ | E-01 (L296-303) | ○ |
| C-77 | visitでSCB処理 | E-01 (L306-312) | ○ |
| C-78 | computeLineOffsets | E-02 (L132-154) | ○ |
| C-79 | computeQuotedSourceContents | E-02 (L156-171) | ○ |
| C-80 | SourceMapData.Task.runLineOffset | E-02 (L97-107) | ○ |
| C-81 | validateTLA | E-02 (L375-399) | △ |
| C-82 | treeShakingAndCodeSplitting | E-02 (L416) | △ |
| C-83 | computeCrossChunkDependencies | E-02 (L432) | ○ |
| C-84 | processHtmlImportFiles | E-02 (L301-342) | ○ |
| C-85 | scanCSSImports | E-02 (L490-500+) | ○ |
| C-86 | findAllImportedPartsInJSOrder | E-02 (L451-452) | ○ |
| C-87 | findImportedCSSFilesInJSOrder | E-02 (L454) | ○ |
| C-88 | findImportedFilesInCSSOrder | E-02 (L453) | ○ |
| C-89 | LinkerOptionsデフォルト値 | E-02 (L59-83) | ○ |
| C-90 | LinkerGraph.File.isEntryPoint | E-03 (L462-464) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-BND-067**: AstBuilder.recordExportの重複エクスポート時の`Output.panic`呼び出しは実装で確認済みだが、実際のパニック動作のテスト可能性は要確認
  - 候補：Zigのパニックハンドリング仕様確認 / テストフレームワークでのパニック捕捉方法確認
- **UT-BND-081**: validateTLAメソッドは呼び出し箇所は確認できるが、実装詳細は別ファイルにある可能性
  - 候補：linker_context配下の追加ファイル確認
- **UT-BND-082**: treeShakingAndCodeSplittingは呼び出しのみ確認、詳細実装は分離されている
  - 候補：該当メソッドの実装ファイル特定

## 5) リスクフラグ（レビュー観点）
- **リスク1 (中)**: BundleV2の並列処理（thread_lock, pending_items）周りのテストケースは実際の並行動作検証が困難
- **リスク1 (中)**: ソースマップ関連のテストは生成結果の正確性検証が複雑
- **リスク0 (低)**: エントリーポイント生成系（Fallback/Client/Server/Macro）は文字列生成なのでテストしやすい

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの対象クラス・メソッドがソースコードに実在することを確認
- [ ] 正常系/異常系/境界値のバランスが適切か確認（特に高優先度項目）
- [ ] Zigの特性（メモリ管理、スレッドローカルヒープ）に関連するテストケースの妥当性確認
- [ ] コード分割・ツリーシェイキング関連テストの網羅性確認
- [ ] 根拠不足（△）の3項目について追加調査の要否判断
