---
generated_at: 2026-01-31 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 98
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：cli.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：98 / 100、根拠なし：2
- 優先レビュー（高）
  1. **C-99, C-100**：Template.createAgentRule関連 - 環境依存のため実際の動作確認が困難
  2. **C-65-68**：UpgradeCommand.getLatestVersion - ネットワーク依存テストの実装方法要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/bunx_command.zig` - BunxCommand実装（Options.parse, addCreatePrefix, getBinName系メソッド）
- E-02: `src/cli/run_command.zig` - RunCommand実装（findShell, replacePackageManagerRun, configureEnvForRun, exec等）
- E-03: `src/cli/init_command.zig` - InitCommand実装（prompt, radio, normalizePackageName, Assets, Template）
- E-04: `src/cli/upgrade_command.zig` - UpgradeCommand実装（Version struct, getLatestVersion, exec）
- E-05: `src/cli/build_command.zig` - BuildCommand実装（exec, オプション処理）
- E-06: `src/cli/Arguments.zig` - CLI引数パラメータ定義（base_params_, transpiler_params_, runtime_params_等）
- E-07: `src/cli/add_command.zig` - AddCommand実装
- E-08: `src/cli/install_command.zig` - InstallCommand実装
- E-09: `src/cli/create_command.zig` - CreateCommand実装
- E-10: `src/cli/exec_command.zig` - ExecCommand実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BunxCommand.Options.parseでパッケージ名がパースされる | E-01 (L32-130) | ○ |
| C-02 | --versionフラグでバージョン表示 | E-01 (L52-53) | ○ |
| C-03 | --silentフラグ設定 | E-01 (L58-59) | ○ |
| C-04 | --verboseフラグ設定 | E-01 (L56-57) | ○ |
| C-05 | --no-installフラグ設定 | E-01 (L62-63) | ○ |
| C-06 | --packageフラグでパッケージとバイナリ名分離 | E-01 (L64-75) | ○ |
| C-07 | --package=value形式のパース | E-01 (L76-82) | ○ |
| C-08 | パッケージ名なしで終了 | E-01 (L117-126) | ○ |
| C-09 | --packageに空文字列でエラー | E-01 (L78-80) | ○ |
| C-10 | --packageでバイナリ名未指定エラー | E-01 (L108-112) | ○ |
| C-11 | addCreatePrefixで通常パッケージ変換 | E-01 (L140-176) | ○ |
| C-12 | スコープ付きパッケージ変換 (@org/some) | E-01 (L146-155) | ○ |
| C-13 | スコープ+バージョン変換 | E-01 (L149) | ○ |
| C-14 | スコープのみ変換 (@org) | E-01 (L164-168) | ○ |
| C-15 | @org@v形式変換 | E-01 (L157-163) | ○ |
| C-16 | 空文字列の境界値 | E-01 (L143) | ○ |
| C-17 | getBinNameFromSubpathでbinオブジェクト取得 | E-01 (L183-226) | ○ |
| C-18 | bin文字列形式でname使用 | E-01 (L217-223) | ○ |
| C-19 | directories.binからバイナリ名取得 | E-01 (L228-248) | ○ |
| C-20 | binフィールドなしでエラー | E-01 (L250) | ○ |
| C-21 | getBinNameFromTempDirectoryでキャッシュ解決 | E-01 (L259-306) | ○ |
| C-22 | キャッシュ有効期限チェック | E-01 (L179-181, L270-296) | ○ |
| C-23 | findShellでPATH検索 | E-02 (L16-49) | ○ |
| C-24 | WindowsでCmd.exe返却 | E-02 (L17-19) | ○ |
| C-25 | ハードコードパスフォールバック | E-02 (L33-47) | ○ |
| C-26 | シェル未発見でnull | E-02 (L48) | ○ |
| C-27 | yarn runをbun runに置換 | E-02 (L86-136) | ○ |
| C-28 | npm runをbun runに置換 | E-02 (L155-158) | ○ |
| C-29 | pnpm runをbun runに置換 | E-02 (L174-176) | ○ |
| C-30 | npxをbun xに置換 | E-02 (L162-167) | ○ |
| C-31 | pnpm dlxをbun xに置換 | E-02 (L180-185) | ○ |
| C-32 | pnpxをbun xに置換 | E-02 (L186-190) | ○ |
| C-33 | yarn暗黙的コマンド変換 | E-02 (L128-135) | ○ |
| C-34 | yarn npmコマンド非置換 | E-02 (L112-117) | ○ |
| C-35 | basenameOrBunでbun-nodeパス変換 | E-02 (L372-379) | ○ |
| C-36 | 通常パスのbasename | E-02 (L378) | ○ |
| C-37 | npm_config_user_agent設定 | E-02 (L827-833) | ○ |
| C-38 | npm_package_name設定 | E-02 (L843-846) | ○ |
| C-39 | npm_package_version設定 | E-02 (L851-855) | ○ |
| C-40 | node_modules/.binをPATH追加 | E-02 (L941-951) | ○ |
| C-41 | 一時nodeシンボリックリンク作成 | E-02 (L642-767) | ○ |
| C-42 | bunシンボリックリンク作成 | E-02 (L673, L733) | ○ |
| C-43 | package.json scripts実行 | E-02 (L1435-1495) | ○ |
| C-44 | stdin実行 | E-02 (L1397-1431) | ○ |
| C-45 | .で始まるパス直接実行 | E-02 (L1352-1354) | ○ |
| C-46 | 絶対パス直接実行 | E-02 (L1355-1357) | ○ |
| C-47 | スクリプト未発見エラー | E-02 (L1606-1619) | ○ |
| C-48 | prompt関数のユーザー入力取得 | E-03 (L2-40) | ○ |
| C-49 | prompt空入力でデフォルト値 | E-03 (L34-38) | ○ |
| C-50 | radioラジオボタン選択 | E-03 (L44-178, L181-223) | ○ |
| C-51 | 数字キー直接選択 | E-03 (L130-135) | ○ |
| C-52 | Ctrl+CでEndOfStream | E-03 (L129) | ○ |
| C-53 | normalizePackageName大文字変換 | E-03 (L314-338) | ○ |
| C-54 | スペースをハイフンに変換 | E-03 (L331) | ○ |
| C-55 | 引用符をハイフンに変換 | E-03 (L331) | ○ |
| C-56 | 正規化不要時そのまま返却 | E-03 (L325-327) | ○ |
| C-57 | Assets.createで既知アセット作成 | E-03 (L234-284) | ○ |
| C-58 | Assets.createNewで新規ファイル作成 | E-03 (L244-252) | ○ |
| C-59 | 既存ファイルでEEXIST | E-03 (L245) | ○ |
| C-60 | Version.nameでbun-vプレフィックス除去 | E-04 (L15-36) | ○ |
| C-61 | canaryタグ特殊フォーマット | E-04 (L17-30) | ○ |
| C-62 | 不正タグそのまま返却 | E-04 (L32) | ○ |
| C-63 | isCurrent現バージョン一致 | E-04 (L70-72) | ○ |
| C-64 | isCurrent異なるバージョン | E-04 (L70-72) | ○ |
| C-65 | getLatestVersionでGitHub取得 | E-04 (L89-305) | ○ |
| C-66 | GITHUB_TOKEN使用 | E-04 (L131-148) | ○ |
| C-67 | 404でHTTP404エラー | E-04 (L174) | ○ |
| C-68 | 429でHTTPTooManyRequestsエラー | E-04 (L176) | ○ |
| C-69 | UpgradeCommand.execアップグレード実行 | E-04 (L318-893) | ○ |
| C-70 | --canaryでcanaryビルド | E-04 (L370, L412-417) | ○ |
| C-71 | --stableでstableビルド | E-04 (L366-367) | ○ |
| C-72 | パッケージ名指定でエラー | E-04 (L322-335) | ○ |
| C-73 | BuildCommand.execバンドル実行 | E-05 (L1-598) | ○ |
| C-74 | --compileでスタンドアロン | E-05 (L6, L100-140) | ○ |
| C-75 | --minifyで圧縮有効 | E-05 (L75-77) | ○ |
| C-76 | --sourcemapでソースマップ生成 | E-05 (L52-60) | ○ |
| C-77 | --compileと--outdirの競合エラー | E-05 (L101-105) | ○ |
| C-78 | 複数エントリーポイントで--outdirなしエラー | E-05 (L153-158) | ○ |
| C-79 | bunfig.toml読み込み | E-06 (L264-289) | ○ |
| C-80 | --configで指定パス使用 | E-06 (L248-262) | ○ |
| C-81 | グローバル設定読み込み | E-06 (L237-246, L291-303) | ○ |
| C-82 | 自動読み込み無効でスキップ | E-06 (L304-313) | ○ |
| C-83 | --cwdでcwd変更 | E-06 (L437-449) | ○ |
| C-84 | --helpでヘルプ表示 | E-06 (L413-418) | ○ |
| C-85 | --filterでワークスペースフィルタ設定 | E-06 (L452) | ○ |
| C-86 | --workspacesで全ワークスペース対象 | E-06 (L453) | ○ |
| C-87 | --timeoutでテストタイムアウト設定 | E-06 (L467-475) | ○ |
| C-88 | 不正タイムアウト値でエラー | E-06 (L469-473) | ○ |
| C-89 | loader_resolver有効ローダー解決 | E-06 (L1-4) | ○ |
| C-90 | loader_resolver無効ローダーでエラー | E-06 (L2) | ○ |
| C-91 | resolve_jsx_runtime automatic解決 | E-06 (L29-31) | ○ |
| C-92 | resolve_jsx_runtime classic解決 | E-06 (L31-33) | ○ |
| C-93 | resolve_jsx_runtime solid解決 | E-06 (L33-35) | ○ |
| C-94 | resolve_jsx_runtime無効でエラー | E-06 (L36-37) | ○ |
| C-95 | Template.dependencies blank | E-03 (L958-960, L879-885) | ○ |
| C-96 | Template.dependencies react_blank | E-03 (L961, L886-895) | ○ |
| C-97 | Template.isReact Reactテンプレート判定 | E-03 (L934-939) | ○ |
| C-98 | Template.isReact 非Reactテンプレート判定 | E-03 (L934-939) | ○ |
| C-99 | Template.createAgentRule Claude Code環境 | E-03 (L1000-1062) | △ |
| C-100 | Template.createAgentRule Cursor環境 | E-03 (L1064-1103) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-99, C-100**: Template.createAgentRuleの環境検出ロジック
  - 候補：実際のClaude Code / Cursorがインストールされた環境でのテスト

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: C-65-68のネットワーク依存テストは、モック化またはインテグレーションテストとして分離が必要
- **1 (中リスク)**: C-99, C-100の環境依存テストは、環境変数によるモック化が推奨される
- **0 (低リスク)**: その他のテストケースはユニットテストとして実装可能

## 6) レビュアーチェックリスト（最小）
- [ ] UT-CLI-001〜010: BunxCommand.Options.parseのオプションパース網羅性確認
- [ ] UT-CLI-011〜016: addCreatePrefixのスコープ付きパッケージ変換ロジック確認
- [ ] UT-CLI-023〜026: findShellのクロスプラットフォーム動作確認
- [ ] UT-CLI-027〜034: replacePackageManagerRunの置換パターン網羅性確認
- [ ] UT-CLI-065〜072: UpgradeCommandのネットワーク依存テストのモック戦略確認
- [ ] UT-CLI-073〜078: BuildCommandのオプション競合チェック確認
- [ ] UT-CLI-079〜088: Arguments設定読み込みのエッジケース確認
