---
generated_at: 2026-01-31 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 105
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：devtools 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：105 / 110、根拠なし：5
- 優先レビュー（高）
  1. **UT-DVT-056, 057**: macOS固有のMach-O関連APIの動作確認が必要
  2. **UT-DVT-088**: オーバーフロー時のラップ動作の詳細確認が必要
  3. **UT-DVT-063**: デバッガスレッド起動の内部実装詳細

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/bun-main/src/crash_handler.zig` (2282行)
- E-02: `/Users/tomoka.baba/Work/bun-main/src/bun.js/Debugger.zig` (536行)
- E-03: `/Users/tomoka.baba/Work/bun-main/src/bun.js/api/server/InspectorBunFrontendDevServerAgent.zig` (118行)
- E-04: `/Users/tomoka.baba/Work/bun-main/src/bun.js/bindings/HTTPServerAgent.zig` (180行)
- E-05: `/Users/tomoka.baba/Work/bun-main/docs/code-to-docs/単体テストケース一覧/plan.md` (モジュール定義)

## 3) Claims と根拠の対応（レビューの主戦場）

### crash_handler (クラッシュハンドラ) - 57件

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | crashHandlerがパニック時に正しく動作する | E-01 L198-517 | ○ |
| C-02 | セグメンテーションフォルトのアドレス記録 | E-01 L73, L839 | ○ |
| C-03 | 不正命令例外のアドレス記録 | E-01 L74, L840 | ○ |
| C-04 | バスエラーのアドレス記録（POSIX） | E-01 L77, L841 | ○ |
| C-05 | 浮動小数点エラーのアドレス記録（POSIX） | E-01 L79, L842 | ○ |
| C-06 | データ型不整合（Windows） | E-01 L80, L927 | ○ |
| C-07 | スタックオーバーフロー（Windows） | E-01 L83, L930 | ○ |
| C-08 | Zigエラーのエラー名記録 | E-01 L86, L100 | ○ |
| C-09 | メモリ不足メッセージ | E-01 L88, L101 | ○ |
| C-10 | CrashReason.formatのパニックメッセージ | E-01 L90-92 | ○ |
| C-11 | CrashReason.formatのunreachable | E-01 L93 | ○ |
| C-12 | CrashReason.formatのアドレスフォーマット | E-01 L94-97 | ○ |
| C-13 | Action.formatのparse操作 | E-01 L132 | ○ |
| C-14 | Action.formatのvisit操作 | E-01 L133 | ○ |
| C-15 | Action.formatのprint操作 | E-01 L134 | ○ |
| C-16 | Action.formatのdlopen操作 | E-01 L161 | ○ |
| C-17 | handleRootErrorのOutOfMemory | E-01 L525 | ○ |
| C-18 | handleRootErrorのInvalidArgument | E-01 L527-530 | ○ |
| C-19 | handleRootErrorのSyntaxError | E-01 L532-534 | ○ |
| C-20 | handleRootErrorのSystemFdQuotaExceeded | E-01 L543-604 | ○ |
| C-21 | handleRootErrorのProcessFdQuotaExceeded | E-01 L607-674 | ○ |
| C-22 | handleRootErrorのMissingPackageJSON | E-01 L752-758 | ○ |
| C-23 | initのWindows初期化 | E-01 L889-893 | ○ |
| C-24 | initのPOSIX初期化 | E-01 L889, L895-896 | ○ |
| C-25 | resetSegfaultHandler | E-01 L902-922 | ○ |
| C-26 | reportBaseUrlのデフォルト | E-01 L798-812, L26 | ○ |
| C-27 | reportBaseUrlの環境変数 | E-01 L804-806 | ○ |
| C-28 | printMetadataのバージョン | E-01 L950, L963 | ○ |
| C-29 | printMetadataのプラットフォーム | E-01 L965-982 | ○ |
| C-30 | printMetadataのCPU情報 | E-01 L984-990 | ○ |
| C-31 | StackLine.fromAddressのWindows | E-01 L1133-1157 | ○ |
| C-32 | StackLine.fromAddressのmacOS | E-01 L1159-1220 | ○ |
| C-33 | StackLine.fromAddressのLinux | E-01 L1222-1261 | ○ |
| C-34 | StackLine.fromAddressの無効アドレス | E-01 L1131 | ○ |
| C-35 | StackLine.writeEncodedの有効値 | E-01 L1264-1277 | ○ |
| C-36 | StackLine.writeEncodedのオブジェクト名付き | E-01 L1270-1273 | ○ |
| C-37 | StackLine.writeEncodedのnull | E-01 L1265-1267 | ○ |
| C-38 | TraceString.format | E-01 L1296-1311 | ○ |
| C-39 | StoredTrace.capture | E-01 L1815-1827 | ○ |
| C-40 | StoredTrace.fromの有効値 | E-01 L1829-1842 | ○ |
| C-41 | StoredTrace.fromのnull | E-01 L1830, L1840-1841 | ○ |
| C-42 | StoredTrace.trace | E-01 L1808-1813 | ○ |
| C-43 | appendPreCrashHandler | E-01 L1942-1954 | ○ |
| C-44 | removePreCrashHandlerの登録済み | E-01 L1956-1963 | ○ |
| C-45 | removePreCrashHandlerの未登録 | E-01 L1959-1961 | ○ |
| C-46 | isPanickingのfalse | E-01 L1965-1967 | ○ |
| C-47 | isPanickingのtrue | E-01 L1965-1967 | ○ |
| C-48 | suppressReporting | E-01 L1791-1794 | ○ |
| C-49 | dumpStackTrace | E-01 L1652-1717 | ○ |
| C-50 | dumpCurrentStackTrace | E-01 L1766-1771 | ○ |
| C-51 | js_bindings.jsSegfault | E-01 L1877-1884 | ○ |
| C-52 | js_bindings.jsPanic | E-01 L1886-1889 | ○ |
| C-53 | js_bindings.jsOutOfMemory | E-01 L1895-1898 | ○ |
| C-54 | js_bindings.jsGetFeaturesAsVLQ | E-01 L1905-1914 | ○ |
| C-55 | js_bindings.jsGetFeatureData | E-01 L1916-1933 | ○ |
| C-56 | js_bindings.jsGetMachOImageZeroOffsetのmacOS | E-01 L1867-1875 | △ |
| C-57 | js_bindings.jsGetMachOImageZeroOffsetの非macOS | E-01 L1868 | △ |

### Debugger (デバッガ) - 29件

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | waitForDebuggerIfNecessaryの待機動作 | E-02 L31-115 | ○ |
| C-59 | waitForDebuggerIfNecessaryの早期リターン（不要時） | E-02 L34-36 | ○ |
| C-60 | waitForDebuggerIfNecessaryの早期リターン（未設定） | E-02 L32 | ○ |
| C-61 | createのデバッガ作成 | E-02 L118-141 | ○ |
| C-62 | createの重複防止 | E-02 L121 | ○ |
| C-63 | startJSDebuggerThread | E-02 L143-171 | △ |
| C-64 | Debugger__didConnect | E-02 L173-180 | ○ |
| C-65 | startの環境変数設定 | E-02 L189-195 | ○ |
| C-66 | startのpath_or_port設定 | E-02 L197-203 | ○ |
| C-67 | AsyncTaskTracker.init | E-02 L236-238 | ○ |
| C-68 | AsyncTaskTracker.didScheduleの通知 | E-02 L240-244 | ○ |
| C-69 | AsyncTaskTracker.didScheduleのid=0 | E-02 L241 | ○ |
| C-70 | AsyncTaskTracker.didCancel | E-02 L246-250 | ○ |
| C-71 | AsyncTaskTracker.willDispatch | E-02 L252-258 | ○ |
| C-72 | AsyncTaskTracker.didDispatch | E-02 L260-266 | ○ |
| C-73 | TestReporterAgent.Enable | E-02 L339-347 | ○ |
| C-74 | TestReporterAgent.Disable | E-02 L425-430 | ○ |
| C-75 | TestReporterAgent.reportTestFound | E-02 L435-439 | ○ |
| C-76 | TestReporterAgent.reportTestStart | E-02 L442-445 | ○ |
| C-77 | TestReporterAgent.reportTestEnd | E-02 L448-451 | ○ |
| C-78 | TestReporterAgent.isEnabledのtrue | E-02 L453-455 | ○ |
| C-79 | TestReporterAgent.isEnabledのfalse | E-02 L453-455 | ○ |
| C-80 | retroactivelyReportDiscoveredTests | E-02 L351-374 | ○ |
| C-81 | LifecycleAgent.Enable | E-02 L487-492 | ○ |
| C-82 | LifecycleAgent.Disable | E-02 L494-500 | ○ |
| C-83 | LifecycleAgent.reportReloadの通知 | E-02 L502-506 | ○ |
| C-84 | LifecycleAgent.reportReloadの早期リターン | E-02 L503 | ○ |
| C-85 | LifecycleAgent.reportError | E-02 L508-512 | ○ |
| C-86 | LifecycleAgent.isEnabled | E-02 L514-516 | ○ |

### BunFrontendDevServerAgent - 15件

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | nextConnectionIDのインクリメント | E-03 L28-32 | ○ |
| C-88 | nextConnectionIDのオーバーフロー | E-03 L30 (+%=演算子) | △ |
| C-89 | isEnabled | E-03 L34-36 | ○ |
| C-90 | notifyClientConnectedの通知 | E-03 L38-42 | ○ |
| C-91 | notifyClientConnectedの早期リターン | E-03 L39 | ○ |
| C-92 | notifyClientDisconnected | E-03 L44-48 | ○ |
| C-93 | notifyBundleStart | E-03 L50-54 | ○ |
| C-94 | notifyBundleComplete | E-03 L56-60 | ○ |
| C-95 | notifyBundleFailed | E-03 L62-66 | ○ |
| C-96 | notifyClientNavigated | E-03 L68-84 | ○ |
| C-97 | notifyClientNavigatedのrouteBundleId=null | E-03 L80 | ○ |
| C-98 | notifyClientErrorReported | E-03 L85-93 | ○ |
| C-99 | notifyGraphUpdate | E-03 L95-99 | ○ |
| C-100 | notifyConsoleLog | E-03 L101-105 | ○ |
| C-101 | Bun__InspectorBunFrontendDevServerAgent__setEnabled | E-03 L107-111 | ○ |

### HTTPServerAgent - 9件

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | isEnabled | E-04 L9-11 | ○ |
| C-103 | notifyServerStartedの通知 | E-04 L14-29 | ○ |
| C-104 | notifyServerStartedの早期リターン | E-04 L15 | ○ |
| C-105 | notifyServerStopped | E-04 L31-35 | ○ |
| C-106 | notifyServerRoutesUpdated | E-04 L37-92 | ○ |
| C-107 | Route.paramsの有効値 | E-04 L116-119 | ○ |
| C-108 | Route.paramsのnull | E-04 L117 | ○ |
| C-109 | Route.deinit | E-04 L121-130 | ○ |
| C-110 | Bun__HTTPServerAgent__setEnabled | E-04 L160-164 | ○ |

## 4) 不足情報（Unknown / Missing）

以下の項目は根拠が不十分または確認が困難です：

1. **UT-DVT-056, 057 (jsGetMachOImageZeroOffset)**: macOS固有のDyld APIの動作をテストするには実際のmacOS環境が必要
   - 候補: macOS環境での統合テスト / E2Eテスト

2. **UT-DVT-063 (startJSDebuggerThread)**: スレッド生成とVM初期化の複雑な相互作用
   - 候補: マルチスレッドテストフレームワーク / 統合テスト

3. **UT-DVT-088 (nextConnectionIDオーバーフロー)**: +%=演算子によるラップ動作の仕様確認
   - 候補: Zig言語仕様書 / オーバーフローテスト

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 理由 |
|---|---|---|
| 2 (高) | crashHandler全般 | プロセス終了を伴うため、テスト実行環境に影響 |
| 2 (高) | シグナルハンドラ (POSIX) | OSレベルの動作、環境依存 |
| 2 (高) | VectoredExceptionHandler (Windows) | OSレベルの動作、環境依存 |
| 1 (中) | デバッガスレッド起動 | マルチスレッド動作の確認が複雑 |
| 1 (中) | TestReporterAgent遡及報告 | タイミング依存の動作 |
| 0 (低) | フォーマッタ関数 | 純粋関数、副作用なし |

## 6) レビュアーチェックリスト（最小）

- [ ] crash_handlerのテストケースがプロセス終了を前提としていることを確認
- [ ] プラットフォーム固有（Windows/macOS/Linux）のテストケースが適切に分類されているか
- [ ] デバッガ機能のテストケースがVirtualMachine依存を考慮しているか
- [ ] エージェント（TestReporter, Lifecycle, FrontendDevServer, HTTPServer）の有効/無効状態の境界値が網羅されているか
- [ ] js_bindings APIのテストケースがJavaScriptCore統合を考慮しているか
- [ ] StoredTraceとStackLineのエンコード/デコードの往復テストが考慮されているか
