---
generated_at: 2026-01-31 10:30:00
metrics:
  claims_total: 142
  claims_with_evidence: 138
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：framework.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：138 / 142、根拠なし：4
- 優先レビュー（高）
  1. **UT-FRM-094 (invalidate)**: 実装が未完了（TODO）のため、テスト観点の妥当性要確認
  2. **UT-FRM-142 (configureSourceMapGCSize)**: クライアント側の内部実装、詳細な仕様根拠が不明確
  3. **UT-FRM-141 (clearDisconnectedSourceMaps)**: クライアント側の内部実装、詳細な仕様根拠が不明確
  4. **UT-FRM-137 (initWebSocket再接続)**: 再接続ロジックの詳細仕様が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bake/FrameworkRouter.zig` - ルーティング機能の主要実装
- E-02: `src/bake/DevServer.zig` - 開発サーバーの主要実装
- E-03: `src/bake/DevServer/HmrSocket.zig` - HMR WebSocket処理
- E-04: `src/bake/DevServer/IncrementalGraph.zig` - インクリメンタルビルドグラフ
- E-05: `src/bake/production.zig` - プロダクションビルド機能
- E-06: `src/bake/hmr-module.ts` - HMRモジュールローダー（クライアント/サーバー共通）
- E-07: `src/bake/hmr-runtime-client.ts` - クライアントサイドHMRランタイム
- E-08: `src/bake/client/css-reloader.ts` - CSS HMR処理
- E-09: `src/bake/client/websocket.ts` - WebSocket接続管理
- E-10: `src/bake/client/overlay.ts` - エラーオーバーレイ
- E-11: `src/bake/client/stack-trace.ts` - ソースマップ処理
- E-12: `src/bake/client/data-view.ts` - バイナリデータ読み取り

## 3) Claims と根拠の対応（レビューの主戦場）

### FrameworkRouter関連 (UT-FRM-001 - UT-FRM-042)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initEmptyで空ルーターが初期化される | E-01 (L123-153) | ○ |
| C-02 | 相対パスでアサート失敗 | E-01 (L124) | ○ |
| C-03 | deinitでメモリ解放 | E-01 (L155-161) | ○ |
| C-04 | memoryCostが正しく計算される | E-01 (L163-169) | ○ |
| C-05 | scanAllで全タイプスキャン | E-01 (L171-176) | ○ |
| C-06 | 静的ルート挿入 | E-01 (L708-812) | ○ |
| C-07 | 動的ルート挿入 | E-01 (L708-812) | ○ |
| C-08 | 重複でRouteCollisionエラー | E-01 (L783-789) | ○ |
| C-09 | 静的ルートマッチング | E-01 (L851-866) | ○ |
| C-10 | パラメータ抽出 | E-01 (L275-332) | ○ |
| C-11 | catch-allマッチ | E-01 (L304-326) | ○ |
| C-12 | 未登録でnull | E-01 (L851-866) | ○ |
| C-13 | routePtrでポインタ取得 | E-01 (L868-870) | ○ |
| C-14 | typePtrでポインタ取得 | E-01 (L872-874) | ○ |
| C-15 | EncodedPattern初期化 | E-01 (L196-204) | ○ |
| C-16 | イテレート | E-01 (L206-250) | ○ |
| C-17 | パターンマッチ成功 | E-01 (L275-332) | ○ |
| C-18 | パターンマッチ失敗 | E-01 (L275-332) | ○ |
| C-19 | 同等URLで同ハッシュ | E-01 (L252-273) | ○ |
| C-20 | MatchedParams.toJS | E-01 (L827-845) | ○ |
| C-21 | 空パラメータでnull | E-01 (L830-831) | ○ |
| C-22 | 64パラメータ上限 | E-01 (L816) | ○ |
| C-23 | 65パラメータでパニック | E-01 (L292-295, L312-315) | ○ |
| C-24 | Style.fromJS nextjs-pages | E-01 (L465-486) | ○ |
| C-25 | Style.fromJS nextjs-app-ui | E-01 (L465-486) | ○ |
| C-26 | カスタム関数でjavascript_defined | E-01 (L481-482) | ○ |
| C-27 | 不正スタイルでエラー | E-01 (L485) | ○ |
| C-28 | parseNextJsPages index | E-01 (L513-533) | ○ |
| C-29 | parseNextJsPages [id] | E-01 (L585-686) | ○ |
| C-30 | parseNextJsPages [...slug] | E-01 (L614-615) | ○ |
| C-31 | parseNextJsPages [[...slug]] | E-01 (L605-630) | ○ |
| C-32 | parseNextJsPages _layout | E-01 (L520-523) | ○ |
| C-33 | parseNextJsApp page | E-01 (L537-583) | ○ |
| C-34 | parseNextJsApp layout | E-01 (L571) | ○ |
| C-35 | parseNextJsApp (group) | E-01 (L653-670) | ○ |
| C-36 | parseNextJsApp @slot エラー | E-01 (L673-677) | ○ |
| C-37 | parseNextJsApp route | E-01 (L565-568) | ○ |
| C-38 | TinyLog.fail | E-01 (L904-908) | ○ |
| C-39 | TinyLog.print | E-01 (L919-946) | ○ |
| C-40 | Part.eql 等価 | E-01 (L415-424) | ○ |
| C-41 | Part.eql 非等価 | E-01 (L416-417) | ○ |
| C-42 | Part.writeAsSerialized | E-01 (L397-413) | ○ |

### DevServer関連 (UT-FRM-043 - UT-FRM-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | DevServer.init | E-02 (L287-) | ○ |
| C-44 | DevServer.deinit | E-02 (deinit関数) | ○ |
| C-45 | Options.arena | E-02 (L17-29) | ○ |
| C-46 | graph_safety_lock | E-02 (L67) | ○ |
| C-47 | client_graph | E-02 (L68) | ○ |
| C-48 | server_graph | E-02 (L69) | ○ |
| C-49 | route_bundles | E-02 (L63) | ○ |
| C-50 | bundling_failures | E-02 (L88-93) | ○ |
| C-51 | configuration_hash_key | E-02 (L52-53) | ○ |
| C-52 | frontend_only | E-02 (L96-97) | ○ |
| C-53 | HmrSocket.new | E-03 (L14-28) | ○ |
| C-54 | HmrSocket.onOpen | E-03 (L30-41) | ○ |
| C-55 | HmrSocket.onMessage init | E-03 (L50-60) | ○ |
| C-56 | HmrSocket.onMessage subscribe | E-03 (L61-106) | ○ |
| C-57 | HmrSocket.onMessage set_url | E-03 (L107-133) | ○ |
| C-58 | HmrSocket.onMessage console_log | E-03 (L172-206) | ○ |
| C-59 | HmrSocket.onClose | E-03 (L237-262) | ○ |
| C-60 | is_from_localhost IPv4 | E-03 (L17-20) | ○ |
| C-61 | is_from_localhost IPv6 | E-03 (L18-19) | ○ |
| C-62 | ServerFile is_rsc | E-04 (L7-9) | ○ |
| C-63 | ServerFile is_ssr | E-04 (L10-11) | ○ |
| C-64 | is_client_component_boundary | E-04 (L12-14) | ○ |
| C-65 | ClientFile content.js | E-04 (L73-76) | ○ |
| C-66 | ClientFile content.css_root | E-04 (L53-63) | ○ |
| C-67 | ClientFile.Packed pack/unpack | E-04 (L86-143) | ○ |
| C-68 | Content enum | E-04 (L46-70) | ○ |

### Production関連 (UT-FRM-069 - UT-FRM-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | buildCommand実行 | E-05 (L4-110) | ○ |
| C-70 | 複数エントリポイントでエラー | E-05 (L7-10) | ○ |
| C-71 | --watchフラグでエラー | E-05 (L12-15) | ○ |
| C-72 | buildWithVm | E-05 (L139-713) | ○ |
| C-73 | writeSourcemapToDisk | E-05 (L112-137) | ○ |
| C-74 | BakeProdResolve | E-05 (L809-838) | ○ |
| C-75 | 非相対インポートでエラー | E-05 (L823-827) | ○ |
| C-76 | BakeProdLoad | E-05 (L1022-1033) | ○ |
| C-77 | 未登録でdead返却 | E-05 (L1032) | ○ |
| C-78 | BakeProdSourceMap | E-05 (L1035-1044) | ○ |
| C-79 | EntryPointMap登録 | E-05 (L884-896) | ○ |
| C-80 | 重複エントリ再利用 | E-05 (L886-887) | ○ |
| C-81 | PerThread初期化 | E-05 (L950-968) | ○ |
| C-82 | PerThread.attach | E-05 (L970-972) | ○ |
| C-83 | PerThread.loadBundledModule | E-05 (L992-998) | ○ |
| C-84 | PerThread.preloadBundledModule | E-05 (L1007-1018) | ○ |

### HMRModule関連 (UT-FRM-085 - UT-FRM-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | HMRModule ESM初期化 | E-06 (L106-116) | ○ |
| C-86 | HMRModule CJS初期化 | E-06 (L106-116) | ○ |
| C-87 | require同期ロード | E-06 (L123-133) | ○ |
| C-88 | 非同期モジュールでAsyncImportError | E-06 (L128-131) | ○ |
| C-89 | dynamicImport | E-06 (L136-145) | ○ |
| C-90 | accept設定 | E-06 (L172-191) | ○ |
| C-91 | 暗黙accept | E-06 (L177-179) | ○ |
| C-92 | acceptSpecifiers | E-06 (L194-209) | ○ |
| C-93 | dispose登録 | E-06 (L213-215) | ○ |
| C-94 | invalidate TODO | E-06 (L222-226) | △ |
| C-95 | on登録 | E-06 (L228-235) | ○ |
| C-96 | off解除 | E-06 (L237-244) | ○ |
| C-97 | reactRefreshAccept | E-06 (L147-151) | ○ |
| C-98 | loadModuleSync | E-06 (L273-358) | ○ |
| C-99 | 既存モジュール再利用 | E-06 (L275-286) | ○ |
| C-100 | 未登録エラー | E-06 (L289, L830-842) | ○ |
| C-101 | loadModuleAsync | E-06 (L365-470) | ○ |
| C-102 | Stale再ロード | E-06 (L375-378) | ○ |
| C-103 | replaceModules | E-06 (L605-796) | ○ |
| C-104 | self-acceptリロード | E-06 (L643-661) | ○ |
| C-105 | dispose実行 | E-06 (L733-749) | ○ |
| C-106 | 依存accept | E-06 (L785-789) | ○ |
| C-107 | acceptなしでfullReload | E-06 (L683-731) | ○ |
| C-108 | emitEvent | E-06 (L818-824) | ○ |
| C-109 | fullReload | E-06 (L844-849) | ○ |
| C-110 | beforeFullReloadイベント | E-06 (L845-847) | ○ |
| C-111 | performRouteReload | E-07 (L37-63) | ○ |
| C-112 | 重複リロード抑制 | E-07 (L39-42) | ○ |
| C-113 | リロード失敗フォールバック | E-07 (L53-62) | ○ |
| C-114 | handlers.version正常 | E-07 (L91-117) | ○ |
| C-115 | バージョン不一致リロード | E-07 (L92-96) | ○ |
| C-116 | CSS更新処理 | E-07 (L138-145) | ○ |
| C-117 | JS更新スクリプトタグ | E-07 (L179-195) | ○ |
| C-118 | サーバーサイド更新 | E-07 (L174-177) | ○ |
| C-119 | toCommonJS | E-06 (L861-874) | ○ |
| C-120 | toESM | E-06 (L876-885) | ○ |
| C-121 | isReactRefreshBoundary判定 | E-06 (L909-934) | ○ |
| C-122 | 非コンポーネント判定 | E-06 (L915-932) | ○ |
| C-123 | setRefreshRuntime | E-06 (L894-905) | ○ |
| C-124 | registerSynthetic | E-06 (L887-892) | ○ |

### JSFrameworkRouter関連 (UT-FRM-125 - UT-FRM-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | JSFrameworkRouter constructor | E-01 (L1174-1231) | ○ |
| C-126 | JSFrameworkRouter match | E-01 (L1234-1259) | ○ |
| C-127 | JSFrameworkRouter toJSON | E-01 (L1261-1268) | ○ |
| C-128 | parseRoutePattern | E-01 (L1316-1347) | ○ |
| C-129 | finalize | E-01 (L1308-1314) | ○ |

### クライアントサイドユーティリティ (UT-FRM-130 - UT-FRM-142)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | DataViewReader constructor | E-12 | ○ |
| C-131 | DataViewReader i32 | E-12 | ○ |
| C-132 | DataViewReader string32 | E-12 | ○ |
| C-133 | DataViewReader hasMoreData | E-12 | ○ |
| C-134 | editCssArray | E-08 | ○ |
| C-135 | editCssContent | E-08 | ○ |
| C-136 | initWebSocket | E-09 | ○ |
| C-137 | initWebSocket再接続 | E-09 | △ |
| C-138 | onServerErrorPayload | E-10 | ○ |
| C-139 | onRuntimeError | E-10 | ○ |
| C-140 | addMapping | E-11 | ○ |
| C-141 | clearDisconnectedSourceMaps | E-11 | △ |
| C-142 | configureSourceMapGCSize | E-11 | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-FRM-094 (invalidate)**: 実装が`throw new Error("TODO: implement ImportMetaHot.invalidate")`となっており、実際の動作が未定義
  - 候補：Vite互換性ドキュメント / HMR仕様書 / 今後の実装予定
- **UT-FRM-137 (initWebSocket再接続)**: websocket.tsの再接続ロジックの詳細仕様が明確でない
  - 候補：websocket.ts内部実装の詳細確認
- **UT-FRM-141, UT-FRM-142 (SourceMap GC関連)**: stack-trace.tsの内部実装詳細
  - 候補：stack-trace.ts / テスト用APIの仕様

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UT-FRM-001 - UT-FRM-042 (FrameworkRouter) - Zig実装が明確
- **0（低リスク）**: UT-FRM-043 - UT-FRM-068 (DevServer) - サーバーサイド実装が明確
- **0（低リスク）**: UT-FRM-069 - UT-FRM-084 (Production) - ビルド機能が明確
- **1（中リスク）**: UT-FRM-085 - UT-FRM-124 (HMRModule) - クライアント/サーバー共通ロジックで複雑
- **1（中リスク）**: UT-FRM-125 - UT-FRM-129 (JSFrameworkRouter) - JS APIラッパー
- **2（高リスク）**: UT-FRM-094 (invalidate) - 未実装機能

## 6) レビュアーチェックリスト（最小）
- [ ] FrameworkRouter (UT-FRM-001 - UT-FRM-042): ルートパターン解析とマッチングロジックが正しいか
- [ ] DevServer (UT-FRM-043 - UT-FRM-068): HMR WebSocket処理とグラフ管理が正しいか
- [ ] Production (UT-FRM-069 - UT-FRM-084): プロダクションビルドフローが正しいか
- [ ] HMRModule (UT-FRM-085 - UT-FRM-124): モジュールロード・更新ロジックが正しいか
- [ ] 境界値テスト (UT-FRM-021 - UT-FRM-023): パラメータ上限テストが適切か
- [ ] 異常系テスト: エラーハンドリングが網羅されているか
- [ ] UT-FRM-094 (invalidate): TODO実装後にテストケース更新が必要
