---
generated_at: 2026-01-31 12:00:00
metrics:
  claims_total: 165
  claims_with_evidence: 165
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：internal.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：165 / 165、根拠なし：0
- 優先レビュー（高）
  1. **validators系テストケース（UT-INT-006〜025）**：C++実装部分との整合性確認が必要
  2. **primordials系テストケース（UT-INT-143〜147）**：セキュリティ関連のためレビュー推奨
  3. **ProxyConfig系テストケース（UT-INT-159〜165）**：ネットワーク設定の重要機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/bun-main/src/js/internal/errors.ts`
- E-02: `/Users/tomoka.baba/Work/bun-main/src/js/internal/validators.ts`
- E-03: `/Users/tomoka.baba/Work/bun-main/src/js/internal/promisify.ts`
- E-04: `/Users/tomoka.baba/Work/bun-main/src/js/internal/fixed_queue.ts`
- E-05: `/Users/tomoka.baba/Work/bun-main/src/js/internal/linkedlist.ts`
- E-06: `/Users/tomoka.baba/Work/bun-main/src/js/internal/fifo.ts`
- E-07: `/Users/tomoka.baba/Work/bun-main/src/js/internal/timers.ts`
- E-08: `/Users/tomoka.baba/Work/bun-main/src/js/internal/freelist.ts`
- E-09: `/Users/tomoka.baba/Work/bun-main/src/js/internal/abort_listener.ts`
- E-10: `/Users/tomoka.baba/Work/bun-main/src/js/internal/shared.ts`
- E-11: `/Users/tomoka.baba/Work/bun-main/src/js/internal/url.ts`
- E-12: `/Users/tomoka.baba/Work/bun-main/src/js/internal/tls.ts`
- E-13: `/Users/tomoka.baba/Work/bun-main/src/js/internal/buffer.ts`
- E-14: `/Users/tomoka.baba/Work/bun-main/src/js/internal/net/isIP.ts`
- E-15: `/Users/tomoka.baba/Work/bun-main/src/js/internal/util/deprecate.ts`
- E-16: `/Users/tomoka.baba/Work/bun-main/src/js/internal/util/colors.ts`
- E-17: `/Users/tomoka.baba/Work/bun-main/src/js/internal/tty.ts`
- E-18: `/Users/tomoka.baba/Work/bun-main/src/js/internal/primordials.js`
- E-19: `/Users/tomoka.baba/Work/bun-main/src/js/internal/assert/assertion_error.ts`
- E-20: `/Users/tomoka.baba/Work/bun-main/src/js/internal/assert/utils.ts`
- E-21: `/Users/tomoka.baba/Work/bun-main/src/js/internal/cluster/Worker.ts`
- E-22: `/Users/tomoka.baba/Work/bun-main/src/js/internal/http.ts`
- E-23: `/Users/tomoka.baba/Work/bun-main/src/js/internal/streams/readable.ts`
- E-24: `/Users/tomoka.baba/Work/bun-main/src/js/internal/streams/writable.ts`
- E-25: `/Users/tomoka.baba/Work/bun-main/src/js/internal/streams/pipeline.ts`

## 3) Claims と根拠の対応（レビューの主戦場）

### errors.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | aggregateTwoErrorsが2つのエラーをAggregateErrorに結合する | E-01 L6-18 | ○ |
| C-002 | 既存のAggregateErrorにエラーを追加できる | E-01 L8-11 | ○ |
| C-003 | innerErrorがundefinedの場合outerErrorを返す | E-01 L17 | ○ |
| C-004 | outerErrorがundefinedの場合innerErrorを返す | E-01 L17 | ○ |
| C-005 | 同一オブジェクトの場合そのエラーを返す | E-01 L7 | ○ |

### validators.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-006 | validateStringが文字列を検証する | E-02 L68-70 | ○ |
| C-007 | validateStringが非文字列でエラーをスローする | E-02 L69 | ○ |
| C-008 | validateFunctionが関数を検証する | E-02 L72-74 | ○ |
| C-009 | validateBooleanがboolean値を検証する | E-02 L76-78 | ○ |
| C-010 | validateUndefinedがundefinedを検証する | E-02 L80-82 | ○ |
| C-011 | checkIsHttpTokenがRFC 7230準拠でHTTPトークンを検証する | E-02 L7-15 | ○ |
| C-012 | validateLinkHeaderValueがLink headerフォーマットを検証する | E-02 L36-66 | ○ |
| C-013 | validateInternalFieldがオブジェクトのフィールド存在を検証する | E-02 L84-88 | ○ |
| C-014 | isUint8ArrayがUint8Arrayインスタンスを判定する | E-02 L134 | ○ |

### promisify.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-015 | promisifyがコールバック関数をPromise化する | E-03 L23-77 | ○ |
| C-016 | kCustomPromisifiedSymbolを持つ関数はカスタム実装を使用する | E-03 L25-30 | ○ |
| C-017 | kCustomPromisifyArgsSymbolで複数引数をオブジェクトにまとめる | E-03 L43-57 | ○ |
| C-018 | defineCustomPromisifyがカスタムPromisifyを設定する | E-03 L6-13 | ○ |
| C-019 | defineCustomPromisifyArgsが引数名を設定する | E-03 L15-21 | ○ |

### fixed_queue.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-020 | FixedCircularBufferが循環バッファとして動作する | E-04 L55-89 | ○ |
| C-021 | isEmptyがtop === bottomで空を判定する | E-04 L68-70 | ○ |
| C-022 | isFullが((top + 1) & kMask) === bottomでフルを判定する | E-04 L72-74 | ○ |
| C-023 | FixedQueueがリンクリストでバッファを管理する | E-04 L91-122 | ○ |
| C-024 | バッファがフルになると新しいバッファが作成される | E-04 L104-108 | ○ |

### linkedlist.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-025 | initがリストを初期化する | E-05 L1-5 | ○ |
| C-026 | peekが最も古いアイテムを返す | E-05 L8-11 | ○ |
| C-027 | removeがアイテムをリストから削除する | E-05 L14-25 | ○ |
| C-028 | appendがリスト末尾にアイテムを追加する | E-05 L28-41 | ○ |
| C-029 | isEmptyが空判定を行う | E-05 L43-45 | ○ |

### fifo.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-030 | Dequeueが双方向キューとして動作する | E-06 L2-98 | ○ |
| C-031 | sizeが正しいサイズを計算する | E-06 L16-19 | ○ |
| C-032 | pushが容量超過時に自動拡張する | E-06 L49-51, L78-90 | ○ |
| C-033 | shiftが自動縮小を行う | E-06 L36, L92-95 | ○ |
| C-034 | toArrayが配列変換を行う | E-06 L54-70 | ○ |

### timers.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-035 | getTimerDurationがタイムアウト値を検証する | E-07 L7-23 | ○ |
| C-036 | TIMEOUT_MAXを超える値で警告を発行する | E-07 L14-19 | ○ |
| C-037 | 負の値やInfinityでエラーをスローする | E-07 L9-11 | ○ |

### freelist.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-038 | FreeListがオブジェクトプールを管理する | E-08 L1-27 | ○ |
| C-039 | allocがリストからオブジェクトを取得またはctorで作成する | E-08 L14-16 | ○ |
| C-040 | freeがmax未満ならリストに追加してtrueを返す | E-08 L18-24 | ○ |

### abort_listener.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-041 | addAbortListenerがAbortSignalにリスナーを登録する | E-09 L4-26 | ○ |
| C-042 | 既にabortedの場合はマイクロタスクでリスナーを呼ぶ | E-09 L12-13 | ○ |
| C-043 | Disposeでリスナーを解除できる | E-09 L21-25 | ○ |

### shared.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-044 | NotImplementedErrorが未実装機能のエラーを生成する | E-10 L5-23 | ○ |
| C-045 | throwNotImplementedがNotImplementedErrorをスローする | E-10 L25-30 | ○ |
| C-046 | hideFromStackが関数名を変更する | E-10 L32-38 | ○ |
| C-047 | warnNotImplementedOnceが一度だけ警告する | E-10 L40-51 | ○ |
| C-048 | ExceptionWithHostPortがホスト情報付きエラーを生成する | E-10 L54-87 | ○ |
| C-049 | NodeAggregateErrorがエラーを集約する | E-10 L89-97 | ○ |
| C-050 | ConnResetExceptionがECONNRESETエラーを生成する | E-10 L99-107 | ○ |
| C-051 | ErrnoExceptionがシステムエラーを生成する | E-10 L109-127 | ○ |
| C-052 | onceがコールバックを一度だけ実行するラッパーを返す | E-10 L129-139 | ○ |
| C-053 | getLazyが遅延初期化を行う | E-10 L143-152 | ○ |

### url.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-054 | urlToHttpOptionsがURLをHTTPオプションに変換する | E-11 L1-20 | ○ |
| C-055 | IPv6アドレスの括弧を除去する | E-11 L5-6 | ○ |
| C-056 | 認証情報をauthフィールドに設定する | E-11 L15-17 | ○ |

### tls.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-057 | isValidTLSItemがTLSアイテムを検証する | E-12 L12-18 | ○ |
| C-058 | isValidTLSArrayが配列を検証する | E-12 L36-49 | ○ |
| C-059 | throwOnInvalidTLSArrayが無効な値でエラーをスローする | E-12 L30-34 | ○ |

### buffer.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-060 | boundsErrorが境界エラーを生成する | E-13 L3-10 | ○ |
| C-061 | checkBoundsがバッファ境界を検証する | E-13 L12-16 | ○ |
| C-062 | checkIntが整数範囲を検証する | E-13 L18-34 | ○ |
| C-063 | writeU_Int8がuint8書き込みを検証する | E-13 L36-43 | ○ |

### net/isIP.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-064 | isIPv4がIPv4アドレスを判定する | E-14 L8-10 | ○ |
| C-065 | isIPv6がIPv6アドレスを判定する | E-14 L12-25 | ○ |
| C-066 | isIPがバージョン番号を返す | E-14 L27-31 | ○ |

### util/deprecate.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-067 | deprecateが非推奨ラッパーを返す | E-15 L22-41 | ○ |
| C-068 | 呼び出し時に警告が発行される | E-15 L28-31 | ○ |
| C-069 | 同じコードの警告は一度だけ発行される | E-15 L5-19 | ○ |

### util/colors.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-070 | shouldColorizeがカラー出力を判定する | E-16 L16-22 | ○ |
| C-071 | refreshがANSIエスケープコードを設定する | E-16 L23-45 | ○ |

### tty.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-072 | getColorDepthが環境に応じたカラー深度を返す | E-17 L56-172 | ○ |
| C-073 | FORCE_COLORが他の環境変数より優先される | E-17 L60-76 | ○ |

### primordials.js関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-074 | SafeArrayIteratorが安全なイテレータを提供する | E-18 L83 | ○ |
| C-075 | SafeMapがプロトタイプ汚染の影響を受けないMapを作成する | E-18 L129-136 | ○ |
| C-076 | SafeSetがプロトタイプ汚染の影響を受けないSetを作成する | E-18 L139-146 | ○ |
| C-077 | SafePromiseAllが安全なPromise.allを実行する | E-18 L98 | ○ |
| C-078 | uncurryThisがメソッドを関数化する | E-18 L34-37 | ○ |

### assert/assertion_error.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-079 | AssertionErrorがアサーションエラーを生成する | E-19 L243-424 | ○ |
| C-080 | strictEqualオペレータでdiff付きメッセージを生成する | E-19 L266-268 | ○ |
| C-081 | toStringがエラーコードを含む文字列を返す | E-19 L392-394 | ○ |

### cluster/Worker.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-082 | Workerがクラスターワーカーを管理する | E-21 L7-25 | ○ |
| C-083 | killがdestroyを呼び出す | E-21 L27-29 | ○ |
| C-084 | sendがprocess.sendを呼び出す | E-21 L31-33 | ○ |
| C-085 | isDeadがプロセス終了状態を返す | E-21 L35-37 | ○ |
| C-086 | isConnectedがプロセス接続状態を返す | E-21 L39-41 | ○ |

### http.ts関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-087 | validateMsecsがミリ秒を検証する | E-22 L196-202 | ○ |
| C-088 | ProxyConfigがプロキシ設定を管理する | E-22 L364-444 | ○ |
| C-089 | shouldUseProxyがプロキシ使用を判定する | E-22 L403-443 | ○ |
| C-090 | parseProxyConfigFromEnvが環境変数からプロキシ設定を解析する | E-22 L446-462 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべてのテストケースはソースコードに基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコード根拠あり
- 注意事項:
  - validators.tsのC++実装部分（$newCppFunction）は直接検証不可
  - primordials.jsのセキュリティ関連機能は重要度が高い
  - ProxyConfig関連はネットワーク設定に影響するため慎重なレビューが必要

## 6) レビュアーチェックリスト（最小）
- [ ] validators.tsのC++実装との整合性を確認
- [ ] primordials.jsのSafe*クラスがプロトタイプ汚染を防げることを確認
- [ ] ProxyConfigのバイパスリスト処理が正しいことを確認
- [ ] AssertionErrorのdiff表示が正しく動作することを確認
- [ ] タイムアウト関連のTIMEOUT_MAX境界値テストが適切であることを確認
