---
generated_at: 2026-01-31 10:30:00
metrics:
  claims_total: 150
  claims_with_evidence: 142
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：nodejs.csv（Node.js互換モジュール単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：142 / 150、根拠なし：8
- 優先レビュー（高）
  1. **node:crypto暗号化/復号化API**：Bun固有実装の詳細確認が必要
  2. **node:stream内部実装**：internal/streamへの委譲構造
  3. **node:net低レベルSocket API**：Zig実装との連携確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/js/node/fs.ts` - node:fsモジュール実装
- E-02: `src/js/node/path.ts` - node:pathモジュール実装
- E-03: `src/js/node/os.ts` - node:osモジュール実装
- E-04: `src/js/node/crypto.ts` - node:cryptoモジュール実装
- E-05: `src/js/node/http.ts` - node:httpモジュール実装
- E-06: `src/js/node/net.ts` - node:netモジュール実装
- E-07: `src/js/node/child_process.ts` - node:child_processモジュール実装
- E-08: `src/js/node/events.ts` - node:eventsモジュール実装
- E-09: `src/js/node/stream.ts` - node:streamモジュール実装
- E-10: `src/bun.js/node/` - Zig/C++によるNode.js互換実装
- E-11: `test/js/node/` - 既存テストコード
- E-12: Node.js公式APIドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-30 | node:fs API テストケース | E-01, E-10, E-11 | ○ |
| C-31〜C-45 | node:path API テストケース | E-02 | ○ |
| C-46〜C-60 | node:os API テストケース | E-03 | ○ |
| C-61〜C-75 | node:crypto API テストケース | E-04 | ○ |
| C-69〜C-70 | createCipheriv/createDecipheriv | E-04 | △ |
| C-76〜C-83 | node:http API テストケース | E-05 | ○ |
| C-84〜C-95 | node:net API テストケース | E-06 | ○ |
| C-96〜C-107 | node:child_process API テストケース | E-07 | ○ |
| C-108〜C-120 | node:events API テストケース | E-08 | ○ |
| C-121〜C-130 | node:stream API テストケース | E-09 | △ |
| C-131〜C-144 | node:buffer API テストケース | E-10, E-12 | ○ |
| C-145〜C-150 | node:url API テストケース | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- **node:stream内部実装詳細**：`src/js/node/stream.ts`は`internal/stream`への委譲のみで、実装詳細は`src/js/internal/`配下にある
  - 候補：`src/js/internal/streams/readable.ts` / `src/js/internal/streams/writable.ts` / `src/js/builtins/ReadableStream.ts`
- **暗号化API (Cipheriv/Decipheriv)**：Bun固有のWebCrypto連携実装があり、Node.js完全互換かは要確認
  - 候補：`src/bun.js/bindings/` / WebCrypto API実装
- **低レベルSocket実装**：Zig/C++レイヤーでの実装詳細
  - 候補：`src/bun.js/api/` / `src/io/`

## 5) リスクフラグ（レビュー観点）
- **リスクレベル1（中リスク）**：node:cryptoの暗号化/復号化API - BunはWebCryptoベースの実装のため、Node.jsとの完全互換性は実行時テストで確認が必要
- **リスクレベル1（中リスク）**：node:streamの内部実装 - 複雑な継承関係とinternal modulesへの依存
- **リスクレベル0（低リスク）**：その他のAPI - Node.js公式ドキュメントとソースコードから明確に導出可能

## 6) レビュアーチェックリスト（最小）
- [ ] node:fs APIがBunのファイルシステム実装と整合していることを確認
- [ ] node:path APIがプラットフォーム（darwin/linux/win32）差異を考慮していることを確認
- [ ] node:crypto暗号化APIがNode.js互換であることを実行テストで確認
- [ ] node:child_processのIPC機能がBun.spawn実装と整合していることを確認
- [ ] node:stream/Readable,Writableの正しい継承関係を確認
- [ ] node:netのSocket実装がZigレイヤーと正しく連携していることを確認
- [ ] 既存テスト（test/js/node/）との重複・整合性を確認

---

## 補足：テストケース生成根拠

### node:fs（UT-NOD-001〜030）
- `src/js/node/fs.ts` のexport文とメソッド定義から抽出
- 非同期/同期の両バリエーションを網羅
- エラーケース（ENOENT等）はNode.js標準エラーコードに準拠

### node:path（UT-NOD-031〜045）
- `src/js/node/path.ts` の関数定義から抽出
- POSIX/Windows両対応の考慮（実装はprocess.platformで分岐）

### node:os（UT-NOD-046〜060）
- `src/js/node/os.ts` のexport文から抽出
- プラットフォーム固有値（platform, arch等）はランタイム依存

### node:crypto（UT-NOD-061〜075）
- `src/js/node/crypto.ts` のexport文から抽出
- Hash, Hmac, Cipher, Sign等のクラスベースAPI

### node:http（UT-NOD-076〜083）
- `src/js/node/http.ts` のServer, request, get関数から抽出
- BunはHTTP処理にネイティブ実装を使用

### node:net（UT-NOD-084〜095）
- `src/js/node/net.ts` のServer, Socket, createConnection等から抽出
- TCP/IPC通信の基本機能

### node:child_process（UT-NOD-096〜107）
- `src/js/node/child_process.ts` から抽出
- spawn/exec/fork等のプロセス生成API
- Bun.spawnとの連携実装

### node:events（UT-NOD-108〜120）
- `src/js/node/events.ts` のEventEmitterクラスから抽出
- on/emit/once/removeListener等の標準イベントAPI

### node:stream（UT-NOD-121〜130）
- `src/js/node/stream.ts` およびinternal/streamから抽出
- Readable/Writable/Duplex/Transform等のストリームクラス

### node:buffer（UT-NOD-131〜144）
- グローバルBufferクラスのメソッドから抽出
- Node.js Buffer APIとの互換性

### node:url（UT-NOD-145〜150）
- WHATWG URL APIおよびNode.js legacy url APIから抽出
