---
generated_at: 2026-01-31 12:00:00
metrics:
  claims_total: 125
  claims_with_evidence: 118
  claims_without_evidence: 7
confidence_derived: 0.94
---

# 根拠レポート: test-runner.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.94**
  - 根拠あり: 118 / 125、根拠なし: 7
- 優先レビュー（高）
  1. **C-35 (Snapshots.getOrPut既存スナップショット取得)**: values HashMapの実装詳細の確認が必要
  2. **C-39 (Snapshots.writeInlineSnapshots)**: ファイル書き込みの詳細ロジックの確認が必要
  3. **C-51 (FakeTimers.errorUnlessFakeTimers)**: エラーメッセージの正確性確認が必要
  4. **C-109 (BunTestRoot.getActiveFileUnlessInPreload)**: preload判定ロジックの詳細確認
  5. **C-119-122 (formatLabel)**: プレースホルダー置換の網羅性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/bun.js/test/jest.zig` - TestRunner, Jest構造体の実装
- E-02: `src/bun.js/test/expect.zig` - Expect構造体とアサーション実装
- E-03: `src/bun.js/test/snapshot.zig` - Snapshots構造体の実装
- E-04: `src/bun.js/test/timers/FakeTimers.zig` - FakeTimers実装
- E-05: `src/bun.js/test/Collection.zig` - Collection構造体（テスト収集フェーズ）
- E-06: `src/bun.js/test/Execution.zig` - Execution構造体（テスト実行フェーズ）
- E-07: `src/bun.js/test/ScopeFunctions.zig` - ScopeFunctions（test/describe修飾子）
- E-08: `src/bun.js/test/bun_test.zig` - BunTest, BunTestRoot, DescribeScope等の中核構造体
- E-09: `src/bun.js/test/DoneCallback.zig` - DoneCallback実装（推定）
- E-10: `src/bun.js/test/Order.zig` - テスト順序管理（推定）

## 3) Claims と根拠の対応（レビューの主戦場）

### TestRunner関連 (C-01 - C-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | getOrPutFileで新規ファイルが登録されること | E-01 (jest.zig:153-162) | ○ |
| C-02 | getOrPutFileで既存ファイルが取得されること | E-01 (jest.zig:153-162) | ○ |
| C-03 | concurrent=trueでshouldFileRunConcurrentlyがtrueを返す | E-01 (jest.zig:134-136) | ○ |
| C-04 | globパターンマッチでtrueが返却される | E-01 (jest.zig:139-150) | ○ |
| C-05 | globパターン不一致でfalseが返却される | E-01 (jest.zig:139-150) | ○ |
| C-06 | filter_regex=nullでhasTestFilterがfalse | E-01 (jest.zig:130-132) | ○ |
| C-07 | filter_regex設定時にhasTestFilterがtrue | E-01 (jest.zig:130-132) | ○ |
| C-08 | didLabelFilterOutAllTestsの判定ロジック | E-01 (jest.zig:125-128) | ○ |

### Jest関連 (C-09 - C-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | createTestModuleでモジュールオブジェクト生成 | E-01 (jest.zig:181-211) | ○ |
| C-10 | 有効な絶対パスでモジュール取得 | E-01 (jest.zig:263-287) | ○ |
| C-11 | 相対パスでエラースロー | E-01 (jest.zig:281-283) | ○ |
| C-12 | jsSetDefaultTimeoutでタイムアウト設定 | E-01 (jest.zig:289-302) | ○ |
| C-13 | 数値以外の引数でエラースロー | E-01 (jest.zig:291-292) | ○ |

### Expect関連 (C-14 - C-32)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | expect(value)が動作する | E-02 (expect.zig:335-371) | ○ |
| C-15 | カスタムラベル付きexpect | E-02 (expect.zig:339-346) | ○ |
| C-16 | getNot修飾子トグル | E-02 (expect.zig:134-137) | ○ |
| C-17 | getResolves設定 | E-02 (expect.zig:139-148) | ○ |
| C-18 | rejects後resolves異常系 | E-02 (expect.zig:142-144) | ○ |
| C-19 | getRejects設定 | E-02 (expect.zig:150-159) | ○ |
| C-20 | resolves後rejects異常系 | E-02 (expect.zig:153-155) | ○ |
| C-21 | resolvesでPromise解決値返却 | E-02 (expect.zig:176-232) | ○ |
| C-22 | resolvesでreject時エラー | E-02 (expect.zig:189-196) | ○ |
| C-23 | rejectsでreject値返却 | E-02 (expect.zig:200-202) | ○ |
| C-24 | rejectsでfulfilled時エラー | E-02 (expect.zig:203-209) | ○ |
| C-25 | isAsymmetricMatcherでExpectAny認識 | E-02 (expect.zig:234-244) | ○ |
| C-26 | isAsymmetricMatcherで通常値false | E-02 (expect.zig:234-244) | ○ |
| C-27 | incrementExpectCallCounter | E-02 (expect.zig:33-47) | ○ |
| C-28 | getSnapshotName生成 | E-02 (expect.zig:278-325) | ○ |
| C-29 | _pass正常系 | E-02 (expect.zig:386-429) | ○ |
| C-30 | not.pass異常系 | E-02 (expect.zig:413-425) | ○ |
| C-31 | fail異常系 | E-02 (expect.zig:431-469) | ○ |
| C-32 | not.fail正常系 | E-02 (expect.zig:458-462) | ○ |

### Snapshots関連 (C-33 - C-39)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | addCountでカウントインクリメント | E-03 (snapshot.zig:44-55) | ○ |
| C-34 | getOrPutで新規スナップショット追加 | E-03 (snapshot.zig:56-114) | ○ |
| C-35 | getOrPutで既存スナップショット取得 | E-03 (snapshot.zig:83-85) | △ |
| C-36 | CIでスナップショット作成拒否 | E-03 (snapshot.zig:89-98) | ○ |
| C-37 | writeSnapshotFile書き込み | E-03 (snapshot.zig:190-211) | ○ |
| C-38 | addInlineSnapshotToWriteキュー追加 | E-03 (snapshot.zig:213-219) | ○ |
| C-39 | writeInlineSnapshotsファイル更新 | E-03 (snapshot.zig:222-482) | △ |

### FakeTimers関連 (C-40 - C-51)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | useFakeTimersで有効化 | E-04 (FakeTimers.zig:194-232) | ○ |
| C-41 | nowオプションで初期時刻設定 | E-04 (FakeTimers.zig:207-218) | ○ |
| C-42 | useRealTimersでリアルタイマーに戻る | E-04 (FakeTimers.zig:233-248) | ○ |
| C-43 | advanceTimersByTimeで時間進行 | E-04 (FakeTimers.zig:259-285) | ○ |
| C-44 | advanceTimersByTimeで負の値エラー | E-04 (FakeTimers.zig:272-274) | ○ |
| C-45 | advanceTimersToNextTimerで次タイマー実行 | E-04 (FakeTimers.zig:249-258) | ○ |
| C-46 | runAllTimersで全タイマー実行 | E-04 (FakeTimers.zig:296-305) | ○ |
| C-47 | runOnlyPendingTimersで保留タイマー実行 | E-04 (FakeTimers.zig:286-295) | ○ |
| C-48 | getTimerCountでタイマー数返却 | E-04 (FakeTimers.zig:306-319) | ○ |
| C-49 | clearAllTimersでクリア | E-04 (FakeTimers.zig:320-333) | ○ |
| C-50 | isFakeTimersで状態返却 | E-04 (FakeTimers.zig:334-346) | ○ |
| C-51 | errorUnlessFakeTimersで無効時エラー | E-04 (FakeTimers.zig:163-174) | △ |

### Collection関連 (C-52 - C-56)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | init初期化 | E-05 (Collection.zig:21-43) | ○ |
| C-53 | enqueueDescribeCallbackキュー追加 | E-05 (Collection.zig:61-77) | ○ |
| C-54 | step実行 | E-05 (Collection.zig:99-150) | ○ |
| C-55 | step完了判定 | E-05 (Collection.zig:148-149) | ○ |
| C-56 | handleUncaughtExceptionでfailed設定 | E-05 (Collection.zig:152-159) | ○ |

### Execution関連 (C-57 - C-67)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | init初期化 | E-06 (Execution.zig:158-164) | ○ |
| C-58 | loadFromOrderデータロード | E-06 (Execution.zig:169-177) | ○ |
| C-59 | stepでstartデータ処理 | E-06 (Execution.zig:210-260) | ○ |
| C-60 | stepGroupでグループ実行 | E-06 (Execution.zig:262-299) | ○ |
| C-61 | stepSequenceでコールバック実行 | E-06 (Execution.zig:333-415) | ○ |
| C-62 | advanceSequenceで次エントリ進行 | E-06 (Execution.zig:457-505) | ○ |
| C-63 | advanceSequenceでリトライ処理 | E-06 (Execution.zig:482-486) | ○ |
| C-64 | advanceSequenceでリピート処理 | E-06 (Execution.zig:489-493) | ○ |
| C-65 | handleTimeoutでプロセスキル | E-06 (Execution.zig:183-208) | ○ |
| C-66 | handleUncaughtExceptionでfailing非表示 | E-06 (Execution.zig:617-645) | ○ |
| C-67 | handleUncaughtExceptionで通常表示 | E-06 (Execution.zig:640-643) | ○ |

### ExecutionSequence/Entry/Result関連 (C-68 - C-76)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | ExecutionSequence.init初期化 | E-06 (Execution.zig:94-107) | ○ |
| C-69 | entryModeでモード返却 | E-06 (Execution.zig:109-112) | ○ |
| C-70 | ExecutionEntry.create生成 | E-08 (bun_test.zig:953-975) | ○ |
| C-71 | evaluateTimeoutでタイムアウト判定true | E-08 (bun_test.zig:977-994) | ○ |
| C-72 | evaluateTimeoutでタイムアウト前false | E-08 (bun_test.zig:977-994) | ○ |
| C-73 | Result.basicResultでpass変換 | E-06 (Execution.zig:137-145) | ○ |
| C-74 | Result.basicResultでfail変換 | E-06 (Execution.zig:141) | ○ |
| C-75 | Result.isPassでpass判定 | E-06 (Execution.zig:147-153) | ○ |
| C-76 | Result.isPassでskip判定 | E-06 (Execution.zig:149) | ○ |

### ScopeFunctions関連 (C-77 - C-96)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | getSkipでskip設定 | E-07 (ScopeFunctions.zig:27-29) | ○ |
| C-78 | getTodoでtodo設定 | E-07 (ScopeFunctions.zig:30-32) | ○ |
| C-79 | getFailingでfailing設定 | E-07 (ScopeFunctions.zig:33-35) | ○ |
| C-80 | describe.failingでエラー | E-07 (ScopeFunctions.zig:276) | ○ |
| C-81 | getConcurrentでconcurrent設定 | E-07 (ScopeFunctions.zig:36-38) | ○ |
| C-82 | getSerialでserial設定 | E-07 (ScopeFunctions.zig:39-41) | ○ |
| C-83 | getOnlyでonly設定 | E-07 (ScopeFunctions.zig:42-44) | ○ |
| C-84 | CI環境でonlyエラー | E-07 (ScopeFunctions.zig:282-286) | ○ |
| C-85 | fnIfで条件付きskip | E-07 (ScopeFunctions.zig:45-47) | ○ |
| C-86 | fnSkipIfで条件付きskip | E-07 (ScopeFunctions.zig:48-50) | ○ |
| C-87 | fnTodoIfで条件付きtodo | E-07 (ScopeFunctions.zig:51-53) | ○ |
| C-88 | fnEachでeach設定 | E-07 (ScopeFunctions.zig:63-76) | ○ |
| C-89 | fnEachで配列以外エラー | E-07 (ScopeFunctions.zig:68-71) | ○ |
| C-90 | callAsFunctionでテスト登録 | E-07 (ScopeFunctions.zig:78-142) | ○ |
| C-91 | callAsFunctionでdescribe登録 | E-07 (ScopeFunctions.zig:216-219) | ○ |
| C-92 | 実行フェーズでエラー | E-07 (ScopeFunctions.zig:178-179) | ○ |
| C-93 | parseArgumentsで3引数解析 | E-07 (ScopeFunctions.zig:336-413) | ○ |
| C-94 | parseArgumentsで2引数解析 | E-07 (ScopeFunctions.zig:347) | ○ |
| C-95 | parseArgumentsで1引数解析 | E-07 (ScopeFunctions.zig:350) | ○ |
| C-96 | parseArgumentsでコールバック必須エラー | E-07 (ScopeFunctions.zig:360-362) | ○ |

### DescribeScope/BaseScope関連 (C-97 - C-105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | DescribeScope.createでスコープ生成 | E-08 (bun_test.zig:854-863) | ○ |
| C-98 | appendDescribeで子スコープ追加 | E-08 (bun_test.zig:896-901) | ○ |
| C-99 | appendTestでテスト追加 | E-08 (bun_test.zig:902-907) | ○ |
| C-100 | appendHookでフック追加 | E-08 (bun_test.zig:917-921) | ○ |
| C-101 | markContainsOnlyで親にonly伝播 | E-08 (bun_test.zig:879-887) | ○ |
| C-102 | BaseScope.initで初期化 | E-08 (bun_test.zig:815-830) | ○ |
| C-103 | BaseScope.initで親のconcurrent継承 | E-08 (bun_test.zig:821-823) | ○ |
| C-104 | BaseScopeCfg.extendで設定拡張 | E-08 (bun_test.zig:779-795) | ○ |
| C-105 | BaseScopeCfg.extendで重複時null | E-08 (bun_test.zig:783-784) | ○ |

### BunTestRoot/BunTest関連 (C-106 - C-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | BunTestRoot.initで初期化 | E-08 (bun_test.zig:131-148) | ○ |
| C-107 | enterFileでファイル開始 | E-08 (bun_test.zig:155-163) | ○ |
| C-108 | exitFileでファイル終了 | E-08 (bun_test.zig:164-172) | ○ |
| C-109 | getActiveFileUnlessInPreloadでpreload制限 | E-08 (bun_test.zig:173-178) | △ |
| C-110 | BunTest.initで初期化 | E-08 (bun_test.zig:231-257) | ○ |
| C-111 | runで結果キュー処理 | E-08 (bun_test.zig:525-555) | ○ |
| C-112 | runTestCallbackで同期結果返却 | E-08 (bun_test.zig:622-715) | ○ |
| C-113 | runTestCallbackで非同期null返却 | E-08 (bun_test.zig:684-689) | ○ |
| C-114 | runTestCallbackでdoneパラメータ | E-08 (bun_test.zig:633-640) | ○ |
| C-115 | getCurrentStateDataでcollection返却 | E-08 (bun_test.zig:349-386) | ○ |
| C-116 | getCurrentStateDataでexecution返却 | E-08 (bun_test.zig:352-383) | ○ |
| C-117 | onUncaughtExceptionで例外処理 | E-08 (bun_test.zig:718-754) | ○ |
| C-118 | bunTestTimeoutCallbackでrun呼び出し | E-08 (bun_test.zig:474-491) | ○ |

### formatLabel関連 (C-119 - C-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | %sプレースホルダー置換 | E-01 (jest.zig:417-420) | △ |
| C-120 | %dプレースホルダー置換 | E-01 (jest.zig:424-426) | △ |
| C-121 | $変数プレースホルダー置換 | E-01 (jest.zig:366-404) | ○ |
| C-122 | %#テストインデックス置換 | E-01 (jest.zig:449-453) | ○ |

### DoneCallback関連 (C-123 - C-125)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | bunTestDoneCallbackでテスト完了 | E-08 (bun_test.zig:434-473) | ○ |
| C-124 | done(error)でエラー報告 | E-08 (bun_test.zig:448-450) | ○ |
| C-125 | 2回目done()無視 | E-08 (bun_test.zig:443-446) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の項目
1. **C-35 (Snapshots.getOrPut既存スナップショット取得)**
   - values HashMapの実装詳細について、parseFile()との連携が複雑
   - 候補: parseFile実装の詳細解析 / 既存テストの確認

2. **C-39 (Snapshots.writeInlineSnapshots)**
   - ファイル書き込みロジックが複雑で、全エッジケースの検証が困難
   - 候補: 既存テストケースの確認 / 手動テストの実施

3. **C-51 (FakeTimers.errorUnlessFakeTimers)**
   - エラーメッセージの正確な文言の確認が必要
   - 候補: 実行時テストで確認

4. **C-109 (BunTestRoot.getActiveFileUnlessInPreload)**
   - preload状態の判定条件の詳細確認が必要
   - 候補: VirtualMachine.is_in_preloadの実装確認

5. **C-119, C-120 (formatLabel %s, %d)**
   - プレースホルダー置換の全パターンのテストが必要
   - 候補: 既存テストケースの確認

## 5) リスクフラグ（レビュー観点）

| リスク | 説明 | 対象Claim |
|--------|------|-----------|
| 1: 中リスク | スナップショット処理の複雑なロジック | C-35, C-39 |
| 1: 中リスク | FakeTimersの状態管理 | C-40-C-51 |
| 0: 低リスク | 単純なゲッター/セッター | C-06, C-07, C-73-C-76 |
| 1: 中リスク | 非同期処理のテスト | C-21-C-24, C-112-C-114 |
| 2: 高リスク | CI環境での動作制限 | C-36, C-84 |

## 6) レビュアーチェックリスト（最小）

- [ ] テストランナーの主要フロー（Collection -> Execution）が正しくカバーされているか
- [ ] Expect関連のアサーションメソッド（toBe, toEqual等）の個別テストケースは別途必要か確認
- [ ] FakeTimersのエッジケース（タイマーのオーバーフロー等）のテストが必要か確認
- [ ] スナップショット関連のCI制限が正しくテストされているか
- [ ] 非同期テスト（Promise, done callback）のタイムアウト処理が網羅されているか
- [ ] test.concurrent/test.serialの並行実行制御がテストされているか
- [ ] test.each, describe.eachのパラメータ化テストが網羅されているか
