---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UAT-042 FFI機能**：詳細なAPI仕様の確認が必要
  2. **UAT-043 S3アップロード**：クラウド認証フローの確認が必要
  3. **UAT-044 S3ダウンロード**：クラウド認証フローの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli.zig` - CLIコマンド定義（run, install, add, remove, test, build等）
- E-02: `src/cli/install_command.zig` - パッケージインストールコマンド実装
- E-03: `src/cli/add_command.zig` - パッケージ追加コマンド実装
- E-04: `src/cli/remove_command.zig` - パッケージ削除コマンド実装
- E-05: `src/cli/test_command.zig` - テストコマンド実装
- E-06: `src/cli/build_command.zig` - ビルドコマンド実装
- E-07: `src/bun.js/api/server.zig` - HTTPサーバAPI実装
- E-08: `src/bun.js/api/bun/subprocess.zig` - 子プロセス管理実装
- E-09: `src/bun.js/api/crypto.zig` - 暗号化API実装
- E-10: `src/bun.js/api/ffi.zig` - FFI実装
- E-11: `test/cli/install/bun-install.test.ts` - インストールテスト
- E-12: `test/cli/install/bun-add.test.ts` - パッケージ追加テスト
- E-13: `test/cli/test/bun-test.test.ts` - テストランナーテスト
- E-14: `test/js/bun/http/serve.test.ts` - HTTPサーバテスト
- E-15: `test/js/web/websocket/websocket-server.test.ts` - WebSocketテスト
- E-16: `test/js/bun/util/bun-file.test.ts` - ファイルI/Oテスト
- E-17: `test/js/web/fetch/fetch.test.ts` - Fetch APIテスト
- E-18: `test/js/bun/s3/s3.test.ts` - S3統合テスト
- E-19: `test/bundler/bun-build-api.test.ts` - バンドラーAPIテスト
- E-20: `test/cli/init/init.test.ts` - プロジェクト初期化テスト
- E-21: `test/cli/install/bun-link.test.ts` - パッケージリンクテスト
- E-22: `test/cli/install/bun-audit.test.ts` - セキュリティ監査テスト
- E-23: `test/cli/install/bun-publish.test.ts` - パッケージ公開テスト
- E-24: `test/cli/install/bun-patch.test.ts` - パッチ機能テスト
- E-25: `test/cli/install/bunx.test.ts` - bunx実行テスト
- E-26: `test/cli/hot/watch.test.ts` - ホットリロードテスト
- E-27: `package.json` - プロジェクト設定とスクリプト定義
- E-28: `CLAUDE.md` - 開発者向けドキュメント
- E-29: `src/cli/upgrade_command.zig` - アップグレードコマンド実装
- E-30: `src/cli/audit_command.zig` - 監査コマンド実装
- E-31: `src/cli/publish_command.zig` - 公開コマンド実装
- E-32: `src/cli/outdated_command.zig` - 依存関係確認コマンド実装
- E-33: `src/cli/bunx_command.zig` - bunxコマンド実装
- E-34: `src/cli/init_command.zig` - 初期化コマンド実装
- E-35: `test/js/node/` - Node.js互換性テストディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: 単一TypeScriptファイルの実行 | E-01, E-28 | ○ |
| C-02 | UAT-002: ES ModulesのImport/Export | E-01, E-28 | ○ |
| C-03 | UAT-003: トップレベルawaitの使用 | E-01, E-28 | ○ |
| C-04 | UAT-004: npm依存関係のインストール | E-02, E-11 | ○ |
| C-05 | UAT-005: 新規パッケージの追加 | E-03, E-12 | ○ |
| C-06 | UAT-006: 開発依存関係の追加 | E-03, E-12 | ○ |
| C-07 | UAT-007: パッケージの削除 | E-04 | ○ |
| C-08 | UAT-008: ワークスペースのインストール | E-02, E-11 | ○ |
| C-09 | UAT-009: パッケージの更新確認 | E-32 | ○ |
| C-10 | UAT-010: セキュリティ監査 | E-30, E-22 | ○ |
| C-11 | UAT-011: 単一ファイルへのバンドル | E-06, E-19 | ○ |
| C-12 | UAT-012: ミニファイ付きバンドル | E-06, E-19 | ○ |
| C-13 | UAT-013: ソースマップ生成 | E-06, E-19 | ○ |
| C-14 | UAT-014: スタンドアロン実行ファイル生成 | E-06, E-19 | ○ |
| C-15 | UAT-015: テストファイルの実行 | E-05, E-13 | ○ |
| C-16 | UAT-016: 特定テストのフィルタ実行 | E-05, E-13 | ○ |
| C-17 | UAT-017: カバレッジレポート生成 | E-05, E-13 | ○ |
| C-18 | UAT-018: スナップショットテスト | E-05, E-13 | ○ |
| C-19 | UAT-019: 基本的なHTTPサーバ起動 | E-07, E-14 | ○ |
| C-20 | UAT-020: TLS対応HTTPSサーバ | E-07, E-14 | ○ |
| C-21 | UAT-021: 静的ファイル配信 | E-07, E-14 | ○ |
| C-22 | UAT-022: WebSocketサーバの作成 | E-07, E-15 | ○ |
| C-23 | UAT-023: WebSocketクライアント接続 | E-15 | ○ |
| C-24 | UAT-024: ファイル読み込み | E-16 | ○ |
| C-25 | UAT-025: ファイル書き込み | E-16 | ○ |
| C-26 | UAT-026: ストリーム処理 | E-16 | ○ |
| C-27 | UAT-027: HTTPリクエスト送信 | E-17 | ○ |
| C-28 | UAT-028: POSTリクエスト送信 | E-17 | ○ |
| C-29 | UAT-029: 子プロセス起動 | E-08 | ○ |
| C-30 | UAT-030: プロセス間パイプ | E-08 | ○ |
| C-31 | UAT-031: ハッシュ計算 | E-09 | ○ |
| C-32 | UAT-032: パスワードハッシュ | E-09 | ○ |
| C-33 | UAT-033: パスワード検証 | E-09 | ○ |
| C-34 | UAT-034: REPLセッション開始 | E-01 | ○ |
| C-35 | UAT-035: npxスタイルのパッケージ実行 | E-33, E-25 | ○ |
| C-36 | UAT-036: .envファイルの自動読み込み | E-28 | ○ |
| C-37 | UAT-037: ファイル変更時の自動再起動 | E-26 | ○ |
| C-38 | UAT-038: SQLiteデータベース操作 | E-28 | ○ |
| C-39 | UAT-039: npmレジストリへの公開 | E-31, E-23 | ○ |
| C-40 | UAT-040: 新規プロジェクト作成 | E-34, E-20 | ○ |
| C-41 | UAT-041: ローカルパッケージのリンク | E-21 | ○ |
| C-42 | UAT-042: Cライブラリの呼び出し | E-10 | △ |
| C-43 | UAT-043: S3へのファイルアップロード | E-18 | △ |
| C-44 | UAT-044: S3からのファイルダウンロード | E-18 | △ |
| C-45 | UAT-045: 構文エラーの報告 | E-01, E-28 | ○ |
| C-46 | UAT-046: ランタイムエラーのスタックトレース | E-01, E-28 | ○ |
| C-47 | UAT-047: fsモジュールの使用 | E-35 | ○ |
| C-48 | UAT-048: pathモジュールの使用 | E-35 | ○ |
| C-49 | UAT-049: cryptoモジュールの使用 | E-35 | ○ |
| C-50 | UAT-050: 依存パッケージのパッチ適用 | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-042 FFI機能**: dlopen APIの詳細な引数仕様と型マッピングについて、実装コード（E-10）は存在するが、ユーザー向けドキュメントが不足
  - 候補：公式ドキュメント / APIリファレンス / サンプルコード
- **UAT-043/044 S3機能**: S3認証情報の設定方法と環境変数について、テストコード（E-18）は存在するが、具体的な認証フローが未確認
  - 候補：認証設定ガイド / 環境変数一覧 / AWSドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UAT-001〜UAT-041, UAT-045〜UAT-050 - CLIコマンドとコアAPI機能は既存テストで十分にカバー
- **1（中リスク）**: UAT-042 FFI - ネイティブコード統合のためプラットフォーム依存性あり
- **1（中リスク）**: UAT-043, UAT-044 S3機能 - 外部サービス依存のためテスト環境構築が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UAT-001〜UAT-007, UAT-015, UAT-019, UAT-024〜UAT-028）の前提条件とテスト手順が実行可能か確認
- [ ] パッケージマネージャ機能（UAT-004〜UAT-010）のシナリオが実際のユースケースを網羅しているか確認
- [ ] Node.js互換性テスト（UAT-047〜UAT-049）で対象とすべき追加のモジュールがないか確認
- [ ] FFI機能（UAT-042）のテスト手順がプラットフォーム（macOS/Linux/Windows）ごとに適切か確認
- [ ] S3機能（UAT-043, UAT-044）のテスト環境構築手順を補足するか検討
