---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/cli/test_command.zig` - JunitReporter構造体の実装（73-567行目）
- E-02: `src/bunfig.zig` - テストレポーター設定の解析（288-301行目）
- E-03: `src/bunfig.zig` - カバレッジレポーター設定の解析（303-331行目）
- E-04: `src/bunfig.zig` - カバレッジディレクトリ設定（333-336行目）
- E-05: `src/bunfig.zig` - カバレッジ閾値設定（338-365行目）
- E-06: `src/bun.js/bindings/CodeCoverage.cpp` - コードカバレッジ取得実装
- E-07: `src/cli/Arguments.zig` - CLIオプション定義（--reporter, --coverage等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JUnit XMLレポートが存在する | E-01 | ○ |
| C-02 | JUnit XMLレポートはtest.reporter.junitで設定可能 | E-02 | ○ |
| C-03 | JunitReporter構造体がsrc/cli/test_command.zigに存在 | E-01 | ○ |
| C-04 | コードカバレッジレポート（テキスト形式）が存在する | E-03 | ○ |
| C-05 | coverageReporter=textでテキスト形式を有効化 | E-03 | ○ |
| C-06 | コードカバレッジレポート（LCOV形式）が存在する | E-03 | ○ |
| C-07 | coverageReporter=lcovでLCOV形式を有効化 | E-03 | ○ |
| C-08 | coverageDirで出力先を指定可能 | E-04 | ○ |
| C-09 | coverageThresholdでカバレッジ閾値を設定可能 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての帳票情報はソースコードから直接確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] JUnit XMLレポートの出力形式が要件を満たしているか確認
- [ ] LCOVレポートが他のカバレッジツールと互換性があるか確認
- [ ] 本プロジェクト（Bun）がビジネス帳票（請求書、領収書等）を含まないことを確認（含まない）
