# 帳票設計書 2-コードカバレッジレポート（テキスト形式）

## 概要

本ドキュメントは、Bunテストランナーが出力するコードカバレッジのテキスト形式レポートの設計仕様を記載したものである。

### 本帳票の処理概要

コードカバレッジレポート（テキスト形式）は、テスト実行時のコードカバレッジ情報をコンソールに表形式で出力する帳票である。関数カバレッジと行カバレッジの割合をファイル単位で表示し、カバレッジ閾値に対する合否判定を視覚的に提示する。

**業務上の目的・背景**：ソフトウェア品質の定量的指標としてコードカバレッジは重要な役割を果たす。テスト実行直後にカバレッジ状況を即座に確認できることで、テスト不足の領域を早期に特定し、品質向上施策の優先順位付けが可能となる。また、カバレッジ閾値を設定することで品質ゲートとして機能させ、一定水準以下のカバレッジでビルドを失敗させることができる。

**帳票の利用シーン**：ローカル開発環境でのテスト実行後のカバレッジ確認、CI/CDパイプラインでの品質ゲート判定、コードレビュー時のテスト網羅性評価、リファクタリング前後のカバレッジ比較に利用される。

**主要な出力内容**：
1. ファイル単位の関数カバレッジ率（% Funcs）
2. ファイル単位の行カバレッジ率（% Lines）
3. 未実行行番号のリスト（Uncovered Line #s）
4. 全ファイル合計のカバレッジサマリ
5. 閾値に対する合否判定（色分け表示）

**帳票の出力タイミング**：`bun test --coverage`コマンド実行完了時、または`bunfig.toml`の`test.coverage=true`設定時に自動出力される。

**帳票の利用者**：開発者、QAエンジニア、テックリード、CI/CDパイプライン

## 帳票種別

テスト結果レポート / コンソール出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| CLI-001 | コマンドライン | `bun test --coverage` | テスト実行完了時に標準エラー出力に自動表示 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（コンソール出力） |
| 用紙サイズ | N/A（画面幅に依存） |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | コンソール表示（stderr） |
| 文字コード | UTF-8 |

### 表示設定

| 項目 | 内容 |
|-----|------|
| ANSIカラー | ターミナル対応時は色分け表示 |
| 閾値超過表示 | 緑色（合格） |
| 閾値未達表示 | 赤色（不合格） |

## 帳票レイアウト

### レイアウト概要

表形式でファイル単位のカバレッジ情報を表示し、最終行に全体サマリを出力する。

```
--------------------------------------|---------|---------|-------------------
File                                   | % Funcs | % Lines | Uncovered Line #s
--------------------------------------|---------|---------|-------------------
 path/to/file1.ts                      |   85.00 |   92.50 | 45-48,102
 path/to/file2.ts                      |  100.00 |  100.00 |
All files                              |   92.50 |   96.25 |
--------------------------------------|---------|---------|-------------------
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 区切り線 | ダッシュによる区切り | 固定 | `-` の繰り返し |
| 2 | File | カラムヘッダー | 固定 | 文字列 |
| 3 | % Funcs | 関数カバレッジヘッダー | 固定 | 文字列 |
| 4 | % Lines | 行カバレッジヘッダー | 固定 | 文字列 |
| 5 | Uncovered Line #s | 未カバー行ヘッダー | 固定 | 文字列 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | File | ファイルパス（相対パス） | report.source_url | 左寄せ、先頭スペース | 最長パス+1 |
| 2 | % Funcs | 関数カバレッジ率 | functionCoverageFraction() * 100 | 右寄せ、小数2桁 | 7桁 |
| 3 | % Lines | 行カバレッジ率 | linesCoverageFraction() * 100 | 右寄せ、小数2桁 | 7桁 |
| 4 | Uncovered Line #s | 未実行行番号 | executable_lines - lines_which_have_executed | カンマ区切り、範囲は"-"で連結 | 可変 |

### フッター部（サマリ行）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | All files | 固定ラベル | 固定 | 文字列 |
| 2 | % Funcs平均 | 全ファイルの関数カバレッジ平均 | avg.functions / avg_count | 小数2桁 |
| 3 | % Lines平均 | 全ファイルの行カバレッジ平均 | avg.lines / avg_count | 小数2桁 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| --coverage | CLIオプションでカバレッジを有効化 | No |
| bunfig.toml test.coverage | 設定ファイルでカバレッジを有効化 | No |
| coverageReporter=text | テキストレポーターを指定（デフォルト） | No |
| coveragePathIgnorePatterns | 除外パターンにマッチしないこと | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ファイルパス | 昇順（アルファベット順） |

### 改ページ条件

N/A（コンソール出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

N/A（データベースを使用しない。JavaScriptCoreのコントロールフロープロファイラからデータ取得）

### データ構造

#### CodeCoverage.Report構造体

| フィールド | 型 | 用途 |
|-----------|------|------|
| source_url | ZigString.Slice | ソースファイルパス |
| executable_lines | Bitset | 実行可能な行のビットセット |
| lines_which_have_executed | Bitset | 実行された行のビットセット |
| line_hits | BabyList(u32) | 行ごとの実行回数 |
| functions | ArrayListUnmanaged(Block) | 関数ブロック情報 |
| functions_which_have_executed | Bitset | 実行された関数のビットセット |
| total_lines | u32 | 総行数 |

#### Fraction構造体

| フィールド | 型 | 用途 | デフォルト値 |
|-----------|------|------|-------------|
| functions | f64 | 関数カバレッジ閾値 | 0.9 (90%) |
| lines | f64 | 行カバレッジ閾値 | 0.9 (90%) |
| stmts | f64 | ステートメントカバレッジ閾値 | 0.75 (75%) |
| failing | bool | 閾値未達フラグ | false |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 行カバレッジ率 | (実行行数 / 実行可能行数) * 100 | 小数2桁 | 実行可能行数が0の場合は100% |
| 関数カバレッジ率 | (実行関数数 / 総関数数) * 100 | 小数2桁 | 総関数数が0の場合は100% |
| 全体平均カバレッジ | 各ファイルのカバレッジ合計 / ファイル数 | 小数2桁 | - |

### 閾値判定

| 判定 | 条件 | 表示色 |
|------|------|-------|
| 合格 | カバレッジ率 >= 閾値 | 緑（green） |
| 不合格 | カバレッジ率 < 閾値 | 赤（red） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[テスト実行完了] --> B{coverage有効?}
    B -->|No| Z[終了]
    B -->|Yes| C[ByteRangeMapping.mapからエントリ取得]
    C --> D[ファイルパスでソート]
    D --> E{coveragePathIgnorePatterns?}
    E -->|マッチ| F[スキップ]
    E -->|マッチしない| G[Report.generate]
    G --> H[Text.writeFormat]
    H --> I[カラム出力]
    I --> J[未実行行番号計算・出力]
    J --> K{次のファイル?}
    K -->|Yes| E
    K -->|No| L[All filesサマリ行出力]
    L --> M[区切り線出力]
    M --> N{fail_on_low_coverage?}
    N -->|Yes & 閾値未達| O[exit code = 1]
    N -->|No| Z
    F --> K
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | カバレッジ対象ファイルが0件 | （出力なし） | テスト対象ファイルの確認 |
| ソースマップ取得失敗 | ソースマップが見つからない | （スキップ） | TypeScript設定の確認 |
| OOM | 大量ファイルでメモリ不足 | システムOOM処理 | ファイル分割または環境リソース増強 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千ファイル |
| 目標出力時間 | テスト実行時間の5%未満 |
| 同時出力数上限 | 1（シングルスレッド出力） |

## セキュリティ考慮事項

- ファイルパスはプロジェクトルートからの相対パスで表示
- node_modulesディレクトリは自動的に除外
- 機密情報を含む可能性のあるファイルパスがコンソールに出力される点に注意

## 備考

- ANSIカラーコードはターミナルがサポートしている場合のみ出力
- ソースマップが利用可能な場合、元のTypeScript/JSXの行番号にマッピング
- カバレッジ閾値は`bunfig.toml`の`test.coverageThreshold`で設定可能
- `coverageSkipTestFiles`オプションでテストファイル自体を除外可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カバレッジデータの収集と保持に使用される構造体を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | Report構造体（17-26行目）- カバレッジデータの核となる構造 |
| 1-2 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | Fraction構造体（709-718行目）- カバレッジ閾値の定義 |
| 1-3 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | ByteRangeMapping構造体（358-406行目）- ソースマップとの関連付け |

**読解のコツ**: Bitsetはビット演算で効率的に行の実行状態を管理。`executable_lines`と`lines_which_have_executed`の積集合がカバレッジ率の分子。

#### Step 2: カバレッジ計算ロジックを理解する

カバレッジ率の算出方法を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | linesCoverageFraction関数（28-41行目）- 行カバレッジ率の計算 |
| 2-2 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | functionCoverageFraction関数（53-59行目）- 関数カバレッジ率の計算 |

**主要処理フロー**:
1. **29-30行目**: executable_linesをクローンしてintersectedを作成
2. **31行目**: lines_which_have_executedとの積集合を計算
3. **38-40行目**: intersected.count() / executable_lines.count() で割合算出

#### Step 3: テキスト出力処理を理解する

コンソールへの表形式出力ロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | Text.writeFormat関数（119-208行目）- ファイル単位の出力処理 |
| 3-2 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | Text.writeFormatWithValues関数（62-117行目）- カラム値の出力 |
| 3-3 | test_command.zig | `src/cli/test_command.zig` | printCodeCoverage関数（997-1245行目）- 全体の出力制御 |

**主要処理フロー**:
- **1054-1065行目**: ヘッダー行と区切り線の出力
- **1140-1183行目**: ファイルごとのループ処理
- **1162-1174行目**: Text.writeFormatの呼び出しとカバレッジ平均の集計
- **1185-1224行目**: サマリ行の出力

#### Step 4: 未実行行番号の計算を理解する

Uncovered Line #sカラムの値を生成するロジックを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | Text.writeFormat内の未実行行計算（156-207行目） |

**主要処理フロー**:
- **156-158行目**: lines_which_have_executedの反転コピーを作成
- **161行目**: executable_linesとの積集合で「実行可能だが未実行」の行を特定
- **163-206行目**: イテレータで連続した行番号を範囲形式（例: 45-48）で出力

#### Step 5: 設定と有効化を理解する

カバレッジ機能の有効化と設定の読み込みを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | bunfig.zig | `src/bunfig.zig` | test.coverage設定（278-281行目） |
| 5-2 | bunfig.zig | `src/bunfig.zig` | test.coverageReporter設定（303-331行目） |
| 5-3 | bunfig.zig | `src/bunfig.zig` | test.coverageThreshold設定（338-365行目） |
| 5-4 | Arguments.zig | `src/cli/Arguments.zig` | --coverage, --coverage-reporter引数（224-226行目） |

### プログラム呼び出し階層図

```
TestCommand.exec (1307行目)
    │
    ├─ ctx.test_options.coverage.enabled チェック (1420行目)
    │
    ├─ vm.transpiler.options.code_coverage = true (1421行目)
    │      └─ JavaScriptCore コントロールフロープロファイラ有効化 (1426行目)
    │
    ├─ runAllTests (1541行目)
    │      └─ テスト実行中にカバレッジデータ収集
    │
    └─ generateCodeCoverage (1546行目)
           │
           ├─ ByteRangeMapping.map からエントリ取得 (976-977行目)
           │
           └─ printCodeCoverage (997行目)
                  │
                  ├─ Report.generate (1159行目)
                  │      └─ generateReportFromBlocks (407-650行目)
                  │
                  └─ Text.writeFormat (1164行目)
                         ├─ functionCoverageFraction (128行目)
                         ├─ linesCoverageFraction (129行目)
                         └─ writeFormatWithValues (143-152行目)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

JavaScriptCore              ─────▶ ByteRangeMapping               ─────▶ コンソール
Control Flow Profiler              ├─ ソースマップ関連付け                  （stderr）
                                   └─ 行オフセット計算

テスト対象                  ─────▶ Report.generate                 ─────▶ 表形式
ソースコード                       ├─ Bitset構築                          カバレッジ
                                   ├─ 実行行マーキング                      データ
                                   └─ 関数ブロック解析

bunfig.toml設定             ─────▶ CodeCoverageOptions             ─────▶ 閾値判定
(coverageThreshold)                └─ Fraction構造体                      合否表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeCoverage.zig | `src/sourcemap/CodeCoverage.zig` | ソース | カバレッジデータ構造、計算ロジック、テキスト出力フォーマット |
| test_command.zig | `src/cli/test_command.zig` | ソース | テストコマンド実行、カバレッジ出力制御 |
| bunfig.zig | `src/bunfig.zig` | ソース | bunfig.tomlのカバレッジ関連設定パース |
| Arguments.zig | `src/cli/Arguments.zig` | ソース | --coverage, --coverage-reporter等のCLI引数定義 |
