---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：2-コードカバレッジレポート（テキスト形式）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的なベンチマーク根拠なし
  2. **想定データ件数**：実際の制限値の根拠不明

## 2) 参照した情報（Evidence一覧）

- E-01: `src/sourcemap/CodeCoverage.zig` Report構造体（17-26行目）
- E-02: `src/sourcemap/CodeCoverage.zig` Fraction構造体（709-718行目）
- E-03: `src/sourcemap/CodeCoverage.zig` linesCoverageFraction関数（28-41行目）
- E-04: `src/sourcemap/CodeCoverage.zig` functionCoverageFraction関数（53-59行目）
- E-05: `src/sourcemap/CodeCoverage.zig` Text.writeFormat関数（119-208行目）
- E-06: `src/sourcemap/CodeCoverage.zig` Text.writeFormatWithValues関数（62-117行目）
- E-07: `src/cli/test_command.zig` printCodeCoverage関数（997-1245行目）
- E-08: `src/cli/test_command.zig` generateCodeCoverage関数（970-995行目）
- E-09: `src/bunfig.zig` test.coverage設定（278-281行目）
- E-10: `src/bunfig.zig` test.coverageReporter設定（303-331行目）
- E-11: `src/bunfig.zig` test.coverageThreshold設定（338-365行目）
- E-12: `src/cli/Arguments.zig` --coverage引数（224行目）
- E-13: `src/cli/Arguments.zig` --coverage-reporter引数（225行目）
- E-14: `src/sourcemap/CodeCoverage.zig` ByteRangeMapping構造体（358-406行目）
- E-15: `src/cli/test_command.zig` ヘッダー出力（1054-1065行目）
- E-16: `src/cli/test_command.zig` サマリ出力（1185-1224行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンソールに表形式でカバレッジ情報を出力する | E-05, E-07, E-15 | ○ |
| C-02 | 標準エラー出力（stderr）に出力する | E-07 (1050行目) | ○ |
| C-03 | Report構造体でカバレッジデータを保持する | E-01 | ○ |
| C-04 | executable_linesビットセットで実行可能行を管理 | E-01 (19行目) | ○ |
| C-05 | lines_which_have_executedビットセットで実行行を管理 | E-01 (20行目) | ○ |
| C-06 | 行カバレッジ率 = 実行行数 / 実行可能行数 | E-03 (28-41行目) | ○ |
| C-07 | 関数カバレッジ率 = 実行関数数 / 総関数数 | E-04 (53-59行目) | ○ |
| C-08 | 実行可能行数が0の場合は100%を返す | E-03 (34-36行目) | ○ |
| C-09 | 総関数数が0の場合は100%を返す | E-04 (55-57行目) | ○ |
| C-10 | Fractionのデフォルト閾値: functions=0.9, lines=0.9 | E-02 (710-711行目) | ○ |
| C-11 | 閾値超過で緑色、閾値未達で赤色表示 | E-06 (72-78行目, 88-94行目, 108-114行目) | ○ |
| C-12 | ファイルパスは相対パスで表示 | E-05 (138-141行目) | ○ |
| C-13 | 未実行行は連続した場合は範囲形式（例: 45-48）で出力 | E-05 (184-188行目) | ○ |
| C-14 | カラム区切りは ` \| ` で表示 | E-06 (86行目, 106行目) | ○ |
| C-15 | All filesサマリ行で全体平均を出力 | E-16 (1203-1214行目) | ○ |
| C-16 | --coverageオプションで有効化 | E-12 | ○ |
| C-17 | bunfig.tomlのtest.coverageで有効化 | E-09 | ○ |
| C-18 | coverageReporter=textでテキスト出力（デフォルト） | E-10 (303-331行目) | ○ |
| C-19 | coveragePathIgnorePatternsで除外パターン指定 | E-07 (1029-1042行目, 1141-1157行目) | ○ |
| C-20 | ファイルパスでソート | E-08 (987-992行目) | ○ |
| C-21 | node_modulesは自動的に除外 | E-07 (test_command.zig 1260-1261行目のBunTest__shouldGenerateCodeCoverage) | ○ |
| C-22 | ソースマップ対応でTypeScriptの元行番号にマッピング | E-14, E-05 (419行目のparsed_mappings_) | ○ |
| C-23 | coverageThresholdで閾値設定可能 | E-11 | ○ |
| C-24 | coverageSkipTestFilesでテストファイル除外可能 | E-07 (test_command.zig 1273-1280行目) | ○ |
| C-25 | ANSIカラーコードはターミナル対応時のみ出力 | E-06 (72行目のenable_colors分岐) | ○ |
| C-26 | fail_on_low_coverageで閾値未達時にexit code=1 | E-11 (343行目), E-07 (1547行目付近) | ○ |
| C-27 | 想定データ件数は数百〜数千ファイル | **根拠なし** | △ |
| C-28 | 目標出力時間はテスト実行時間の5%未満 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件（C-27, C-28）**：ソースコード上に具体的なパフォーマンス目標や制限値の記載がない
  - 候補：ベンチマークテスト / 設計ドキュメント / イシュー・PR

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - カバレッジ計算ロジック、表形式出力、色分け表示
- **0: 低リスク** - 設定ファイルからの閾値読み込み
- **0: 低リスク** - 未実行行番号の範囲形式出力
- **1: 中リスク** - パフォーマンス要件（実測値に基づく検証が望ましい）

## 6) レビュアーチェックリスト（最小）

- [ ] Report構造体のフィールドが設計書と一致するか確認
- [ ] linesCoverageFraction/functionCoverageFractionの計算式が正確か確認
- [ ] 未実行行の範囲形式出力ロジックが正しいか確認
- [ ] 閾値に基づく色分け表示の分岐条件が正確か確認
- [ ] coveragePathIgnorePatternsのglob マッチングが正しく動作するか確認
- [ ] パフォーマンス要件について実際のテスト実行で検証
