---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：3-コードカバレッジレポート（LCOV形式）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的なベンチマーク根拠なし
  2. **想定データ件数**：実際の制限値の根拠不明

## 2) 参照した情報（Evidence一覧）

- E-01: `src/sourcemap/CodeCoverage.zig` Report構造体（17-26行目）
- E-02: `src/sourcemap/CodeCoverage.zig` line_hitsフィールド（21行目）
- E-03: `src/sourcemap/CodeCoverage.zig` Lcov.writeFormat関数（210-262行目）
- E-04: `src/cli/test_command.zig` printCodeCoverage関数LCOV部分（1078-1138行目）
- E-05: `src/cli/test_command.zig` LCOV書き込みとリネーム（1227-1244行目）
- E-06: `src/bunfig.zig` test.coverageReporter設定（303-331行目）
- E-07: `src/bunfig.zig` test.coverageDir設定（333-336行目）
- E-08: `src/cli/Arguments.zig` --coverage-reporter引数（225行目）
- E-09: `src/cli/Arguments.zig` --coverage-dir引数（226行目）
- E-10: `src/sourcemap/CodeCoverage.zig` TN:出力（221-223行目）
- E-11: `src/sourcemap/CodeCoverage.zig` SF:出力（225-227行目）
- E-12: `src/sourcemap/CodeCoverage.zig` FNF:出力（232-233行目）
- E-13: `src/sourcemap/CodeCoverage.zig` FNH:出力（236行目）
- E-14: `src/sourcemap/CodeCoverage.zig` DA:出力（248-252行目）
- E-15: `src/sourcemap/CodeCoverage.zig` LF:出力（255行目）
- E-16: `src/sourcemap/CodeCoverage.zig` LH:出力（258行目）
- E-17: `src/sourcemap/CodeCoverage.zig` end_of_record出力（260行目）
- E-18: `src/cli/test_command.zig` coverageDir作成（1083-1092行目）
- E-19: `src/cli/test_command.zig` 一時ファイル生成（1094-1098行目）
- E-20: `src/cli/test_command.zig` バッファサイズ64KB（1117行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LCOV形式でカバレッジデータをファイル出力する | E-03, E-04, E-05 | ○ |
| C-02 | 出力ファイル名は{coverageDir}/lcov.info | E-05 (1235-1238行目) | ○ |
| C-03 | デフォルトのcoverageDirは"coverage" | E-07 (333-336行目), test_command.zig (1291行目) | ○ |
| C-04 | TN:行でテスト名を出力（空値） | E-10 | ○ |
| C-05 | SF:行でソースファイルパスを出力 | E-11 | ○ |
| C-06 | ファイルパスは相対パスで記録 | E-03 (216-219行目) | ○ |
| C-07 | FNF:行で関数の総数を出力 | E-12 | ○ |
| C-08 | FNH:行で実行された関数数を出力 | E-13 | ○ |
| C-09 | DA:行で行番号と実行回数を出力 | E-14 | ○ |
| C-10 | DA行の行番号は1始まり | E-14 (251行目: line + 1) | ○ |
| C-11 | DA行の実行回数はline_hitsから取得 | E-14 (251行目) | ○ |
| C-12 | LF:行で実行可能行数を出力 | E-15 | ○ |
| C-13 | LH:行で実行された行数を出力 | E-16 | ○ |
| C-14 | end_of_recordでレコード終端を出力 | E-17 | ○ |
| C-15 | ブランチカバレッジ（BRDA等）は未対応 | E-03 (244-247行目コメント) | ○ |
| C-16 | 関数名（FN行）は未対応 | E-03 (229-231行目コメント) | ○ |
| C-17 | --coverage-reporter=lcovオプションで有効化 | E-08 | ○ |
| C-18 | bunfig.tomlのtest.coverageReporter=lcovで有効化 | E-06 (309-310行目) | ○ |
| C-19 | coverageReporterは配列形式で複数指定可能 | E-06 (318-331行目) | ○ |
| C-20 | 一時ファイルを使用してアトミック書き込み | E-19 | ○ |
| C-21 | 一時ファイル名は.lcov.info.{random}.tmp形式 | E-19 (1098行目) | ○ |
| C-22 | 書き込み完了後にlcov.infoにリネーム | E-05 (1231-1243行目) | ○ |
| C-23 | coverageDirが存在しない場合は作成 | E-18 (mkdirRecursive) | ○ |
| C-24 | バッファサイズは64KB | E-20 | ○ |
| C-25 | ファイル作成失敗時にエラーメッセージ出力 | E-04 (1108-1111行目) | ○ |
| C-26 | リネーム失敗時にエラーメッセージ出力 | E-05 (1240-1242行目) | ○ |
| C-27 | ファイルパスでソート | E-04 (987-992行目) | ○ |
| C-28 | coveragePathIgnorePatternsで除外可能 | E-04 (1141-1157行目) | ○ |
| C-29 | 想定データ件数は数百〜数千ファイル | **根拠なし** | △ |
| C-30 | 目標出力時間はテスト実行時間の5%未満 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- **パフォーマンス要件（C-29, C-30）**：ソースコード上に具体的なパフォーマンス目標や制限値の記載がない
  - 候補：ベンチマークテスト / 設計ドキュメント / イシュー・PR

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - LCOV形式出力ロジック（TN/SF/FNF/FNH/DA/LF/LH/end_of_record）
- **0: 低リスク** - 一時ファイルを使用したアトミック書き込み
- **0: 低リスク** - ディレクトリ作成とエラーハンドリング
- **1: 中リスク** - パフォーマンス要件（実測値に基づく検証が望ましい）
- **1: 中リスク** - 大量ファイル時のバッファ処理（64KBバッファの妥当性）

## 6) レビュアーチェックリスト（最小）

- [ ] Lcov.writeFormat関数の出力形式がLCOV仕様に準拠しているか確認
- [ ] DA行の行番号が1始まりで正しく出力されているか確認
- [ ] line_hitsの実行回数が正確に記録されているか確認
- [ ] 一時ファイルからlcov.infoへのリネームがアトミックに行われるか確認
- [ ] coverageDir作成時の権限エラーハンドリングが適切か確認
- [ ] genhtmlツールで正しくHTML化できるか実際にテスト
- [ ] パフォーマンス要件について実際のテスト実行で検証
