---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 70
  claims_with_evidence: 68
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：68 / 70、根拠なし：2
- 優先レビュー（高）
  1. **BR-061（開発サーバー起動）**：DevServerの詳細実装を確認必要
  2. **BR-066（対話的実行環境）**：REPL実装の詳細確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/bun-main/src/cli.zig` - CLIコマンドルーティング定義
- E-02: `/Users/tomoka.baba/Work/bun-main/src/bun.zig` - Bunランタイムコア定義
- E-03: `/Users/tomoka.baba/Work/bun-main/src/install/install.zig` - パッケージインストール処理
- E-04: `/Users/tomoka.baba/Work/bun-main/src/install/PackageManager.zig` - パッケージマネージャー実装
- E-05: `/Users/tomoka.baba/Work/bun-main/src/bun.js/api/server.zig` - HTTPサーバー実装
- E-06: `/Users/tomoka.baba/Work/bun-main/src/http.zig` - HTTPクライアント実装
- E-07: `/Users/tomoka.baba/Work/bun-main/src/js_parser.zig` - JavaScript/TypeScriptパーサー
- E-08: `/Users/tomoka.baba/Work/bun-main/src/cli/test_command.zig` - テストコマンド実装
- E-09: `/Users/tomoka.baba/Work/bun-main/CLAUDE.md` - プロジェクト説明ドキュメント
- E-10: `/Users/tomoka.baba/Work/bun-main/src/s3/` - S3クライアント実装ディレクトリ
- E-11: `/Users/tomoka.baba/Work/bun-main/src/shell/` - シェル実装ディレクトリ
- E-12: `/Users/tomoka.baba/Work/bun-main/src/bun.js/test/` - テストフレームワーク実装
- E-13: `/Users/tomoka.baba/Work/bun-main/src/sourcemap/` - ソースマップ実装
- E-14: `/Users/tomoka.baba/Work/bun-main/src/glob.zig` - Globパターンマッチング実装
- E-15: `/Users/tomoka.baba/Work/bun-main/src/install/lockfile/` - ロックファイル処理
- E-16: `/Users/tomoka.baba/Work/bun-main/src/install/lifecycle_script_runner.zig` - ライフサイクルスクリプト実行
- E-17: `/Users/tomoka.baba/Work/bun-main/src/css/` - CSSパーサー・処理
- E-18: `/Users/tomoka.baba/Work/bun-main/src/StandaloneModuleGraph.zig` - スタンドアロン実行ファイル生成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 JavaScriptファイル実行 | E-01, E-09 | ○ |
| C-02 | BR-002 Node.js互換モード実行 | E-01 (pretend_to_be_node, RunAsNodeCommand) | ○ |
| C-03 | BR-003 スクリプト評価実行 | E-01 (--eval, runtime_options.eval) | ○ |
| C-04 | BR-004 ホットリロード機能 | E-01 (HotReload enum, hot_reload) | ○ |
| C-05 | BR-005 依存関係インストール | E-03, E-04 (InstallCommand) | ○ |
| C-06 | BR-006 パッケージ追加 | E-01 (AddCommand), E-04 | ○ |
| C-07 | BR-007 パッケージ削除 | E-01 (RemoveCommand) | ○ |
| C-08 | BR-008 パッケージ更新 | E-01 (UpdateCommand), E-04 | ○ |
| C-09 | BR-009 ロックファイル管理 | E-03, E-15 (Lockfile, bun.lock.zig) | ○ |
| C-10 | BR-010 ワークスペース管理 | E-03 (Features.workspaces), E-04 (WorkspaceFilter) | ○ |
| C-11 | BR-011 グローバルインストール | E-04 (global_link_dir, canGloballyInstallPackages) | ○ |
| C-12 | BR-012 パッケージリンク | E-01 (LinkCommand, UnlinkCommand) | ○ |
| C-13 | BR-013 パッチ適用管理 | E-01 (PatchCommand), E-04 (patch_apply_batch) | ○ |
| C-14 | BR-014 脆弱性監査 | E-01 (AuditCommand), E-04 (Subcommand.audit) | ○ |
| C-15 | BR-015 古いパッケージ検出 | E-01 (OutdatedCommand) | ○ |
| C-16 | BR-016 パッケージ公開 | E-01 (PublishCommand) | ○ |
| C-17 | BR-017 パッケージ情報表示 | E-01 (InfoCommand) | ○ |
| C-18 | BR-018 依存関係理由表示 | E-01 (WhyCommand) | ○ |
| C-19 | BR-019 ライフサイクルスクリプト実行 | E-04 (LifecycleScriptSubprocess), E-16 | ○ |
| C-20 | BR-020 JavaScriptバンドル | E-01 (BuildCommand), E-09 | ○ |
| C-21 | BR-021 コード圧縮 | E-01 (BundlerOptions.minify_*) | ○ |
| C-22 | BR-022 コード分割 | E-01 (code_splitting) | ○ |
| C-23 | BR-023 ツリーシェイキング | E-01 (ignore_dce_annotations, emit_dce_annotations) | ○ |
| C-24 | BR-024 単一実行ファイル生成 | E-01 (compile), E-18 | ○ |
| C-25 | BR-025 ソースマップ生成 | E-13 (sourcemap/) | ○ |
| C-26 | BR-026 CSSバンドル | E-01 (css_chunking), E-17 | ○ |
| C-27 | BR-027 テスト実行 | E-01 (TestCommand), E-08, E-12 | ○ |
| C-28 | BR-028 テストフィルタリング | E-01 (test_filter_pattern), E-08 | ○ |
| C-29 | BR-029 スナップショットテスト | E-01 (update_snapshots), E-12 | ○ |
| C-30 | BR-030 テストカバレッジ | E-01 (coverage), E-13 (CodeCoverage.zig) | ○ |
| C-31 | BR-031 JUnitレポート出力 | E-08 (JunitReporter) | ○ |
| C-32 | BR-032 モック機能 | E-12 (jest.zig, expect.zig) | ○ |
| C-33 | BR-033 タイムアウト制御 | E-01 (default_timeout_ms) | ○ |
| C-34 | BR-034 HTTPサーバー起動 | E-05 (ServerConfig, Bun.serve) | ○ |
| C-35 | BR-035 静的ファイル配信 | E-05 (StaticRoute, FileRoute) | ○ |
| C-36 | BR-036 WebSocketサポート | E-05 (ServerWebSocket, WebSocketServerContext) | ○ |
| C-37 | BR-037 TLS/SSL対応 | E-05 (is_ssl), E-06 (BoringSSL) | ○ |
| C-38 | BR-038 ルーティング | E-05 (AnyRoute, framework_router) | ○ |
| C-39 | BR-039 HTTPリクエスト送信 | E-06 (HTTPClient, fetch) | ○ |
| C-40 | BR-040 プロキシ対応 | E-06 (http_proxy) | ○ |
| C-41 | BR-041 リダイレクト処理 | E-06 (MAX_REDIRECT_URL_LENGTH) | ○ |
| C-42 | BR-042 証明書検証 | E-06 (reject_unauthorized, checkServerIdentity) | ○ |
| C-43 | BR-043 JavaScriptパース | E-07 (js_parser, js_lexer) | ○ |
| C-44 | BR-044 JSXトランスパイル | E-07 (JSXImport, jsxDEV) | ○ |
| C-45 | BR-045 TypeScriptトランスパイル | E-07 (TypeParameterFlag) | ○ |
| C-46 | BR-046 モジュール解決 | E-02 (resolver, PackageJSON) | ○ |
| C-47 | BR-047 コマンドルーティング | E-01 (Command.which, Command.Tag) | ○ |
| C-48 | BR-048 ヘルプ表示 | E-01 (HelpCommand, cli_helptext_fmt) | ○ |
| C-49 | BR-049 バージョン管理 | E-01 (UpgradeCommand) | ○ |
| C-50 | BR-050 補完スクリプト生成 | E-01 (InstallCompletionsCommand, ShellCompletions) | ○ |
| C-51 | BR-051 bunx実行 | E-01 (BunxCommand, is_bunx_exe) | ○ |
| C-52 | BR-052 プロジェクト初期化 | E-01 (InitCommand) | ○ |
| C-53 | BR-053 プロジェクト作成 | E-01 (CreateCommand) | ○ |
| C-54 | BR-054 ファイル監視 | E-01 (watch, hot_reload) | ○ |
| C-55 | BR-055 globパターンマッチ | E-14 (glob.zig) | ○ |
| C-56 | BR-056 SQLite統合 | E-09 (bun:sqlite記述) | ○ |
| C-57 | BR-057 ネイティブ関数呼び出し | E-09 (bun:ffi記述) | ○ |
| C-58 | BR-058 シェルスクリプト実行 | E-01 (ExecCommand), E-11 | ○ |
| C-59 | BR-059 S3ストレージアクセス | E-10 (s3/client.zig, s3/multipart.zig) | ○ |
| C-60 | BR-060 暗号化機能提供 | E-02 (sha.zig, crypto参照) | ○ |
| C-61 | BR-061 開発サーバー起動 | E-05 (bake参照) | △ |
| C-62 | BR-062 HTMLバンドル | E-05 (HTMLBundle) | ○ |
| C-63 | BR-063 デバッガー接続 | E-01 (Debugger, debugger設定) | ○ |
| C-64 | BR-064 CPUプロファイリング | E-01 (cpu_prof) | ○ |
| C-65 | BR-065 ヒーププロファイリング | E-01 (heap_prof) | ○ |
| C-66 | BR-066 対話的実行環境 | E-01 (ReplCommand) | △ |
| C-67 | BR-067 メモリ効率最適化 | E-02 (mimalloc, z_allocator, debug_allocator) | ○ |
| C-68 | BR-068 並列タスク処理 | E-04 (ThreadPool, task_batch) | ○ |
| C-69 | BR-069 Node.js API互換 | E-02 (bun.js/node/参照), E-09 | ○ |
| C-70 | BR-070 Web API互換 | E-05, E-06 (fetch, WebSocket) | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-061（開発サーバー起動）**：DevServerの実装詳細を確認するための追加ファイル調査が必要
  - 候補：`src/bake/DevServer.zig` / `src/bake/` ディレクトリ内ファイル
- **BR-066（対話的実行環境）**：REPLの詳細実装がBunxCommand経由であり、内部実装の確認が必要
  - 候補：`bun-repl` パッケージの実装 / 内部REPL実装

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分の業務要件はソースコードから直接確認できる
- **1: 中リスク** - BR-061, BR-066は詳細実装の確認推奨
- **0: 低リスク** - 主要機能（パッケージ管理、バンドル、テスト、サーバー）は網羅的に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 70件の業務要件が適切に分類されているか確認
- [ ] 優先度の設定が妥当か確認（高：コア機能、中：開発支援、低：補助機能）
- [ ] 関連機能のマッピングがソースコードと整合しているか確認
- [ ] BR-061, BR-066の詳細実装を追加調査して根拠を補完
- [ ] Node.js/Web API互換性の範囲が正確に記述されているか確認
- [ ] パッケージ管理のnpm互換範囲が適切に記述されているか確認
