---
generated_at: 2026-01-27 16:30:00
metrics:
  claims_total: 116
  claims_with_evidence: 116
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：116 / 116、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：すべての項目に根拠が存在します

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要と機能一覧
- E-02: `CLAUDE.md` - 開発者向けビルドガイドとコード構造説明
- E-03: `src/cli.zig` - CLIコマンド定義とヘルプテキスト
- E-04: `src/cli/*.zig` - 各CLIコマンドの実装ファイル群
- E-05: `src/bun.js/api/` - Bun API実装ディレクトリ
- E-06: `src/bun.js/node/` - Node.js互換レイヤー実装
- E-07: `src/js/node/` - Node.jsモジュールのTypeScript実装
- E-08: `src/js/bun/` - Bunモジュール（ffi、sql、sqlite）
- E-09: `src/bundler/` - バンドラー実装
- E-10: `src/install/` - パッケージマネージャー実装
- E-11: `src/bun.js/test/` - テストランナー実装
- E-12: `src/shell/` - シェル実装
- E-13: `src/http/` - HTTPクライアント実装
- E-14: `src/sql/` - データベースクライアント実装
- E-15: `src/bake/` - フレームワーク実装
- E-16: `src/bun.js/bindings/` - JavaScriptCoreバインディング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JavaScript/TypeScript実行 | E-01, E-02 | ○ |
| C-02 | モジュール解決 | E-02 (resolver/) | ○ |
| C-03 | トランスパイラ | E-02 (src/transpiler.zig) | ○ |
| C-04 | ホットリロード | E-01 (Watch mode) | ○ |
| C-05 | REPL | E-03 (repl コマンド) | ○ |
| C-06 | 環境変数 | E-01 (Environment variables) | ○ |
| C-07 | プラグインシステム | E-01 (Plugins) | ○ |
| C-08 | bunfig.toml設定 | E-01 (bunfig.toml) | ○ |
| C-09 | bun run | E-03, E-04 (run_command.zig) | ○ |
| C-10 | bun test | E-03, E-04 (test_command.zig) | ○ |
| C-11 | bun build | E-03, E-04 (build_command.zig) | ○ |
| C-12 | bun install | E-03, E-04 (install_command.zig) | ○ |
| C-13 | bun add | E-03, E-04 (add_command.zig) | ○ |
| C-14 | bun remove | E-03, E-04 (remove_command.zig) | ○ |
| C-15 | bun update | E-03, E-04 (update_command.zig) | ○ |
| C-16 | bun upgrade | E-03, E-04 (upgrade_command.zig) | ○ |
| C-17 | bun init | E-03, E-04 (init_command.zig) | ○ |
| C-18 | bun create | E-03, E-04 (create_command.zig) | ○ |
| C-19 | bunx | E-03, E-04 (bunx_command.zig) | ○ |
| C-20 | bun link | E-03, E-04 (link_command.zig) | ○ |
| C-21 | bun unlink | E-03, E-04 (unlink_command.zig) | ○ |
| C-22 | bun publish | E-03, E-04 (publish_command.zig) | ○ |
| C-23 | bun patch | E-03, E-04 (patch_command.zig) | ○ |
| C-24 | bun patch-commit | E-03, E-04 (patch_commit_command.zig) | ○ |
| C-25 | bun outdated | E-03, E-04 (outdated_command.zig) | ○ |
| C-26 | bun audit | E-03, E-04 (audit_command.zig) | ○ |
| C-27 | bun pm | E-03, E-04 (package_manager_command.zig) | ○ |
| C-28 | bun why | E-03, E-04 (why_command.zig) | ○ |
| C-29 | bun exec | E-03, E-04 (exec_command.zig) | ○ |
| C-30 | JavaScriptバンドル | E-09 (bundle_v2.zig) | ○ |
| C-31 | ツリーシェイキング | E-02 (Advanced tree-shaking) | ○ |
| C-32 | コード分割 | E-09 (Chunk.zig) | ○ |
| C-33 | CSSバンドル | E-02 (CSS processing) | ○ |
| C-34 | HTMLバンドル | E-02 (HTML handling) | ○ |
| C-35 | 単一実行ファイル | E-01 (Single-file executable) | ○ |
| C-36 | ソースマップ | E-02 (sourcemap support) | ○ |
| C-37 | マクロ | E-01 (Macros) | ○ |
| C-38 | ローダー | E-01 (Loaders) | ○ |
| C-39 | 依存関係解決 | E-10 (dependency.zig) | ○ |
| C-40 | ロックファイル | E-10 (lockfile.zig) | ○ |
| C-41 | npmレジストリ | E-10 (npm.zig) | ○ |
| C-42 | グローバルキャッシュ | E-01 (Global cache) | ○ |
| C-43 | ワークスペース | E-01 (Workspaces) | ○ |
| C-44 | ライフサイクルスクリプト | E-10 (lifecycle_script_runner.zig) | ○ |
| C-45 | パッチ管理 | E-10 (patch_install.zig) | ○ |
| C-46 | pnpm互換 | E-10 (pnpm.zig) | ○ |
| C-47 | yarn互換 | E-10 (yarn.zig) | ○ |
| C-48 | Jest互換テスト | E-11 (jest.zig) | ○ |
| C-49 | スナップショットテスト | E-11 (snapshot.zig) | ○ |
| C-50 | モック機能 | E-01 (Mocks) | ○ |
| C-51 | コードカバレッジ | E-01 (Code coverage) | ○ |
| C-52 | Watchモード | E-01 (Watch mode) | ○ |
| C-53 | JUnitレポート | E-04 (test_command.zig - JunitReporter) | ○ |
| C-54 | DOMテスト | E-01 (DOM testing) | ○ |
| C-55 | Bun.serve | E-05 (server.zig) | ○ |
| C-56 | WebSocket | E-05 (server/) | ○ |
| C-57 | Bun.file | E-05 (BunObject.zig) | ○ |
| C-58 | Bun.write | E-01 (File I/O) | ○ |
| C-59 | Bun.spawn | E-01 (Child processes) | ○ |
| C-60 | Bun.Transpiler | E-05 (JSTranspiler.zig) | ○ |
| C-61 | bun:sqlite | E-08 (sqlite.ts) | ○ |
| C-62 | Bun.sql | E-14 (postgres/) | ○ |
| C-63 | Bun.redis | E-01 (Redis) | ○ |
| C-64 | Bun.s3 | E-05 (S3Client.classes.ts) | ○ |
| C-65 | bun:ffi | E-05 (ffi.zig) | ○ |
| C-66 | Bun.cc | E-01 (C Compiler) | ○ |
| C-67 | Bun.Glob | E-05 (glob.zig) | ○ |
| C-68 | FileSystemRouter | E-05 (filesystem_router.zig) | ○ |
| C-69 | HTMLRewriter | E-05 (html_rewriter.zig) | ○ |
| C-70 | Bun.color | E-01 (Colors) | ○ |
| C-71 | Bun.hash | E-05 (HashObject.zig) | ○ |
| C-72 | Bun.CryptoHasher | E-05 (crypto/) | ○ |
| C-73 | $シェル | E-12 (shell.zig) | ○ |
| C-74 | TCPソケット | E-01 (TCP sockets) | ○ |
| C-75 | UDPソケット | E-01 (UDP sockets) | ○ |
| C-76 | Fetch API | E-01 (Web APIs) | ○ |
| C-77 | Web Streams | E-01 (Streams) | ○ |
| C-78 | Blob | E-01 (Binary data) | ○ |
| C-79 | FormData | E-01 (Web APIs) | ○ |
| C-80 | TextEncoder/Decoder | E-01 (Web APIs) | ○ |
| C-81 | crypto | E-01 (Web APIs) | ○ |
| C-82 | Console | E-01 (Console) | ○ |
| C-83 | Workers | E-01 (Workers) | ○ |
| C-84 | Archive | E-05 (Archive.zig) | ○ |
| C-85 | JSON5 | E-05 (JSON5Object.zig) | ○ |
| C-86 | JSONC | E-05 (JSONCObject.zig) | ○ |
| C-87 | node:fs | E-06 (node_fs.zig) | ○ |
| C-88 | node:path | E-06 (path.zig) | ○ |
| C-89 | node:os | E-06 (node_os.zig) | ○ |
| C-90 | node:crypto | E-06 (node_crypto_binding.zig) | ○ |
| C-91 | node:http/https | E-07 (http.ts) | ○ |
| C-92 | node:http2 | E-07 (http2.ts) | ○ |
| C-93 | node:net | E-07 (net.ts) | ○ |
| C-94 | node:dgram | E-07 (dgram.ts) | ○ |
| C-95 | node:child_process | E-07 (child_process.ts) | ○ |
| C-96 | node:events | E-07 (events.ts) | ○ |
| C-97 | node:stream | E-01 (Node.js compatibility) | ○ |
| C-98 | node:buffer | E-06 (buffer.zig) | ○ |
| C-99 | node:util | E-06 (node_util_binding.zig) | ○ |
| C-100 | node:zlib | E-06 (node_zlib_binding.zig) | ○ |
| C-101 | node:assert | E-06 (node_assert.zig) | ○ |
| C-102 | node:dns | E-07 (dns.ts) | ○ |
| C-103 | node:process | E-06 (node_process.zig) | ○ |
| C-104 | node:async_hooks | E-07 (async_hooks.ts) | ○ |
| C-105 | node:diagnostics_channel | E-07 (diagnostics_channel.ts) | ○ |
| C-106 | node:inspector | E-07 (inspector.ts) | ○ |
| C-107 | node:cluster | E-06 (node_cluster_binding.zig) | ○ |
| C-108 | Bake | E-15 (bake/) | ○ |
| C-109 | DevServer | E-15 (DevServer.zig) | ○ |
| C-110 | HMR | E-15 (hmr-module.ts) | ○ |
| C-111 | FrameworkRouter | E-15 (FrameworkRouter.zig) | ○ |
| C-112 | デバッガー | E-05 (Debugger.zig) | ○ |
| C-113 | クラッシュレポート | E-02 (crash_handler.zig) | ○ |
| C-114 | イベントループ | E-02 (event_loop/) | ○ |
| C-115 | メモリアロケータ | E-02 (allocators/) | ○ |
| C-116 | JavaScriptCoreバインディング | E-16 (bindings/) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし - すべての機能について、ソースコードまたはドキュメントから根拠を確認しました

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対してソースコードレベルの根拠が存在します
- 機能の詳細な動作仕様については、各ソースファイルを直接参照することを推奨します

## 6) レビュアーチェックリスト（最小）
- [ ] カテゴリ分類が適切か確認
- [ ] 機能名が正式名称と一致しているか確認
- [ ] 説明文が実装内容を正確に反映しているか確認
- [ ] 備考欄のソースファイルパスが正しいか確認
- [ ] 抜け漏れている機能がないか確認
- [ ] 廃止予定（deprecated）の機能が含まれていないか確認
