# 機能設計書 1-JavaScript/TypeScript実行

## 概要

本ドキュメントは、BunランタイムにおけるJavaScript/TypeScript実行機能の設計仕様を定義する。

### 本機能の処理概要

本機能は、JavaScriptおよびTypeScriptファイルを直接実行するBunの中核機能である。WebKit JavaScriptCoreエンジンを使用し、高速なコード実行を実現する。

**業務上の目的・背景**：Node.jsと比較して高速なJavaScript実行環境を提供することで、開発者の生産性向上とアプリケーションのパフォーマンス改善を実現する。TypeScriptを事前コンパイルなしで直接実行できることにより、開発ワークフローを大幅に簡素化する。

**機能の利用シーン**：サーバーサイドアプリケーションの起動、CLIツールの実行、スクリプトの実行、開発時のコード検証など、あらゆるJavaScript/TypeScript実行場面で利用される。

**主要な処理内容**：
1. コマンドライン引数の解析とファイルパスの特定
2. ファイルの読み込みとソースコードの取得
3. TypeScript/JSX/TSXの場合はトランスパイル処理
4. JavaScriptCoreエンジンでのコード実行
5. モジュール解決と依存関係の動的ロード
6. 実行結果の出力と終了コードの返却

**関連システム・外部連携**：WebKit JavaScriptCoreエンジンとの連携、ファイルシステムアクセス、npmレジストリとの連携（モジュール解決時）

**権限による制御**：ファイルシステムアクセス権限に基づく実行制御、環境変数による動作制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | run | 主画面 | ファイル実行時のJavaScript/TypeScriptコードの解釈と実行 |

## 機能種別

計算処理 / コード実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| file_path | string | Yes | 実行するファイルのパス | 有効なファイルパスであること |
| args | string[] | No | スクリプトに渡す引数 | - |
| --watch | boolean | No | ファイル変更時の自動再実行 | - |
| --hot | boolean | No | ホットリロードモード | - |
| -e, --eval | string | No | 文字列として渡されたコードを実行 | - |

### 入力データソース

- ファイルシステム（実行対象ファイル）
- コマンドライン引数
- 環境変数（.envファイル含む）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| stdout | string | 標準出力 |
| stderr | string | 標準エラー出力 |
| exitCode | number | 終了コード（0: 成功、非0: エラー） |

### 出力先

- 標準出力（console.log等）
- 標準エラー出力（console.error等）
- プロセス終了コード

## 処理フロー

### 処理シーケンス

```
1. CLI引数解析
   └─ Commandモジュールで引数をパースし実行モードを決定
2. ファイル読み込み
   └─ 指定されたパスからソースコードを読み込み
3. ローダー判定
   └─ ファイル拡張子に基づきローダー（ts, tsx, js, jsx等）を決定
4. トランスパイル
   └─ TypeScript/JSX/TSXの場合はJavaScriptへ変換
5. JavaScriptCore実行
   └─ トランスパイル済みコードをJSCエンジンで実行
6. モジュール解決
   └─ import/require発生時に依存モジュールを解決・ロード
7. 実行完了
   └─ 終了コードを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数解析]
    B --> C{ファイル存在?}
    C -->|No| D[エラー出力]
    D --> E[終了コード1]
    C -->|Yes| F[ファイル読み込み]
    F --> G{TypeScript/JSX?}
    G -->|Yes| H[トランスパイル]
    G -->|No| I[JavaScriptCore実行]
    H --> I
    I --> J{実行成功?}
    J -->|Yes| K[終了コード0]
    J -->|No| L[エラー出力]
    L --> M[終了コード1]
    K --> N[終了]
    M --> N
    E --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 拡張子自動判定 | .ts, .tsx, .js, .jsx, .mjs, .cjs, .mts, .ctsを自動判定 | ファイル実行時 |
| BR-02 | ESM/CJS自動判定 | package.jsonのtypeフィールドに基づきモジュール形式を判定 | モジュール読み込み時 |
| BR-03 | TypeScript型削除 | 型注釈は実行時に自動的に削除される | TypeScriptファイル実行時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルシステム操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル未検出 | 指定ファイルが存在しない | 正しいファイルパスを指定 |
| SyntaxError | 構文エラー | JavaScript/TypeScriptの構文が不正 | コードを修正 |
| TypeError | 型エラー | 実行時の型不一致 | コードを修正 |
| MODULE_NOT_FOUND | モジュール未検出 | import/requireしたモジュールが存在しない | パッケージをインストール |

### リトライ仕様

該当なし（エラー時は即座に終了）

## トランザクション仕様

該当なし

## パフォーマンス要件

- コールドスタート: 50ms以内
- トランスパイル: 10ms以内（1000行程度のTypeScriptファイル）
- モジュール解決: 1ms以内（キャッシュヒット時）

## セキュリティ考慮事項

- eval()の使用は可能だが、信頼できないコードの実行には注意が必要
- ファイルシステムアクセスはプロセス権限に従う
- 環境変数は適切にサニタイズして使用すること

## 備考

WebKit JavaScriptCoreエンジンを使用しているため、V8エンジン固有の機能（v8モジュール等）は一部制限がある。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パース結果とAST構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | transpiler.zig | `src/transpiler.zig` | ParseResult構造体でパース結果のデータ構造を理解 |
| 1-2 | js_ast.zig | `src/js_ast.zig` | AST（抽象構文木）の構造定義 |

**読解のコツ**: Zigのunion型とpacked struct構造に注目。ParseResult.AlreadyBundledでバイトコードキャッシュの仕組みを確認できる。

#### Step 2: エントリーポイントを理解する

処理の起点となるCLIモジュールを特定。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cli.zig | `src/cli.zig` | Cli.start()がメインエントリーポイント |
| 2-2 | bun.zig | `src/bun.zig` | ランタイム全体のモジュール定義 |

**主要処理フロー**:
1. **11-25行目**: Cli.start()でアロケータ初期化とCommand.start()呼び出し
2. **7-29行目**: Cli構造体でログとコマンドタグを管理

#### Step 3: コマンド実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | run_command.zig | `src/cli/run_command.zig` | RunCommand構造体でファイル実行処理を実装 |

**主要処理フロー**:
- **208-268行目**: runPackageScriptForegroundでスクリプト実行
- **86-204行目**: replacePackageManagerRunでnpm/yarn/pnpmコマンドをbunに置換

#### Step 4: トランスパイラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | transpiler.zig | `src/transpiler.zig` | トランスパイラのメイン処理 |
| 4-2 | js_parser.zig | `src/js_parser.zig` | JavaScriptパーサーの実装 |

**読解のコツ**:
- js_parser.zigの冒頭コメント（104-116行目）で"P", "p.e", "p.b", "p.s"の省略記法を理解
- Expression/Binding/Statementの3要素でJavaScriptを表現

### プログラム呼び出し階層図

```
bun.zig (エントリーポイント)
    │
    ├─ cli.zig::Cli.start()
    │      └─ Command.start()
    │             └─ RunCommand.exec()
    │                    ├─ ファイル読み込み
    │                    └─ runPackageScriptForeground()
    │
    ├─ transpiler.zig::Transpiler
    │      └─ js_parser.zig::Parser
    │             └─ js_lexer.zig::Lexer
    │
    └─ JavaScriptCore (外部エンジン)
           └─ 実行結果
```

### データフロー図

```
[入力]               [処理]                    [出力]

コマンドライン ───▶ cli.zig ───▶ RunCommand
     │                              │
     ▼                              ▼
ソースファイル ───▶ transpiler.zig ───▶ JavaScript
     │                              │
     ▼                              ▼
     └─────▶ JavaScriptCore ───▶ 実行結果 ───▶ stdout/stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bun.zig | `src/bun.zig` | ソース | メインエントリーポイント、グローバル定義 |
| cli.zig | `src/cli.zig` | ソース | CLIコマンド処理のオーケストレーション |
| run_command.zig | `src/cli/run_command.zig` | ソース | ファイル/スクリプト実行コマンド |
| transpiler.zig | `src/transpiler.zig` | ソース | TypeScript/JSXトランスパイラ |
| js_parser.zig | `src/js_parser.zig` | ソース | JavaScriptパーサー |
| js_lexer.zig | `src/js_lexer.zig` | ソース | 字句解析器 |
| js_ast.zig | `src/js_ast.zig` | ソース | AST定義 |
| options.zig | `src/options.zig` | ソース | 実行オプション定義 |
