# 機能設計書 10-bun test

## 概要

本ドキュメントは、Jest互換のテストランナーを実行する`bun test`コマンドの設計仕様を定義する。

### 本機能の処理概要

本機能は、Jest互換のAPIを使用してテストファイルを実行するテストランナーを提供する。describe、test、expect等のJest標準APIをサポートし、スナップショットテスト、モック機能、コードカバレッジなどの高度な機能も備える。

**業務上の目的・背景**：ソフトウェア開発においてテストは品質保証の要である。BunはJest互換のテストランナーを内蔵することで、既存のJestテストコードをそのまま実行でき、かつBunの高速性を活かしてテスト実行時間を大幅に短縮する。

**機能の利用シーン**：単体テストの実行、統合テストの実行、CI/CDパイプラインでのテスト自動化、TDD開発でのテストサイクルなど。

**主要な処理内容**：
1. テストファイルの検索（*.test.ts、*.spec.ts等）
2. テストモジュールの読み込みとトランスパイル
3. describe/testブロックの解析と実行計画作成
4. テストケースの実行とアサーション評価
5. テスト結果の収集とレポート出力
6. 終了コードの返却

**関連システム・外部連携**：JavaScriptCoreエンジン、トランスパイラ、ファイルシステム

**権限による制御**：ファイルシステムアクセス権限に基づく

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | test | 主画面 | テストランナーの起動とテストファイルの実行 |

## 機能種別

テスト実行 / 品質保証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| test_files | string[] | No | テストファイルパターン | 有効なグロブパターン |
| -t, --test-name-pattern | string | No | 実行するテスト名のフィルター | 有効な正規表現 |
| --coverage | boolean | No | コードカバレッジを有効化 | - |
| --watch | boolean | No | ファイル変更時に自動再実行 | - |
| --bail | number | No | 指定数のテスト失敗で中断 | 正の整数 |
| --timeout | number | No | テストタイムアウト（ms） | 正の整数 |
| --junit | string | No | JUnitレポート出力パス | 有効なファイルパス |

### 入力データソース

- テストファイル（*.test.ts、*.spec.ts等）
- bunfig.toml（テスト設定）
- コマンドライン引数

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| pass_count | number | 成功テスト数 |
| fail_count | number | 失敗テスト数 |
| skip_count | number | スキップテスト数 |
| duration | number | 実行時間（ms） |
| junit_report | string | JUnitレポートXML（オプション） |

### 出力先

- 標準出力（テスト結果）
- 標準エラー出力（エラー詳細）
- JUnitレポートファイル（オプション）
- プロセス終了コード（0: 成功、1: 失敗）

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ bunfig.tomlとコマンドライン引数からテスト設定を取得
2. テストファイル検索
   └─ グロブパターンでテストファイルを検索
3. テストモジュール読み込み
   └─ 各テストファイルをトランスパイルして実行
4. テスト実行計画
   └─ describe/testブロックを解析して実行順序を決定
5. テスト実行
   └─ 各テストケースを実行しアサーションを評価
6. 結果収集
   └─ pass/fail/skipの結果を集計
7. レポート出力
   └─ コンソールおよびJUnitレポートに出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[設定読み込み]
    B --> C[テストファイル検索]
    C --> D{ファイル存在?}
    D -->|No| E[エラー: テストファイルなし]
    D -->|Yes| F[テストモジュール読み込み]
    F --> G[describe/test解析]
    G --> H[beforeAll実行]
    H --> I[テストケース実行]
    I --> J{すべて完了?}
    J -->|No| K[次のテスト]
    K --> I
    J -->|Yes| L[afterAll実行]
    L --> M[結果集計]
    M --> N{カバレッジ?}
    N -->|Yes| O[カバレッジレポート]
    N -->|No| P[レポート出力]
    O --> P
    P --> Q[終了コード返却]
    E --> R[終了]
    Q --> R
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ファイル命名規則 | *.test.ts、*.test.js、*.spec.ts、*.spec.jsをテストファイルと認識 | ファイル検索時 |
| BR-02 | 実行順序 | describe内のテストは定義順に実行 | テスト実行時 |
| BR-03 | 並列実行 | デフォルトでテストファイル単位で並列実行 | テスト実行時 |
| BR-04 | タイムアウト | デフォルト5000msでテストタイムアウト | テスト実行時 |
| BR-05 | 終了コード | 1つでも失敗があれば終了コード1 | 終了時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| TEST_FAILED | テスト失敗 | アサーションが失敗 | テストまたはコードを修正 |
| TIMEOUT | タイムアウト | テストが制限時間を超過 | タイムアウト延長またはテスト最適化 |
| SYNTAX_ERROR | 構文エラー | テストファイルの構文が不正 | テストファイルを修正 |

### リトライ仕様

- --retryオプションで失敗テストのリトライ回数を指定可能

## トランザクション仕様

該当なし

## パフォーマンス要件

- テストファイル起動: 100ms以内
- 単純なテストケース実行: 1ms以内
- 並列実行でCPUコア数に応じたスケーリング

## セキュリティ考慮事項

- テストコードは任意のコードを実行可能
- カバレッジレポートにはソースコードの情報が含まれる

## 備考

Jestとの互換性は高いが、一部の高度な機能（カスタムトランスフォーマー等）は未サポートの場合がある。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | jest.zig | `src/bun.js/test/jest.zig` | TestRunner構造体とFile構造体でテスト実行の基本構造を理解 |

**読解のコツ**: TestRunner.Summaryでpass/fail/skip/todoの集計構造を確認。File.ListでテストファイルのMultiArrayList管理を理解。

#### Step 2: テストコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | test_command.zig | `src/cli/test_command.zig` | テストコマンドのメイン処理とJUnitレポート生成を理解 |

**主要処理フロー**:
1. **4-41行目**: escapeXml()でXML特殊文字エスケープ
2. **42-68行目**: fmtStatusTextLine()でテスト結果の表示フォーマット
3. **73-300行目以降**: JunitReporter構造体でJUnitレポート生成

#### Step 3: Jestモジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | jest.zig | `src/bun.js/test/jest.zig` | Jest互換APIの提供とテスト実行を理解 |

**主要処理フロー**:
- **64-172行目**: TestRunner構造体
  - 100-128行目: Summary構造体でテスト結果集計
  - 130-151行目: shouldFileRunConcurrently()で並列実行判定
  - 153-171行目: getOrPutFile()でテストファイル管理
- **174-200行目**: Jest構造体とcreateTestModule()でJest API提供

#### Step 4: テストAPI提供を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | jest.zig | `src/bun.js/test/jest.zig` | test/describe/expect等のAPI登録を理解 |

**主要処理フロー**:
- **181-200行目**: createTestModule()でJest互換モジュール作成
  - test/it関数の登録
  - xtest/xit（スキップ）の登録
  - describe/xdescribeの登録
  - beforeEach/beforeAll/afterAll等のフック登録

### プログラム呼び出し階層図

```
bun test
    │
    ├─ cli.zig::Command
    │      └─ TestCommand判定
    │
    ├─ test_command.zig
    │      ├─ テストファイル検索
    │      ├─ JunitReporter初期化
    │      └─ テスト実行ループ
    │
    ├─ jest.zig::TestRunner
    │      ├─ getOrPutFile()
    │      ├─ テストケース実行
    │      └─ Summary集計
    │
    └─ Jest互換API
           ├─ describe()
           ├─ test()/it()
           ├─ expect()
           └─ beforeEach()/afterEach()等
```

### データフロー図

```
[入力]               [処理]                    [出力]

*.test.ts ───▶ TestRunner ───▶ テスト実行
                    │
                    ▼
              Summary集計 ───▶ pass/fail/skip
                    │
                    ▼
              JunitReporter ───▶ XML出力
                    │
                    ▼
              コンソール出力 ───▶ 結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| test_command.zig | `src/cli/test_command.zig` | ソース | bun testコマンドメイン実装 |
| jest.zig | `src/bun.js/test/jest.zig` | ソース | TestRunnerとJest API |
| snapshot.zig | `src/bun.js/test/snapshot.zig` | ソース | スナップショットテスト |
| expect.zig | `src/bun.js/test/expect.zig` | ソース | expectアサーション |
