# 機能設計書 108-Bake

## 概要

本ドキュメントは、BunにおけるBake機能の機能設計を記述したものである。Bakeは、クライアントサイドとサーバーサイドのWebアプリケーションを構築するためのツールキットであり、`Bun.build`と`Bun.serve`を組み合わせ、ホットリロード開発サーバー、サーバーコンポーネント、その他の統合機能を提供する。

### 本機能の処理概要

Bakeは、フレームワーク作成者がその上にフレームワークを構築できるように設計されたツールである。フレームワーク自体の役割を担うのではなく、フレームワークが利用する基盤を提供する。

**業務上の目的・背景**：モダンなWebアプリケーション開発では、サーバーサイドレンダリング（SSR）、クライアントサイドインタラクティビティ、ホットモジュールリプレースメント（HMR）を組み合わせた開発体験が求められる。Bakeは、これらの機能を統合し、フレームワーク非依存の形で提供する。

**機能の利用シーン**：
- Reactなどのフレームワークを使用したフルスタックWebアプリケーションの開発
- サーバーコンポーネント（React Server Components）を使用したアプリケーションの構築
- 静的サイト生成（SSG）とプリレンダリング
- ファイルシステムベースのルーティング

**主要な処理内容**：
1. `Framework`設定: フレームワーク固有のバンドラーオプションとルーティング設定
2. `FileSystemRouterType`: ファイルシステムからルートを自動検出
3. `DevServer`: 開発サーバーによるHMRとインクリメンタルビルド
4. `production`: プロダクションビルドと静的サイト生成

**関連システム・外部連携**：
- `Bun.serve`: HTTPサーバー統合
- `Bun.build`: バンドラー統合
- React Server Components: サーバーコンポーネントランタイム
- React Fast Refresh: ホットリロード

**権限による制御**：特になし

## 関連画面

本機能はバックエンドモジュールおよびビルドツールであり、直接的な関連画面は存在しない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

ビルドツール / サーバーサイドレンダリング / 開発サーバー

## 入力仕様

### 入力パラメータ

#### `Bake.Options`

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| framework | Framework \| "react" | Yes | フレームワーク設定または"react" | オブジェクトまたは"react" |
| bundlerOptions | BundlerOptions | No | バンドラーオプションのサブセット | - |
| plugins | BunPlugin[] | No | 追加のプラグイン | - |
| root | string | No | プロジェクトルートディレクトリ | デフォルト: cwd |

#### `Framework`

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| fileSystemRouterTypes | FileSystemRouterType[] | Yes | ルーティング設定 | 最大256個 |
| serverComponents | ServerComponentsOptions | No | サーバーコンポーネント設定 | - |
| reactFastRefresh | boolean \| ReactFastRefreshOptions | No | Fast Refresh設定 | - |
| builtInModules | BuiltInModule[] | No | 組み込みモジュール | - |
| bundlerOptions | BundlerOptions | No | バンドラーオプション | - |
| plugins | BunPlugin[] | No | フレームワークプラグイン | - |

#### `FileSystemRouterType`

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| root | string | Yes | ルートディレクトリ（例: "pages"） | - |
| prefix | string | No | URLプレフィックス（デフォルト: "/"） | - |
| serverEntryPoint | string | Yes | サーバーエントリーポイント | - |
| clientEntryPoint | string | No | クライアントエントリーポイント | - |
| style | string | Yes | ルーティングスタイル | "nextjs-pages" / "nextjs-app-ui" / "nextjs-app-routes" |
| extensions | string[] | No | ファイル拡張子 | デフォルト: .tsx, .jsx, .ts, .js |
| ignoreUnderscores | boolean | No | アンダースコア開始ファイルを無視 | - |
| layouts | boolean | No | レイアウトサポート | - |

### 入力データソース

- 設定ファイル（bun.app.ts または明示的なエントリーポイント）
- ファイルシステム（ルート検出）
- 環境変数（NODE_ENV等）

## 出力仕様

### 出力データ

#### 開発モード

| 項目名 | 型 | 説明 |
|--------|-----|------|
| クライアントバンドル | JavaScript | HMR対応クライアントコード |
| サーバーバンドル | JavaScript | サーバーサイドコード |
| ソースマップ | JSON | デバッグ用ソースマップ |
| HMRイベント | WebSocket | ホットアップデート通知 |

#### プロダクションモード

| 項目名 | 型 | 説明 |
|--------|-----|------|
| distディレクトリ | ファイル群 | 静的アセット |
| クライアントチャンク | JavaScript | 最適化されたクライアントコード |
| サーバーチャンク | JavaScript | サーバーサイドコード |
| プリレンダリングHTML | HTML | 静的生成されたページ |

### 出力先

- 開発: メモリ内（オンデマンド配信）
- プロダクション: distディレクトリ

## 処理フロー

### 処理シーケンス（開発モード）

```
1. 設定読み込み
   └─ bun.app.tsをロード・評価
2. フレームワーク初期化
   └─ Framework.fromJS()で設定をパース
3. DevServer初期化
   └─ DevServer.init()でサーバー起動
4. ルート検出
   └─ FrameworkRouter.scanAll()でファイルシステムをスキャン
5. リクエスト処理
   └─ オンデマンドでルートをバンドル
6. HMR監視
   └─ ファイル変更を検出してインクリメンタルビルド
```

### 処理シーケンス（プロダクションビルド）

```
1. 設定読み込み
   └─ bun build --app <config>
2. VM初期化
   └─ VirtualMachine.initBake()
3. ルート検出
   └─ FrameworkRouter.scanAll()
4. バンドル実行
   └─ BundleV2.generateFromBakeProductionCLI()
5. プリレンダリング
   └─ BakeRenderRoutesForProdStatic()
6. ファイル出力
   └─ distディレクトリに書き出し
```

### フローチャート

```mermaid
flowchart TD
    A[設定読み込み] --> B{モード?}
    B -->|Development| C[DevServer初期化]
    B -->|Production| D[プロダクションビルド]

    C --> E[FrameworkRouter初期化]
    E --> F[ルートスキャン]
    F --> G[HTTPサーバー起動]
    G --> H[リクエスト待機]
    H --> I{新規リクエスト?}
    I -->|Yes| J[オンデマンドバンドル]
    J --> K[レスポンス返却]
    K --> H
    I -->|ファイル変更| L[インクリメンタルビルド]
    L --> M[HMR通知]
    M --> H

    D --> N[全ルートバンドル]
    N --> O[クライアント/サーバー分離]
    O --> P[コード分割]
    P --> Q[プリレンダリング]
    Q --> R[ファイル出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-801 | フレームワーク必須 | framework設定は必須 | 常時 |
| BR-802 | React組み込みサポート | "react"文字列で組み込みReact設定を使用 | framework: "react" |
| BR-803 | ルートスタイル | nextjs-pages/nextjs-app-ui/nextjs-app-routesのいずれか | style設定時 |
| BR-804 | separateSSRGraph | サーバーとSSRで別グラフを使用 | serverComponents設定時 |
| BR-805 | インクリメンタルビルド | 変更ファイルのみ再バンドル | 開発モード |

### 計算ロジック

**ルートパターン解析**：
- Next.js Pages Router: `/pages/about.tsx` -> `/about`
- Next.js App Router: `/app/about/page.tsx` -> `/about`
- 動的ルート: `[param]` -> `:param`
- キャッチオール: `[...slug]` -> `:*slug`

**モード判定**：
- `import.meta.env.DEV`: 開発モードで`true`
- `import.meta.env.PROD`: プロダクションモードで`true`
- `import.meta.env.SSR`: サーバーサイドで`true`
- `import.meta.env.STATIC`: 静的ビルドで`true`

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーケース | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Missing framework | InvalidArguments | framework設定なし | framework設定を追加 |
| Invalid style | InvalidArguments | 不正なルーティングスタイル | 有効なスタイルを指定 |
| Module not found | ModuleNotFound | 依存モジュールが見つからない | 必要なパッケージをインストール |
| Route collision | RouteCollision | 同一パターンの重複ルート | ファイル名を変更 |
| Invalid route pattern | InvalidRoutePattern | 不正なルートパターン | パターン構文を修正 |

### リトライ仕様

- ファイル変更検出後、自動的に再ビルドを実行
- エラー時はエラーオーバーレイを表示し、修正後に自動リビルド

## トランザクション仕様

本機能はトランザクションを使用しない。

## パフォーマンス要件

- インクリメンタルビルド: 変更ファイルのみ再バンドル
- オンデマンドバンドル: 要求されたルートのみバンドル
- ソースマップ: 外部ファイルとして生成（インライン不可）

## セキュリティ考慮事項

- プロダクションビルドではファイルパスをハッシュ化
- ソースマップは本番環境では無効化可能
- 環境変数の露出制御

## 備考

- Bakeは高度に実験的であり、APIは変更される可能性がある
- React Server Componentsのサポートには実験版Reactが必要: `bun i react@experimental react-dom@experimental react-server-dom-bun react-refresh@experimental`
- `#bake` Discord チャンネルで開発状況を追跡可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントと基本構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | bake.zig | `src/bake.zig` | Bakeモジュールのメインエントリーポイント |

**読解のコツ**:
- **1-4行目**: Bakeの目的の説明（Bun.build + Bun.serveの統合）
- **5-7行目**: 主要モジュールのインポート（production, DevServer, FrameworkRouter）
- **13-116行目**: `UserOptions`構造体でJS設定をパース
- **246-823行目**: `Framework`構造体でフレームワーク設定を管理
- **254-295行目**: `Framework.react()`でReact組み込み設定を生成

#### Step 2: フレームワークルーターを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FrameworkRouter.zig | `src/bake/FrameworkRouter.zig` | ファイルシステムベースのルーティング |

**主要処理フロー**:
1. **10行目**: `OpaqueFileId`でファイルを一意に識別
2. **67-98行目**: `Route`構造体でルート情報を保持
3. **100-121行目**: `Type`構造体でルーティング設定を定義
4. **180-343行目**: `EncodedPattern`でルートパターンをエンコード
5. **459-687行目**: `Style`でルーティングスタイル（nextjs-pages等）を実装
6. **708-812行目**: `insert`でルートツリーにファイルを挿入
7. **851-866行目**: `matchSlow`でURLマッチング

#### Step 3: プロダクションビルドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | production.zig | `src/bake/production.zig` | プロダクションビルドの実装 |

**主要処理フロー**:
- **4-110行目**: `buildCommand`でCLIからビルドを実行
- **139-713行目**: `buildWithVm`で実際のビルド処理
- **236-266行目**: クライアント/サーバー/SSRトランスパイラーの初期化
- **313-324行目**: `BundleV2.generateFromBakeProductionCLI`でバンドル生成
- **685-712行目**: `BakeRenderRoutesForProdStatic`でプリレンダリング

#### Step 4: 開発サーバーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | DevServer.zig | `src/bake/DevServer.zig` | 開発サーバーの実装 |

**主要処理フロー**:
- **17-29行目**: `Options`構造体で初期化オプションを定義
- **61行目**: `router`フィールドでルートツリーを保持
- **68-69行目**: `client_graph`/`server_graph`でインクリメンタルグラフを管理
- **108-109行目**: `bun_watcher`/`directory_watchers`でファイル監視
- **150-156行目**: トランスパイラー（server/client/ssr）を保持
- **248-260行目**: 内部URLプレフィックス定義

### プログラム呼び出し階層図

```
[CLI / Bun.serve]
    │
    ├─ bake.UserOptions.fromJS(config)
    │      └─ Framework.fromJS(framework_config)
    │             └─ FileSystemRouterType設定パース
    │
    ├─ [Development Mode]
    │      │
    │      └─ DevServer.init(options)
    │             ├─ FrameworkRouter.initEmpty()
    │             ├─ FrameworkRouter.scanAll()
    │             │      └─ Style.parse() [nextjs-pages/app]
    │             ├─ HTTPサーバー起動
    │             └─ Watcher起動
    │                    └─ ファイル変更検出
    │                           └─ インクリメンタルビルド
    │
    └─ [Production Mode]
           │
           └─ production.buildCommand(ctx)
                  ├─ VirtualMachine.initBake()
                  ├─ Framework.resolve()
                  ├─ FrameworkRouter.scanAll()
                  ├─ BundleV2.generateFromBakeProductionCLI()
                  │      ├─ クライアントバンドル
                  │      ├─ サーバーバンドル
                  │      └─ SSRバンドル（separateSSRGraph時）
                  └─ BakeRenderRoutesForProdStatic()
                         └─ 各ルートをプリレンダリング
```

### データフロー図

```
[設定ファイル]                    [ファイルシステム]
     │                                  │
     ▼                                  ▼
UserOptions.fromJS() ────────▶ FrameworkRouter.scan()
     │                                  │
     ▼                                  ▼
Framework構造体 ─────────────▶ Route[]（ルートツリー）
     │                                  │
     ▼                                  ▼
Transpiler初期化 ───────────▶ BundleV2
     │                                  │
     ├─ client_transpiler               ├─ クライアントチャンク
     ├─ server_transpiler               ├─ サーバーチャンク
     └─ ssr_transpiler                  └─ ソースマップ
                                        │
                                        ▼
                                   [出力]
                                        │
     ┌──────────────────┬───────────────┘
     ▼                  ▼
[開発モード]        [プロダクション]
     │                  │
     ▼                  ▼
HMR WebSocket      dist/ディレクトリ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bake.zig | `src/bake.zig` | ソース | Bakeメインモジュール、Framework/UserOptions |
| production.zig | `src/bake/production.zig` | ソース | プロダクションビルド |
| DevServer.zig | `src/bake/DevServer.zig` | ソース | 開発サーバー |
| FrameworkRouter.zig | `src/bake/FrameworkRouter.zig` | ソース | ルーティング |
| RouteBundle.zig | `src/bake/DevServer/RouteBundle.zig` | ソース | ルートバンドル管理 |
| IncrementalGraph.zig | `src/bake/DevServer/IncrementalGraph.zig` | ソース | インクリメンタルグラフ |
| HmrSocket.zig | `src/bake/DevServer/HmrSocket.zig` | ソース | HMR WebSocket |
| bake.d.ts | `src/bake/bake.d.ts` | 型定義 | TypeScript型定義 |
| hmr-runtime-client.ts | `src/bake/hmr-runtime-client.ts` | ソース | クライアントHMRランタイム |
| hmr-runtime-server.ts | `src/bake/hmr-runtime-server.ts` | ソース | サーバーHMRランタイム |
| bun-framework-react/index.ts | `src/bake/bun-framework-react/index.ts` | ソース | React組み込みフレームワーク |
