# 機能設計書 11-bun build

## 概要

本ドキュメントは、Bunランタイムが提供するJavaScript/TypeScriptバンドラー機能「bun build」の設計を記述する。

### 本機能の処理概要

bun buildは、複数のJavaScript/TypeScriptファイルを単一または複数の最適化されたバンドルファイルに変換するCLIコマンドである。esbuildに似たAPIを提供しながら、Bunネイティブの高速処理を実現している。

**業務上の目的・背景**：モダンなWebアプリケーション開発では、モジュール分割されたソースコードをブラウザやサーバーで効率的に実行するために、バンドル処理が必要である。bun buildは、従来のwebpackやesbuildに代わる高速なバンドラーとして、開発・本番環境両方のビルドパイプラインを効率化する。

**機能の利用シーン**：
- 本番環境用の最適化されたJavaScriptバンドルの生成
- 複数エントリーポイントからのチャンク分割ビルド
- 単一実行ファイル（--compile）の生成
- 開発時のトランスパイルのみ（--no-bundle）処理
- React/Vue等のフレームワークのSSR用ビルド

**主要な処理内容**：
1. エントリーポイントファイルの解析とモジュール依存関係の解決
2. TypeScript/JSX/TSXのトランスパイル処理
3. ツリーシェイキングによる未使用コードの除去
4. コード分割（code splitting）とチャンク生成
5. ミニファイ（圧縮）処理
6. ソースマップの生成
7. 単一実行ファイルへのコンパイル

**関連システム・外部連携**：
- WebKit JavaScriptCoreエンジン
- ファイルシステム（入力ファイル読み込み、出力ファイル書き込み）
- 環境変数（NODE_ENV等のdefine置換）

**権限による制御**：特に権限による制御は行わない。ファイルシステムへのアクセス権限に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | build | 主画面 | bun buildコマンドの実行インターフェース |

## 機能種別

ビルド処理 / コード変換 / ファイル生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| entry_points | string[] | Yes | バンドルのエントリーポイントファイル | 存在するファイルパス |
| --outdir | string | No | 出力ディレクトリ | 有効なディレクトリパス |
| --outfile | string | No | 出力ファイル名（単一出力時） | 有効なファイルパス |
| --compile | boolean | No | 単一実行ファイルを生成 | - |
| --target | string | No | ターゲット環境（browser/bun/node） | browser/bun/node |
| --minify | boolean | No | コード圧縮を有効化 | - |
| --minify-syntax | boolean | No | 構文の圧縮のみ | - |
| --minify-whitespace | boolean | No | 空白の圧縮のみ | - |
| --minify-identifiers | boolean | No | 識別子の圧縮のみ | - |
| --sourcemap | string | No | ソースマップ生成（none/inline/external/linked） | none/inline/external/linked |
| --splitting | boolean | No | コード分割を有効化 | - |
| --no-bundle | boolean | No | バンドルせずトランスパイルのみ | - |
| --format | string | No | 出力形式（esm/cjs/iife） | esm/cjs/iife |
| --define | string[] | No | グローバル定数の置換定義 | KEY=VALUE形式 |
| --external | string[] | No | バンドルから除外するモジュール | パッケージ名 |
| --public-path | string | No | アセットの公開パス | URL形式 |
| --banner | string | No | 出力先頭に挿入するテキスト | - |
| --footer | string | No | 出力末尾に挿入するテキスト | - |
| --env | string | No | 環境変数の扱い（inline/disable） | inline/disable |

### 入力データソース

- エントリーポイントとして指定されたJavaScript/TypeScriptファイル
- プロジェクトのnode_modules内の依存パッケージ
- bunfig.toml設定ファイル
- 環境変数（.envファイル含む）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| output_files | OutputFile[] | 生成されたバンドルファイル群 |
| metafile | JSON | ビルドメタデータ（--metafile指定時） |
| sourcemaps | File[] | ソースマップファイル（設定時） |
| executable | File | 単一実行ファイル（--compile時） |

### 出力先

- --outdirで指定されたディレクトリ
- --outfileで指定されたファイル
- 標準出力（outdir/outfileなし、単一ファイルの場合）

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ build_command.zigでオプションを解析
2. Transpilerの初期化
   └─ transpiler.Transpiler.initでバンドラー設定を構築
3. オプションの設定
   └─ minify、sourcemap、target等の各種オプションを設定
4. ソースディレクトリの解決
   └─ エントリーポイントの共通親ディレクトリを特定
5. バンドル実行または変換実行
   └─ --no-bundleの場合はトランスパイルのみ
   └─ 通常はBundleV2.generateFromCLIでバンドル処理
6. メタファイル出力（オプション）
   └─ --metafile指定時にJSONを出力
7. 出力ファイルの書き込み
   └─ 各OutputFileをディスクに書き込み
8. --compile時の実行ファイル生成
   └─ StandaloneModuleGraph.toExecutableで実行ファイル化
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C[Transpiler初期化]
    C --> D{--no-bundle?}
    D -->|Yes| E[トランスパイルのみ]
    D -->|No| F[バンドル実行]
    E --> G{エラー?}
    F --> G
    G -->|Yes| H[エラー出力]
    G -->|No| I{--compile?}
    H --> Z[終了]
    I -->|Yes| J[実行ファイル生成]
    I -->|No| K[ファイル書き込み]
    J --> L[サマリー出力]
    K --> L
    L --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | outdir必須 | 複数エントリーポイント時は--outdirが必須 | entry_points.len > 1 |
| BR-02 | outdir必須 | code splitting有効時は--outdirが必須 | --splitting指定時 |
| BR-03 | compile排他 | --compileと--outdirは同時指定不可 | --compile指定時 |
| BR-04 | compile排他 | --compileと--no-bundleは同時指定不可 | --compile指定時 |
| BR-05 | external sourcemap | external sourcemapには--outdirが必要 | sourcemap=external |
| BR-06 | 予約語禁止 | 出力ファイル名に"bun"/"bunx"は使用不可 | --compile指定時 |

### 計算ロジック

- ツリーシェイキング: 静的解析により到達不能なコードを検出・除去
- チャンク分割: 動的import()境界で自動的にチャンクを分割
- ミニファイ: 識別子の短縮、空白除去、構文最適化を実行

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ValidationError | --compileと--outdirを同時指定 | どちらか一方のみを指定 |
| - | ValidationError | 複数エントリーで--outdir未指定 | --outdirを指定 |
| - | ValidationError | external sourcemapで--outdir未指定 | --outdirを指定 |
| - | FileNotFound | エントリーポイントが存在しない | 正しいパスを指定 |
| - | ParseError | 構文エラー | ソースコードを修正 |
| - | ResolveError | モジュール解決失敗 | パッケージをインストール |

### リトライ仕様

リトライは行わない。エラー発生時は即座に終了する。

## トランザクション仕様

本機能はファイルシステム操作のみであり、トランザクション管理は行わない。ビルド途中で失敗した場合、部分的に出力されたファイルが残る可能性がある。

## パフォーマンス要件

- Zigで実装された高速なパーサーとバンドラーにより、esbuild同等以上の速度を実現
- マルチスレッドによる並列処理
- 増分ビルドのサポート（watchモード）

## セキュリティ考慮事項

- 環境変数のインライン展開時、機密情報が含まれないよう注意が必要
- --compile生成時、ソースコードは実行ファイルに含まれる点に注意

## 備考

- HTMLファイルをエントリーポイントとした場合、関連するスクリプトとスタイルも自動的にバンドルされる
- --watchオプションでファイル変更の監視と自動リビルドが可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | options.zig | `src/options.zig` | OutputFile構造体、SourceMapOption列挙型など出力関連の型定義 |
| 1-2 | bundle_v2.zig | `src/bundler/bundle_v2.zig` | BundleV2構造体、DependencyScanner等のコアデータ構造 |

**読解のコツ**: Zigのstruct定義を先に理解し、どのようなデータがやり取りされるかを把握する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | build_command.zig | `src/cli/build_command.zig` | BuildCommand.exec関数がエントリーポイント |

**主要処理フロー**:
1. **2-43行目**: Transpilerの初期化
2. **52-91行目**: 各種オプションの設定（sourcemap, minify, code_splitting等）
3. **277-358行目**: バンドル実行とファイル出力の分岐処理
4. **312-330行目**: BundleV2.generateFromCLIの呼び出し
5. **433-514行目**: --compile時の実行ファイル生成処理

#### Step 3: バンドル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bundle_v2.zig | `src/bundler/bundle_v2.zig` | generateFromCLI関数、バンドル処理のメインロジック |
| 3-2 | transpiler.zig | `src/transpiler.zig` | Transpiler構造体、transform関数 |

**主要処理フロー**:
- generateFromCLI: エントリーポイントからの依存解決とバンドル生成
- transform: 単一ファイルのトランスパイル処理

#### Step 4: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | build_command.zig | `src/cli/build_command.zig` | writeToDisk呼び出し、printSummary関数 |

**主要処理フロー**:
- **536-541行目**: 各OutputFileのディスク書き込み
- **609-677行目**: ビルドサマリーの出力処理

### プログラム呼び出し階層図

```
BuildCommand.exec
    │
    ├─ transpiler.Transpiler.init
    │      └─ オプション設定
    │
    ├─ transpiler.transform (--no-bundle時)
    │      └─ 単一ファイル変換
    │
    ├─ BundleV2.generateFromCLI
    │      ├─ 依存関係解決
    │      ├─ ツリーシェイキング
    │      ├─ コード分割
    │      └─ OutputFile生成
    │
    ├─ OutputFile.writeToDisk
    │      └─ ファイル書き込み
    │
    └─ StandaloneModuleGraph.toExecutable (--compile時)
           └─ 実行ファイル生成
```

### データフロー図

```
[入力]                    [処理]                         [出力]

entry_points ───────▶ Transpiler.init ─────────────▶ Transpiler
                            │
                            ▼
bunfig.toml ────────▶ オプション設定
                            │
                            ▼
source files ───────▶ BundleV2.generateFromCLI ────▶ OutputFile[]
                            │
                            ▼
                     writeToDisk ──────────────────▶ バンドルファイル
                            │
                            ▼ (--compile時)
                     toExecutable ─────────────────▶ 実行ファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| build_command.zig | `src/cli/build_command.zig` | ソース | CLIエントリーポイント |
| bundle_v2.zig | `src/bundler/bundle_v2.zig` | ソース | バンドル処理のコア実装 |
| transpiler.zig | `src/transpiler.zig` | ソース | トランスパイラーラッパー |
| options.zig | `src/options.zig` | ソース | オプション・出力ファイル定義 |
| js_parser.zig | `src/js_parser.zig` | ソース | JavaScriptパーサー |
| js_printer.zig | `src/js_printer.zig` | ソース | JavaScript出力 |
| resolve_path.zig | `src/resolver/resolve_path.zig` | ソース | パス解決ユーティリティ |
