# 機能設計書 12-bun install

## 概要

本ドキュメントは、Bunランタイムが提供するパッケージインストール機能「bun install」の設計を記述する。

### 本機能の処理概要

bun installは、package.jsonに定義された依存関係を解決し、node_modulesにパッケージをインストールするCLIコマンドである。npmやyarnと互換性のあるパッケージマネージャーとして動作し、ハードリンクベースのグローバルキャッシュにより高速なインストールを実現する。

**業務上の目的・背景**：Node.jsエコシステムでは、プロジェクトの依存関係管理が必須である。bun installは、npm/yarn/pnpmに代わる高速なパッケージマネージャーとして、開発者の待ち時間を大幅に削減し、CI/CDパイプラインの効率化に貢献する。

**機能の利用シーン**：
- 新規プロジェクトのクローン後の依存関係インストール
- package.json更新後の依存関係同期
- CI/CD環境でのパッケージインストール
- ロックファイル（bun.lockb）からの再現可能なインストール
- monorepoワークスペースの一括インストール

**主要な処理内容**：
1. package.jsonの解析と依存関係の抽出
2. 依存関係ツリーの解決（バージョン競合の解決含む）
3. npmレジストリからのパッケージメタデータ取得
4. パッケージtarballのダウンロードと展開
5. グローバルキャッシュへの保存とハードリンク作成
6. node_modulesディレクトリ構造の構築
7. bun.lockbロックファイルの生成・更新
8. postinstall等のライフサイクルスクリプト実行

**関連システム・外部連携**：
- npmレジストリ（registry.npmjs.org）
- GitHubレジストリ（npm.pkg.github.com）
- プライベートレジストリ
- ファイルシステム（node_modules、グローバルキャッシュ）

**権限による制御**：特に権限による制御は行わない。ファイルシステムへのアクセス権限と、プライベートレジストリへの認証情報に依存する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 6 | install | 主画面 | bun installコマンドの実行インターフェース |

## 機能種別

パッケージ管理 / ファイル操作 / ネットワーク通信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --frozen-lockfile | boolean | No | ロックファイルの更新を禁止 | - |
| --no-save | boolean | No | package.jsonを更新しない | - |
| --production | boolean | No | devDependenciesをインストールしない | - |
| --dry-run | boolean | No | 実際のインストールを行わない | - |
| --force | boolean | No | キャッシュを無視して再インストール | - |
| --ignore-scripts | boolean | No | ライフサイクルスクリプトを実行しない | - |
| --trust | boolean | No | 信頼済みパッケージとしてスクリプト実行 | - |
| --registry | string | No | 使用するレジストリURL | 有効なURL |
| --cwd | string | No | 作業ディレクトリ | 有効なディレクトリパス |
| --global | boolean | No | グローバルインストール | - |
| --verbose | boolean | No | 詳細ログを出力 | - |
| --silent | boolean | No | ログ出力を抑制 | - |
| packages | string[] | No | 追加でインストールするパッケージ | パッケージ名[@バージョン] |

### 入力データソース

- package.json - 依存関係定義
- bun.lockb - ロックファイル（存在する場合）
- .npmrc - レジストリ設定、認証情報
- bunfig.toml - Bun固有の設定
- 環境変数（NPM_TOKEN、BUN_INSTALL等）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| node_modules | Directory | インストールされたパッケージ群 |
| bun.lockb | File | バイナリロックファイル |
| package.json | File | 更新されたpackage.json（--saveオプション時） |

### 出力先

- プロジェクトルートのnode_modulesディレクトリ
- プロジェクトルートのbun.lockbファイル
- グローバルキャッシュディレクトリ（~/.bun/install/cache）

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ CommandLineArguments.parseでオプションを解析
2. PackageManagerの初期化
   └─ package.jsonの読み込みと検証
3. ロックファイルの読み込み
   └─ bun.lockbが存在すれば解析
4. 依存関係の解決
   └─ バージョン制約を満たす最適なバージョンを決定
5. パッケージのダウンロード
   └─ キャッシュミス時にnpmレジストリからダウンロード
6. node_modulesへの展開
   └─ ハードリンクまたはコピーでファイルを配置
7. バイナリリンクの作成
   └─ node_modules/.binにパッケージバイナリをリンク
8. ロックファイルの更新
   └─ bun.lockbを生成または更新
9. ライフサイクルスクリプトの実行
   └─ postinstall等のスクリプトを実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C[PackageManager初期化]
    C --> D[package.json読み込み]
    D --> E{bun.lockb存在?}
    E -->|Yes| F[ロックファイル解析]
    E -->|No| G[依存関係解決開始]
    F --> H{frozen-lockfile?}
    H -->|Yes| I[ロックファイル通りにインストール]
    H -->|No| G
    G --> J[npmレジストリ問い合わせ]
    J --> K[バージョン解決]
    K --> L{キャッシュ存在?}
    L -->|Yes| M[キャッシュからリンク]
    L -->|No| N[ダウンロード・展開]
    I --> M
    M --> O[node_modules構築]
    N --> O
    O --> P[bun.lockb更新]
    P --> Q{スクリプト実行?}
    Q -->|Yes| R[postinstall実行]
    Q -->|No| S[完了]
    R --> S
    S --> T[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | ロックファイル優先 | bun.lockb存在時はロックファイルのバージョンを優先 | bun.lockb存在時 |
| BR-02 | frozen-lockfile | ロックファイルと不整合がある場合はエラー | --frozen-lockfile指定時 |
| BR-03 | production除外 | devDependenciesをインストールしない | --production指定時 |
| BR-04 | 依存関係重複排除 | 同一パッケージは可能な限り巻き上げ（hoisting） | 常時 |
| BR-05 | ピア依存警告 | peerDependenciesの不足を警告 | 常時 |
| BR-06 | 信頼スクリプト | 信頼済みパッケージのみpostinstall実行 | デフォルト |

### 計算ロジック

- 依存関係解決: semverに従ったバージョンマッチングアルゴリズム
- ホイスティング: 依存関係ツリーのフラット化による重複排除
- キャッシュキー: パッケージ名+バージョン+integrity hashによる一意識別

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InstallFailed | InstallError | インストール処理全般の失敗 | エラーログを確認 |
| InvalidPackageJSON | ParseError | package.jsonの形式が不正 | package.jsonを修正 |
| HTTP404 | NetworkError | パッケージがレジストリに存在しない | パッケージ名を確認 |
| HTTP403 | AuthError | レジストリへのアクセス権限なし | 認証情報を設定 |
| VersionNotFound | ResolveError | 指定バージョンが存在しない | バージョン指定を修正 |
| PeerDependencyConflict | ResolveError | ピア依存の競合 | 依存関係を調整 |

### リトライ仕様

ネットワークエラー時は自動的にリトライを行う。

## トランザクション仕様

本機能はアトミックなトランザクションを保証しない。インストール途中で失敗した場合、node_modulesが中途半端な状態になる可能性がある。その場合はnode_modulesを削除して再実行する。

## パフォーマンス要件

- ハードリンクベースのキャッシュにより、2回目以降のインストールは高速化
- 並列ダウンロードによるネットワーク効率の最大化
- バイナリロックファイル（bun.lockb）による高速な依存関係読み込み

## セキュリティ考慮事項

- postinstall等のライフサイクルスクリプトは信頼済みパッケージのみ実行
- integrity hashによるパッケージ改竄検知
- プライベートレジストリの認証情報は環境変数または.npmrcで管理

## 備考

- pnpm-lock.yaml、yarn.lockからの移行をサポート
- ワークスペース（monorepo）機能をネイティブサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | lockfile.zig | `src/install/lockfile.zig` | Lockfile構造体、バイナリフォーマット |
| 1-2 | dependency.zig | `src/install/dependency.zig` | Dependency構造体、バージョン制約 |

**読解のコツ**: bun.lockbはバイナリ形式のため、lockfile.zigで定義されている構造を理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | install_command.zig | `src/cli/install_command.zig` | InstallCommand.exec関数がエントリーポイント |

**主要処理フロー**:
1. **2-13行目**: InstallCommand.exec - エラーハンドリング付きでinstall関数を呼び出し
2. **16-56行目**: install関数 - CLI引数パースとPackageManager初期化
3. **58-85行目**: installWithCLI - サブコマンド判定とインストール実行

#### Step 3: PackageManager処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PackageManager.zig | `src/install/PackageManager.zig` | PackageManager構造体、init/installWithManager関数 |
| 3-2 | npm.zig | `src/install/npm.zig` | npmレジストリとの通信処理 |

**主要処理フロー**:
- PackageManager.init: 初期化とpackage.json読み込み
- installWithManager: 実際のインストール処理実行

#### Step 4: ライフサイクルスクリプトを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | lifecycle_script_runner.zig | `src/install/lifecycle_script_runner.zig` | postinstall等のスクリプト実行 |

### プログラム呼び出し階層図

```
InstallCommand.exec
    │
    ├─ install
    │      ├─ CommandLineArguments.parse
    │      └─ installWithCLI
    │             │
    │             ├─ PackageManager.init
    │             │      └─ package.json読み込み
    │             │
    │             └─ installWithManager
    │                    ├─ 依存関係解決
    │                    ├─ npmレジストリ問い合わせ
    │                    ├─ ダウンロード・展開
    │                    ├─ node_modules構築
    │                    └─ ライフサイクルスクリプト実行
    │
    └─ エラーハンドリング
```

### データフロー図

```
[入力]                    [処理]                         [出力]

package.json ───────▶ PackageManager.init ──────────▶ 依存関係リスト
                            │
                            ▼
bun.lockb ──────────▶ Lockfile解析 ─────────────────▶ 解決済みバージョン
                            │
                            ▼
npmレジストリ ──────▶ パッケージダウンロード ────────▶ グローバルキャッシュ
                            │
                            ▼
                     node_modules構築 ──────────────▶ node_modules/
                            │
                            ▼
                     Lockfile更新 ──────────────────▶ bun.lockb
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| install_command.zig | `src/cli/install_command.zig` | ソース | CLIエントリーポイント |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージ管理のコア実装 |
| lockfile.zig | `src/install/lockfile.zig` | ソース | ロックファイル処理 |
| dependency.zig | `src/install/dependency.zig` | ソース | 依存関係データ構造 |
| npm.zig | `src/install/npm.zig` | ソース | npmレジストリ通信 |
| lifecycle_script_runner.zig | `src/install/lifecycle_script_runner.zig` | ソース | スクリプト実行 |
| pnpm.zig | `src/install/pnpm.zig` | ソース | pnpm互換処理 |
| yarn.zig | `src/install/yarn.zig` | ソース | yarn互換処理 |
