# 機能設計書 13-bun add

## 概要

本ドキュメントは、Bunランタイムが提供するパッケージ追加機能「bun add」の設計を記述する。

### 本機能の処理概要

bun addは、npmパッケージを依存関係に追加するCLIコマンドである。指定したパッケージをnpmレジストリから取得し、package.jsonに依存関係を追記した上でインストールを実行する。

**業務上の目的・背景**：プロジェクト開発において、新しいライブラリやツールを導入する際に、依存関係を適切に管理する必要がある。bun addは、npm add/yarn addと同等の機能を提供しながら、高速なインストール処理を実現する。

**機能の利用シーン**：
- 新しいライブラリのプロジェクトへの追加
- 特定バージョンのパッケージ指定インストール
- 開発依存（devDependencies）としてのツール追加
- GitHubリポジトリからの直接インストール
- ローカルパッケージのリンク追加

**主要な処理内容**：
1. パッケージ名とバージョン指定の解析
2. npmレジストリからのパッケージメタデータ取得
3. package.jsonへの依存関係追記
4. 依存関係ツリーの解決
5. パッケージのダウンロードとインストール
6. bun.lockbの更新

**関連システム・外部連携**：
- npmレジストリ
- GitHubリポジトリ（GitHub URLからのインストール時）
- ファイルシステム

**権限による制御**：特に権限による制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | add | 主画面 | bun addコマンドの実行インターフェース |

## 機能種別

パッケージ管理 / ファイル操作 / ネットワーク通信

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| packages | string[] | Yes | インストールするパッケージ名 | 有効なパッケージ名[@バージョン] |
| --dev / -d | boolean | No | devDependenciesに追加 | - |
| --optional | boolean | No | optionalDependenciesに追加 | - |
| --peer | boolean | No | peerDependenciesに追加 | - |
| --exact / -E | boolean | No | 正確なバージョンを指定 | - |
| --global / -g | boolean | No | グローバルインストール | - |
| --no-save | boolean | No | package.jsonを更新しない | - |
| --dry-run | boolean | No | 実際のインストールを行わない | - |
| --trust | boolean | No | スクリプト実行を許可 | - |

### 入力データソース

- コマンドライン引数（パッケージ名、オプション）
- package.json（既存の依存関係）
- npmレジストリ（パッケージメタデータ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| package.json | File | 依存関係が追加されたpackage.json |
| node_modules | Directory | インストールされたパッケージ |
| bun.lockb | File | 更新されたロックファイル |

### 出力先

- プロジェクトルートのpackage.json
- プロジェクトルートのnode_modules
- プロジェクトルートのbun.lockb

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ パッケージ名とオプションを解析
2. PackageManagerの初期化
   └─ package.jsonの読み込み
3. パッケージ名の正規化
   └─ スコープ、バージョン指定の解析
4. npmレジストリからメタデータ取得
   └─ 最新バージョンまたは指定バージョンの確認
5. package.jsonの更新
   └─ 適切なセクション（dependencies/devDependencies等）に追記
6. 依存関係の解決とインストール
   └─ installWithManagerを呼び出し
7. ロックファイルの更新
   └─ bun.lockbを更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C[PackageManager初期化]
    C --> D[パッケージ名解析]
    D --> E[npmレジストリ問い合わせ]
    E --> F{パッケージ存在?}
    F -->|No| G[エラー: パッケージが見つかりません]
    F -->|Yes| H[package.json更新]
    H --> I[依存関係解決]
    I --> J[インストール実行]
    J --> K[bun.lockb更新]
    K --> L[完了メッセージ出力]
    G --> M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | デフォルトdependencies | --devなし時はdependenciesに追加 | --dev未指定時 |
| BR-02 | バージョン指定 | @なしは最新安定版を使用 | バージョン未指定時 |
| BR-03 | 既存更新 | 既存パッケージは更新される | 同名パッケージ存在時 |
| BR-04 | exact指定 | ^や~なしの正確なバージョン | --exact指定時 |

### 計算ロジック

- バージョン解決: semverに従った最新互換バージョンの選択
- 依存関係重複排除: 既存の依存関係との整合性確認

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PackageNotFound | パッケージが存在しない | パッケージ名を確認 |
| - | VersionNotFound | 指定バージョンが存在しない | バージョン指定を修正 |
| - | NetworkError | レジストリに接続できない | ネットワーク確認 |

### リトライ仕様

ネットワークエラー時は自動リトライを行う。

## トランザクション仕様

package.jsonの更新とインストールはアトミックではない。エラー時にpackage.jsonのみ更新された状態になる可能性がある。

## パフォーマンス要件

bun installと同等の高速インストール処理。

## セキュリティ考慮事項

- 信頼できないパッケージのpostinstallスクリプトは--trust指定時のみ実行

## 備考

- `bun install <package>` と同等の動作をする

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | add_command.zig | `src/cli/add_command.zig` | AddCommand.exec関数 |

**主要処理フロー**:
1. **3行目**: updatePackageJSONAndInstallCatchErrorを.addモードで呼び出し

#### Step 2: 共通処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PackageManager.zig | `src/install/PackageManager.zig` | updatePackageJSONAndInstallCatchError関数 |

### プログラム呼び出し階層図

```
AddCommand.exec
    │
    └─ updatePackageJSONAndInstallCatchError(.add)
           │
           ├─ PackageManager.init
           ├─ package.json更新
           └─ installWithManager
```

### データフロー図

```
[入力]                    [処理]                         [出力]

パッケージ名 ───────▶ パッケージ解析 ──────────────▶ UpdateRequest
                            │
                            ▼
npmレジストリ ──────▶ メタデータ取得 ─────────────▶ バージョン情報
                            │
                            ▼
package.json ───────▶ 依存関係追記 ──────────────▶ 更新されたpackage.json
                            │
                            ▼
                     インストール実行 ─────────────▶ node_modules/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| add_command.zig | `src/cli/add_command.zig` | ソース | CLIエントリーポイント |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージ管理共通処理 |
