# 機能設計書 14-bun remove

## 概要

本ドキュメントは、Bunランタイムが提供するパッケージ削除機能「bun remove」の設計を記述する。

### 本機能の処理概要

bun removeは、プロジェクトの依存関係からパッケージを削除するCLIコマンドである。指定したパッケージをpackage.jsonから除去し、node_modulesから関連ファイルを削除する。

**業務上の目的・背景**：プロジェクト開発において、不要になったライブラリを適切に削除し、依存関係を整理する必要がある。bun removeは、npm uninstall/yarn removeと同等の機能を提供する。

**機能の利用シーン**：
- 不要になったライブラリの削除
- 依存関係の整理・クリーンアップ
- パッケージの入れ替え時の古いパッケージ削除

**主要な処理内容**：
1. パッケージ名の解析
2. package.jsonからの依存関係削除
3. node_modulesからのパッケージ削除
4. bun.lockbの更新

**関連システム・外部連携**：
- ファイルシステム（package.json、node_modules）

**権限による制御**：特に権限による制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | remove | 主画面 | bun removeコマンドの実行インターフェース |

## 機能種別

パッケージ管理 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| packages | string[] | Yes | 削除するパッケージ名 | 有効なパッケージ名 |
| --dev / -d | boolean | No | devDependenciesから削除 | - |
| --global / -g | boolean | No | グローバルパッケージを削除 | - |

### 入力データソース

- コマンドライン引数（パッケージ名）
- package.json（現在の依存関係）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| package.json | File | 依存関係が削除されたpackage.json |
| node_modules | Directory | パッケージが削除されたnode_modules |
| bun.lockb | File | 更新されたロックファイル |

### 出力先

- プロジェクトルートのpackage.json
- プロジェクトルートのnode_modules
- プロジェクトルートのbun.lockb

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ 削除するパッケージ名を取得
2. PackageManagerの初期化
   └─ package.jsonの読み込み
3. package.jsonから依存関係削除
   └─ dependencies/devDependencies等から該当エントリを削除
4. インストール処理実行
   └─ 削除を反映したインストール
5. ロックファイルの更新
   └─ bun.lockbを更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C[PackageManager初期化]
    C --> D{パッケージ存在?}
    D -->|No| E[警告: パッケージが見つかりません]
    D -->|Yes| F[package.json更新]
    F --> G[依存関係再解決]
    G --> H[node_modules更新]
    H --> I[bun.lockb更新]
    I --> J[完了]
    E --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 全セクション検索 | dependencies/devDependencies両方から検索 | --dev未指定時 |
| BR-02 | 依存パッケージ警告 | 他パッケージが依存している場合は警告 | 常時 |

### 計算ロジック

依存関係ツリーの再計算により、不要になったパッケージを自動的に検出・削除。

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | PackageNotFound | 指定パッケージが依存関係に存在しない | パッケージ名を確認 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

package.jsonの更新とnode_modulesの削除はアトミックではない。

## パフォーマンス要件

高速な依存関係再解決とファイル削除。

## セキュリティ考慮事項

特になし。

## 備考

`bun uninstall` はbun removeのエイリアス。

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | remove_command.zig | `src/cli/remove_command.zig` | RemoveCommand.exec関数 |

**主要処理フロー**:
1. **3行目**: updatePackageJSONAndInstallCatchErrorを.removeモードで呼び出し

### プログラム呼び出し階層図

```
RemoveCommand.exec
    │
    └─ updatePackageJSONAndInstallCatchError(.remove)
           │
           ├─ PackageManager.init
           ├─ package.json更新（削除）
           └─ installWithManager
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| remove_command.zig | `src/cli/remove_command.zig` | ソース | CLIエントリーポイント |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージ管理共通処理 |
