# 機能設計書 15-bun update

## 概要

本ドキュメントは、Bunランタイムが提供するパッケージ更新機能「bun update」の設計を記述する。

### 本機能の処理概要

bun updateは、プロジェクトの依存関係を最新バージョンに更新するCLIコマンドである。package.jsonで指定されたセマンティックバージョン範囲内で、最新の互換バージョンにパッケージを更新する。

**業務上の目的・背景**：セキュリティパッチや新機能を含む最新バージョンへの更新は、プロジェクトのメンテナンスにおいて重要である。bun updateは、npm update/yarn upgradeと同等の機能を提供する。

**機能の利用シーン**：
- セキュリティ脆弱性対応のためのパッケージ更新
- 新機能利用のためのバージョンアップ
- 依存関係の定期的なメンテナンス
- 特定パッケージのみの選択的更新

**主要な処理内容**：
1. 現在の依存関係バージョンの確認
2. npmレジストリから最新バージョン情報取得
3. セマンティックバージョン範囲内での更新判定
4. パッケージのダウンロードと更新
5. bun.lockbの更新

**関連システム・外部連携**：
- npmレジストリ
- ファイルシステム

**権限による制御**：特に権限による制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | update | 主画面 | bun updateコマンドの実行インターフェース |

## 機能種別

パッケージ管理 / ネットワーク通信 / ファイル操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| packages | string[] | No | 更新するパッケージ名（省略時は全パッケージ） | 有効なパッケージ名 |
| --latest | boolean | No | semver範囲を無視して最新版に更新 | - |
| --dry-run | boolean | No | 実際の更新を行わない | - |

### 入力データソース

- コマンドライン引数
- package.json
- bun.lockb
- npmレジストリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| node_modules | Directory | 更新されたパッケージ |
| bun.lockb | File | 更新されたロックファイル |

### 出力先

- プロジェクトルートのnode_modules
- プロジェクトルートのbun.lockb

## 処理フロー

### 処理シーケンス

```
1. CLI引数のパース
   └─ 更新対象パッケージとオプションを取得
2. PackageManagerの初期化
   └─ package.jsonとbun.lockbの読み込み
3. npmレジストリから最新情報取得
   └─ 各パッケージの利用可能バージョンを確認
4. 更新可能バージョンの判定
   └─ semver範囲内で最新のバージョンを選択
5. パッケージのダウンロードと更新
   └─ 新しいバージョンをインストール
6. ロックファイルの更新
   └─ bun.lockbを更新
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[CLI引数パース]
    B --> C[PackageManager初期化]
    C --> D[現在バージョン確認]
    D --> E[npmレジストリ問い合わせ]
    E --> F{更新可能?}
    F -->|No| G[更新なしメッセージ]
    F -->|Yes| H[パッケージダウンロード]
    H --> I[node_modules更新]
    I --> J[bun.lockb更新]
    J --> K[更新サマリー出力]
    G --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | semver遵守 | package.jsonのバージョン指定範囲を遵守 | --latest未指定時 |
| BR-02 | 破壊的変更回避 | メジャーバージョンは自動更新しない | --latest未指定時 |
| BR-03 | 全パッケージ更新 | 引数なし時は全パッケージを更新 | パッケージ未指定時 |

### 計算ロジック

- semver比較による最新互換バージョンの選択
- 依存関係グラフの再計算

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NetworkError | レジストリに接続できない | ネットワーク確認 |
| - | PackageNotFound | 指定パッケージが依存関係に存在しない | パッケージ名を確認 |

### リトライ仕様

ネットワークエラー時は自動リトライ。

## トランザクション仕様

アトミックな更新は保証されない。

## パフォーマンス要件

並列ダウンロードによる高速更新。

## セキュリティ考慮事項

特になし。

## 備考

特になし。

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | update_command.zig | `src/cli/update_command.zig` | UpdateCommand.exec関数 |

**主要処理フロー**:
1. **3行目**: updatePackageJSONAndInstallCatchErrorを.updateモードで呼び出し

### プログラム呼び出し階層図

```
UpdateCommand.exec
    │
    └─ updatePackageJSONAndInstallCatchError(.update)
           │
           ├─ PackageManager.init
           ├─ レジストリ問い合わせ
           ├─ バージョン解決
           └─ installWithManager
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| update_command.zig | `src/cli/update_command.zig` | ソース | CLIエントリーポイント |
| PackageManager.zig | `src/install/PackageManager.zig` | ソース | パッケージ管理共通処理 |
